/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.move;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateTypeEntryChange;
import org.eclipse.fordiac.ide.ui.editors.FordiacEditorMatchingStrategy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class UpdateTypeEntryFileChange
extends UpdateTypeEntryChange {
    private final IFile destinationFile;
    private static FordiacEditorMatchingStrategy editorMatching = new FordiacEditorMatchingStrategy();

    public UpdateTypeEntryFileChange(IFile currentFile, TypeEntry typeEntry, IFile destinationFile) {
        super(currentFile, typeEntry, typeEntry.getTypeName(), typeEntry.getTypeName());
        this.destinationFile = destinationFile;
    }

    @Override
    public String getName() {
        return Messages.MoveTypeToPackage_UpdateTypeEntryFile;
    }

    @Override
    protected boolean shouldSaveFile(Shell shell, String oldName) {
        int result = MessageDialog.open((int)3, (Shell)shell, (String)"Moving of Type with unsaved changes!", (String)MessageFormat.format("There are unsaved changes for type \"{0}\". Do you want to save them before moving it?", oldName), (int)0, (String[])new String[]{"Save", "Cancel"});
        return result == 0;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        if (this.destinationFile != null) {
            TypeLibrary typeLibrary = this.typeEntry.getTypeLibrary();
            if (typeLibrary != null) {
                typeLibrary.removeTypeEntry(this.typeEntry);
            }
            if (!this.destinationFile.getProject().equals((Object)this.file.getProject())) {
                TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeLibrary(this.destinationFile.getProject()).createTypeEntry(this.destinationFile);
                UpdateTypeEntryFileChange.closeEditors(this.file);
                return new UpdateTypeEntryFileChange(this.destinationFile, entry, this.file);
            }
            this.typeEntry.setFile(this.destinationFile);
            if (typeLibrary != null) {
                typeLibrary.addTypeEntry(this.typeEntry);
            }
            return new UpdateTypeEntryFileChange(this.destinationFile, this.typeEntry, this.file);
        }
        return null;
    }

    private static void closeEditors(IFile src) {
        Display.getDefault().asyncExec(() -> {
            IEditorReference[] editorReferences;
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorMatching.matches(editorReference, (IEditorInput)new FileEditorInput(src))) {
                    activePage.closeEditors(new IEditorReference[]{editorReference}, false);
                }
                ++n2;
            }
        });
    }
}

