/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class SubordinateUpdateManager
extends UpdateManager {
    protected IFigure root;
    protected GraphicsSource graphicsSource;

    @Override
    public void addDirtyRegion(IFigure f, int x, int y, int w, int h) {
        if (this.getSuperior() == null) {
            return;
        }
        this.getSuperior().addDirtyRegion(f, x, y, w, h);
    }

    @Override
    public void addInvalidFigure(IFigure f) {
        UpdateManager um = this.getSuperior();
        if (um == null) {
            return;
        }
        um.addInvalidFigure(f);
    }

    protected abstract IFigure getHost();

    protected UpdateManager getSuperior() {
        if (this.getHost().getParent() == null) {
            return null;
        }
        return this.getHost().getParent().getUpdateManager();
    }

    @Override
    public void performUpdate() {
        UpdateManager um = this.getSuperior();
        if (um == null) {
            return;
        }
        um.performUpdate();
    }

    @Override
    public void performUpdate(Rectangle rect) {
        UpdateManager um = this.getSuperior();
        if (um == null) {
            return;
        }
        um.performUpdate(rect);
    }

    @Override
    public void setRoot(IFigure f) {
        this.root = f;
    }

    @Override
    public void setGraphicsSource(GraphicsSource gs) {
        this.graphicsSource = gs;
    }
}

