/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.commands;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class OrganizeImportsCommand
extends Command
implements ScopedCommand {
    private final LibraryElement libraryElement;
    private EList<Import> oldImports;
    private EList<Import> newImports;
    private boolean incompleteResult;

    public OrganizeImportsCommand(LibraryElement libraryElement) {
        this.libraryElement = Objects.requireNonNull(libraryElement);
    }

    public void execute() {
        this.oldImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        try {
            try {
                Set<String> importedNamespaces = this.getAllImportedNamespaces((EObject)this.libraryElement);
                ImportHelper.organizeImports((LibraryElement)this.libraryElement, importedNamespaces, (!this.incompleteResult ? 1 : 0) != 0);
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)"Error organizing imports", (Throwable)e);
                this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
            }
        }
        finally {
            this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        }
    }

    private Set<String> getAllImportedNamespaces(EObject object) {
        HashSet<String> dependencies = new HashSet<String>();
        TreeIterator contents = object.eAllContents();
        while (contents.hasNext()) {
            FBNetwork network;
            EObject content = (EObject)contents.next();
            if (content instanceof FBNetwork && ((network = (FBNetwork)content).eContainer() instanceof TypedSubApp || network.eContainer() instanceof CFBInstance)) {
                contents.prune();
                continue;
            }
            this.getImportedNamespaces(content, dependencies);
        }
        return dependencies;
    }

    private void getImportedNamespaces(EObject object, Set<String> dependencies) {
        ISearchSupport support = ISearchFactory.createSearchSupport((Object)object, (Class)object.eClass().getInstanceClass());
        if (support != null) {
            dependencies.addAll(support.getImportedNamespaces());
            this.incompleteResult |= support.isIncompleteResult();
        }
    }

    public void redo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.newImports);
    }

    public void undo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.oldImports);
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.libraryElement);
    }
}

