/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.delete;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.AnyType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEditChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateManipulatorModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteAttributeModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteUpdateFBTypeInterfaceModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.DeleteUpdateStructDataTypeMemberVariableModelEdit;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.UpdateUntypedSubappPinModelEdit;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class SafeStructDeletionChange
extends CompositeChange {
    private final List<ModelEdit<?>> changes = new ArrayList();

    public SafeStructDeletionChange(StructuredType struct) {
        super(MessageFormat.format(Messages.DeleteFBTypeParticipant_Change_SafeDeletionChangeTitle, struct.getName()));
        this.createChanges((DataTypeEntry)struct.getTypeEntry());
        CompositeChange comp = ModelEditChange.fromModelEdits("", this.changes);
        if (comp != null) {
            this.merge(comp);
        }
    }

    public void createChanges(DataTypeEntry entry) {
        HashSet doneElements = new HashSet();
        if (entry != null) {
            List results = new DataTypeInstanceSearch(entry).performSearch();
            results.forEach(eObject -> {
                StructManipulator muxer;
                VarDeclaration varDecl;
                if (eObject instanceof VarDeclaration && doneElements.add(varDecl = (VarDeclaration)eObject)) {
                    if (varDecl.eContainer() instanceof StructuredType) {
                        this.changes.add(new DeleteUpdateStructDataTypeMemberVariableModelEdit(varDecl));
                        this.handleTransitiveRefactoring(varDecl, doneElements);
                    } else if (SafeStructDeletionChange.isUntypedSubappPin(varDecl)) {
                        this.changes.add(new UpdateUntypedSubappPinModelEdit(varDecl));
                    } else if (SafeStructDeletionChange.isFbTypePin(varDecl)) {
                        this.handleTransitiveRefactoring(varDecl, doneElements);
                    }
                } else if (eObject instanceof StructManipulator && doneElements.add(muxer = (StructManipulator)eObject)) {
                    this.changes.add(new UpdateManipulatorModelEdit(muxer));
                } else if (eObject instanceof Attribute) {
                    Attribute attribute = (Attribute)eObject;
                    this.changes.add(new DeleteAttributeModelEdit(attribute, (AnyType)IecTypes.GenericTypes.ANY_STRUCT));
                }
            });
        }
    }

    private void handleTransitiveRefactoring(VarDeclaration varDecl, Set<EObject> rootElements) {
        DataTypeEntry dataTypeEntry = (DataTypeEntry)varDecl.getType().getTypeEntry();
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)varDecl);
        if (varDecl.getBlockFBNetworkElement() != null) {
            if (rootElements.add((EObject)varDecl.getBlockFBNetworkElement())) {
                this.changes.add(new UpdateFBInstanceModelEdit(varDecl.getBlockFBNetworkElement(), (TypeEntry)dataTypeEntry));
            }
        } else if (rootElements.add(rootContainer)) {
            if (rootContainer instanceof StructuredType) {
                StructuredType stElement = (StructuredType)rootContainer;
                this.createChanges((DataTypeEntry)stElement.getTypeEntry());
            } else if (rootContainer instanceof FBType) {
                FBType fbType = (FBType)rootContainer;
                AnyDerivedType anyDerivedType = dataTypeEntry.getType();
                if (anyDerivedType instanceof StructuredType) {
                    StructuredType type = (StructuredType)anyDerivedType;
                    this.changes.add(new DeleteUpdateFBTypeInterfaceModelEdit(fbType, type));
                }
            }
        }
    }

    private static boolean isUntypedSubappPin(VarDeclaration varDecl) {
        SubApp sub;
        EObject eObject;
        return varDecl.eContainer() != null && (eObject = varDecl.eContainer().eContainer()) instanceof SubApp && !(sub = (SubApp)eObject).isTyped() && !sub.isContainedInTypedInstance();
    }

    private static boolean isFbTypePin(VarDeclaration varDecl) {
        return varDecl.eContainer() != null && varDecl.eContainer().eContainer() instanceof FBType;
    }
}

