/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Tarjan;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p1cycles.GroupModelOrderCalculator;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public abstract class SCCModelOrderCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    protected List<Set<LNode>> stronglyConnectedComponents = new LinkedList<Set<LNode>>();
    protected HashMap<LNode, Integer> nodeToSCCID = new HashMap();
    protected List<LEdge> revEdges = Lists.newArrayList();
    protected LGraph graph;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Model order cycle breaking", 1.0f);
        this.graph = layeredGraph;
        this.revEdges = Lists.newArrayList();
        int offset = Math.max(layeredGraph.getLayerlessNodes().size(), (Integer)layeredGraph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES));
        while (true) {
            Tarjan t = new Tarjan(this.revEdges, this.stronglyConnectedComponents, this.nodeToSCCID);
            t.resetTarjan(layeredGraph);
            t.tarjan(layeredGraph);
            if (this.stronglyConnectedComponents.size() == 0) break;
            this.findNodes(offset, offset * (Integer)layeredGraph.getProperty(InternalProperties.CB_NUM_MODEL_ORDER_GROUPS));
            for (LEdge edge : this.revEdges) {
                edge.reverse(layeredGraph, false);
                edge.getSource().getNode().setProperty(LayeredOptions.LAYERING_LAYER_ID, (Integer)edge.getSource().getNode().getProperty(LayeredOptions.LAYERING_LAYER_ID) + 1);
                layeredGraph.setProperty(InternalProperties.CYCLIC, true);
            }
            this.stronglyConnectedComponents.clear();
            this.nodeToSCCID.clear();
            this.revEdges.clear();
        }
        monitor.done();
        monitor.log((Object)("Execution Time: " + monitor.getExecutionTime()));
    }

    public void findNodes(int offset, int bigOffset) {
        int i = 0;
        while (i < this.stronglyConnectedComponents.size()) {
            LNode max = null;
            GroupModelOrderCalculator calculator = new GroupModelOrderCalculator();
            int maxModelOrder = Integer.MIN_VALUE;
            for (LNode n : this.stronglyConnectedComponents.get(i)) {
                int modelOrderCurrent;
                boolean enforceGroupModelOrder;
                boolean bl = enforceGroupModelOrder = this.graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
                if (max == null) {
                    max = n;
                    maxModelOrder = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(n, bigOffset, offset) : calculator.computeConstraintModelOrder(n, offset);
                    continue;
                }
                int n2 = modelOrderCurrent = enforceGroupModelOrder ? calculator.computeConstraintGroupModelOrder(n, bigOffset, offset) : calculator.computeConstraintModelOrder(n, offset);
                if (maxModelOrder >= modelOrderCurrent) continue;
                max = n;
                maxModelOrder = modelOrderCurrent;
            }
            for (LEdge edge : max.getOutgoingEdges()) {
                if (!this.stronglyConnectedComponents.get(i).contains((Object)edge.getTarget().getNode())) continue;
                this.revEdges.add(edge);
            }
            ++i;
        }
    }
}

