/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Container;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.ui.preferences.UIPreferenceConstants;

public class WatchValueLabel
extends Container {
    public static final int MONITORING_VALUE_LR_MARGIN = 5;
    private static final Dimension NEGATION_POINT_DIMENSION = new Dimension(12, 12);
    private Label labelFigure;

    public Label getLabelFigure() {
        return this.labelFigure;
    }

    public static IFigure getLabel(IInterfaceElement model) {
        if (!WatchValueLabel.hasNegatedInputConnection(model)) {
            return WatchValueLabel.createLabelFigure(model.isIsInput());
        }
        WatchValueLabel container = new WatchValueLabel(WatchValueLabel.createContainerLayout());
        container.add(WatchValueLabel.createNegationPointFigure());
        container.addLabel(WatchValueLabel.createLabelFigure(true));
        return container;
    }

    private static Label createLabelFigure(boolean isInput) {
        SetableAlphaLabel label = new SetableAlphaLabel();
        label.setOpaque(true);
        label.setMinimumSize(new Dimension(50, 1));
        if (isInput) {
            label.setLabelAlignment(4);
            label.setTextAlignment(4);
        } else {
            label.setTextAlignment(1);
            label.setLabelAlignment(1);
        }
        label.setText(Messages.MonitoringEditPart_Not_Available);
        label.setBorder((Border)new MarginBorder(0, 5, 0, 5));
        return label;
    }

    private static IFigure createNegationPointFigure() {
        return new AbstractFreeformFigure(){

            protected Rectangle calculateFreeformExtent() {
                return new Rectangle(0, 0, 0, 0);
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                Rectangle bounds = this.getBounds().getCopy();
                Point ovalOrigin = bounds.getTopRight().translate(-12, bounds.height / 2 - 6);
                graphics.setBackgroundColor(UIPreferenceConstants.getBoolConnectorColor());
                graphics.fillOval(ovalOrigin.x, ovalOrigin.y, 12, 12);
            }

            public Dimension getPreferredSize(int wHint, int hHint) {
                return NEGATION_POINT_DIMENSION;
            }
        };
    }

    private static boolean hasNegatedInputConnection(IInterfaceElement ie) {
        if (ie == null || !ie.isIsInput() || ie.getInputConnections().isEmpty()) {
            return false;
        }
        return ((Connection)ie.getInputConnections().getFirst()).isNegated();
    }

    private static FlowLayout createContainerLayout() {
        FlowLayout layout = new FlowLayout();
        layout.setHorizontal(true);
        layout.setMinorAlignment(2);
        layout.setMajorAlignment(2);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        layout.setStretchMinorAxis(true);
        return layout;
    }

    private WatchValueLabel(FlowLayout layout) {
        super((LayoutManager)layout);
    }

    private void addLabel(Label label) {
        this.labelFigure = label;
        this.add((IFigure)label);
    }
}

