/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeAttributeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class ChangeAttributeDeclarationCommand
extends AbstractChangeAttributeCommand {
    private final AttributeDeclaration attributeDeclaration;
    private final DataType dataType;
    private AttributeDeclaration oldAttributeDeclaration;
    private DataType oldDataType;

    private ChangeAttributeDeclarationCommand(Attribute attribute, AttributeDeclaration attributeDeclaration, DataType dataType) {
        super(attribute);
        this.attributeDeclaration = attributeDeclaration;
        this.dataType = dataType;
    }

    public static boolean attributeDeclarationChanged(Attribute attribute, String newName) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)attribute);
        if (typeLibrary == null) {
            return false;
        }
        AttributeDeclaration newDecl = (AttributeDeclaration)ImportHelper.resolveImport((String)newName, (EObject)attribute.eContainer(), name -> {
            AttributeTypeEntry entry = typeLibrary.getAttributeTypeEntry(name);
            return entry != null ? entry.getType() : null;
        }, name -> null);
        if (newDecl != null && !newDecl.isValidObject((ConfigurableObject)attribute.eContainer())) {
            return false;
        }
        AttributeDeclaration oldDecl = attribute.getAttributeDeclaration();
        return oldDecl != newDecl;
    }

    public static ChangeAttributeDeclarationCommand forName(Attribute attribute, String newName) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)attribute);
        AttributeTypeEntry entry = (AttributeTypeEntry)ImportHelper.resolveImport((String)newName, (EObject)attribute.eContainer(), arg_0 -> ((TypeLibrary)typeLibrary).getAttributeTypeEntry(arg_0), name -> null);
        return ChangeAttributeDeclarationCommand.forEntry(attribute, entry);
    }

    public static ChangeAttributeDeclarationCommand forEntry(Attribute attribute, AttributeTypeEntry entry) {
        if (entry != null && entry.getType() != null) {
            return new ChangeAttributeDeclarationCommand(attribute, entry.getType(), (DataType)entry.getType().getType());
        }
        if (attribute.getAttributeDeclaration() != null) {
            return new ChangeAttributeDeclarationCommand(attribute, null, (DataType)IecTypes.ElementaryTypes.STRING);
        }
        return new ChangeAttributeDeclarationCommand(attribute, null, attribute.getType());
    }

    @Override
    public void doExecute() {
        Attribute attribute = this.getAttribute();
        this.oldDataType = attribute.getType();
        this.oldAttributeDeclaration = attribute.getAttributeDeclaration();
        attribute.setAttributeDeclaration(this.attributeDeclaration);
        attribute.setType(this.dataType);
    }

    @Override
    public void doUndo() {
        this.getAttribute().setAttributeDeclaration(this.oldAttributeDeclaration);
        this.getAttribute().setType(this.oldDataType);
    }

    @Override
    public void doRedo() {
        this.getAttribute().setAttributeDeclaration(this.attributeDeclaration);
        this.getAttribute().setType(this.dataType);
    }
}

