/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.parameters.parameters.ExpressionExtended;
import org.eclipse.comma.petrinet.PythonHelper;

class Token {
    private final List<String> variables;
    private final List<Expression> parameters;

    private Token(List<String> variables, List<Expression> parameters) {
        this.variables = variables;
        this.parameters = parameters;
    }

    static Token empty() {
        return new Token(null, null);
    }

    static Token forParameters(List<ExpressionExtended> parameters) {
        ArrayList<Expression> exps = new ArrayList<Expression>();
        for (ExpressionExtended p : parameters) {
            exps.add(p.getExp());
        }
        return new Token(null, exps);
    }

    static Token forVariables(List<String> variables) {
        return new Token(variables, null);
    }

    String toPython() {
        if (this.parameters != null) {
            String str = this.parameters.stream().map(s -> PythonHelper.expression(s, variable -> "p_")).collect(Collectors.joining(","));
            return String.format("Parameters([%s])", str);
        }
        if (this.variables != null) {
            String str = this.variables.stream().map(s -> String.format("'%s': %s%s", s, "v_", s)).collect(Collectors.joining(","));
            return String.format("Variables({%s})", str);
        }
        return "''";
    }
}

