/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.examples.xml.AbstractMatching;
import org.eclipse.compare.examples.xml.ChooseMatcherDropDownAction;
import org.eclipse.compare.examples.xml.CreateNewIdMapAction;
import org.eclipse.compare.examples.xml.OrderedMatching;
import org.eclipse.compare.examples.xml.XMLCompareMessages;
import org.eclipse.compare.examples.xml.XMLNode;
import org.eclipse.compare.examples.xml.XMLPlugin;
import org.eclipse.compare.examples.xml.XMLStructureCreator;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class XMLStructureViewer
extends StructureDiffViewer {
    private CompareViewerSwitchingPane fParent;
    private HashMap fIdMapsInternal;
    private HashMap fIdMaps;
    private HashMap fOrderedElementsInternal;
    private HashMap fOrderedElements;
    protected static final char SIGN_SEPARATOR = '>';

    public XMLStructureViewer(Tree tree, CompareConfiguration configuration) {
        super(tree, configuration);
        this.initialize();
    }

    public XMLStructureViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        if (parent instanceof CompareViewerSwitchingPane) {
            this.fParent = (CompareViewerSwitchingPane)parent;
        }
        this.initialize();
    }

    private void initialize() {
        this.setStructureCreator(new XMLStructureCreator());
        XMLPlugin plugin = XMLPlugin.getDefault();
        plugin.getViewers().add((Object)this);
        this.fIdMaps = plugin.getIdMaps();
        this.fIdMapsInternal = plugin.getIdMapsInternal();
        this.fOrderedElements = plugin.getOrderedElements();
        this.fOrderedElementsInternal = plugin.getOrderedElementsInternal();
        XMLSorter sorter = new XMLSorter();
        this.setSorter(sorter);
    }

    protected XMLStructureCreator getXMLStructureCreator() {
        return (XMLStructureCreator)this.getStructureCreator();
    }

    protected void handleDispose(DisposeEvent event) {
        XMLPlugin.getDefault().getViewers().remove((Object)this);
        super.handleDispose(event);
    }

    protected void compareInputChanged(ICompareInput input) {
        ITypedElement t;
        if (input != null && (t = input.getLeft()) != null) {
            String fileExtension = t.getType();
            this.getXMLStructureCreator().setFileExtension(fileExtension);
        }
        this.getXMLStructureCreator().initIdMaps();
        super.compareInputChanged(input);
        if (input != null && this.fParent.getTitleArgument() == null) {
            this.appendToTitle(this.getXMLStructureCreator().getIdMap());
        }
    }

    protected void contentChanged() {
        this.fIdMaps = XMLPlugin.getDefault().getIdMaps();
        this.fOrderedElements = XMLPlugin.getDefault().getOrderedElements();
        this.getXMLStructureCreator().updateIdMaps();
        if (this.isIdMapRemoved()) {
            this.getXMLStructureCreator().setIdMap(XMLStructureCreator.DEFAULT_IDMAP);
        }
        this.getXMLStructureCreator().initIdMaps();
        this.contentChanged(null);
        if (this.fParent.getTitleArgument() == null) {
            this.appendToTitle(this.getXMLStructureCreator().getIdMap());
        }
    }

    protected void preDiffHook(IStructureComparator ancestor, IStructureComparator left, IStructureComparator right, IProgressMonitor monitor) {
        if (left != null && right != null) {
            this.performMatching((XMLNode)left, (XMLNode)right, (XMLNode)ancestor, monitor);
        }
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        toolBarManager.appendToGroup("modes", (IAction)new ChooseMatcherDropDownAction(this));
        toolBarManager.appendToGroup("modes", (IAction)new CreateNewIdMapAction(this));
    }

    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        ISelection s = this.getSelection();
        if (s instanceof StructuredSelection && ((StructuredSelection)s).getFirstElement() instanceof DiffNode && ((DiffNode)((StructuredSelection)s).getFirstElement()).getId() instanceof XMLNode) {
            DiffNode diffnode = (DiffNode)((StructuredSelection)s).getFirstElement();
            String diffnodeIdSig = ((XMLNode)diffnode.getId()).getSignature();
            this.fIdMaps = XMLPlugin.getDefault().getIdMaps();
            String idmap_name = this.getXMLStructureCreator().getIdMap();
            if (diffnodeIdSig.endsWith("$attribute$") || diffnodeIdSig.endsWith("$text$") && ((XMLNode)diffnode.getId()).getOrigId().endsWith("(1)")) {
                SetAsIdAction action = new SetAsIdAction(diffnode);
                if (!this.fIdMaps.containsKey(idmap_name)) {
                    action.setText(XMLCompareMessages.XMLStructureViewer_action_notUserIdMap);
                    action.setEnabled(false);
                } else {
                    HashMap idmapHM = (HashMap)this.fIdMaps.get(idmap_name);
                    XMLNode idNode = (XMLNode)diffnode.getId();
                    String signature = idNode.getSignature();
                    String idname = "";
                    if (idNode.getSignature().endsWith("$attribute$")) {
                        signature = signature.substring(0, signature.indexOf("$attribute$"));
                        int end_of_signature = signature.lastIndexOf(62, signature.length() - 2);
                        idname = signature.substring(end_of_signature + 1, signature.length() - 1);
                        signature = signature.substring(0, end_of_signature + 1);
                    } else if (idNode.getSignature().endsWith("$text$")) {
                        XMLNode textNode = (XMLNode)diffnode.getId();
                        XMLNode idelem = textNode.getParent();
                        XMLNode elem = idelem.getParent();
                        signature = elem.getSignature().substring(0, elem.getSignature().indexOf("$element$"));
                        idname = idelem.getOrigId();
                        idname = idname.substring(0, idname.indexOf(60));
                        idname = Character.valueOf('<') + idname;
                    }
                    if (idmapHM.containsKey(signature)) {
                        if (idmapHM.get(signature).equals(idname)) {
                            action.setText(XMLCompareMessages.XMLStructureViewer_action_setId_text1);
                            action.setEnabled(false);
                        } else {
                            String oldId = (String)idmapHM.get(signature);
                            if (oldId.startsWith(Character.valueOf('<').toString())) {
                                oldId = oldId.substring(1);
                            }
                            action.setText(MessageFormat.format("{0} {1}", XMLCompareMessages.XMLStructureViewer_action_setId_text2, oldId));
                            action.setEnabled(true);
                        }
                    } else {
                        action.setText(XMLCompareMessages.XMLStructureViewer_action_setId_text3);
                        action.setEnabled(true);
                    }
                }
                manager.add((IAction)action);
            } else if (diffnodeIdSig.endsWith("$element$")) {
                SetOrderedAction action = new SetOrderedAction(idmap_name);
                if (!this.fIdMaps.containsKey(idmap_name)) {
                    action.setText(XMLCompareMessages.XMLStructureViewer_action_notUserIdMap);
                    action.setEnabled(false);
                } else {
                    ArrayList idmapOrdered = (ArrayList)this.fOrderedElements.get(idmap_name);
                    XMLNode idNode = (XMLNode)diffnode.getId();
                    String signature = idNode.getSignature();
                    signature = signature.substring(0, signature.indexOf("$element$"));
                    if (idmapOrdered != null && idmapOrdered.contains(signature)) {
                        action.setText(XMLCompareMessages.XMLStructureViewer_action_setOrdered_exists);
                        action.setEnabled(false);
                    } else {
                        action.setText(XMLCompareMessages.XMLStructureViewer_action_setOrdered);
                        action.setSignature(signature);
                        action.setEnabled(true);
                    }
                }
                manager.add((IAction)action);
            }
        }
    }

    protected void appendToTitle(String idmap_name) {
        if (this.fParent != null) {
            this.getXMLStructureCreator().setIdMap(idmap_name);
            this.fParent.setTitleArgument(idmap_name);
        }
    }

    private boolean isIdMapRemoved() {
        XMLStructureCreator xsc = this.getXMLStructureCreator();
        String IdMapName = xsc.getIdMap();
        return !IdMapName.equals(XMLStructureCreator.USE_UNORDERED) && !IdMapName.equals(XMLStructureCreator.USE_ORDERED) && !this.fIdMaps.containsKey(IdMapName) && !this.fIdMapsInternal.containsKey(IdMapName) && !this.fOrderedElements.containsKey(IdMapName);
    }

    protected void updateIdMaps() {
        this.getXMLStructureCreator().updateIdMaps();
    }

    protected void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE")) {
            this.getXMLStructureCreator().setRemoveWhiteSpace(!this.getXMLStructureCreator().getRemoveWhiteSpace());
            this.contentChanged();
        }
        super.propertyChange(event);
    }

    private void performMatching(XMLNode left, XMLNode right, XMLNode ancestor, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int totalWork = ancestor != null ? 1 : 3;
        monitor.beginTask(XMLCompareMessages.XMLStructureViewer_matching_beginTask, totalWork);
        ArrayList ordered = null;
        if (!this.getXMLStructureCreator().getIdMap().equals(XMLStructureCreator.USE_UNORDERED) && !this.getXMLStructureCreator().getIdMap().equals(XMLStructureCreator.USE_ORDERED) && (ordered = (ArrayList)this.fOrderedElements.get(this.getXMLStructureCreator().getIdMap())) == null) {
            ordered = (ArrayList)this.fOrderedElementsInternal.get(this.getXMLStructureCreator().getIdMap());
        }
        if (this.getSorter() instanceof XMLSorter) {
            ((XMLSorter)this.getSorter()).setOrdered(ordered);
        }
        OrderedMatching m = null;
        if (this.getXMLStructureCreator().getIdMap().equals(XMLStructureCreator.USE_ORDERED)) {
            m = new OrderedMatching();
            if (this.getSorter() instanceof XMLSorter) {
                ((XMLSorter)this.getSorter()).setAlwaysOrderSort(true);
            }
        }
        try {
            if (m != null) {
                ((AbstractMatching)m).match(left, right, false, monitor);
                if (ancestor != null) {
                    ((AbstractMatching)m).match(left, ancestor, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                    ((AbstractMatching)m).match(right, ancestor, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected class SetAsIdAction
    extends Action {
        DiffNode fDiffNode;

        public SetAsIdAction(DiffNode diffnode) {
            this.fDiffNode = diffnode;
        }

        public void run() {
            XMLStructureCreator sc = XMLStructureViewer.this.getXMLStructureCreator();
            String idmap_name = sc.getIdMap();
            if (XMLStructureViewer.this.fIdMaps.containsKey(idmap_name)) {
                HashMap idmapHM = (HashMap)XMLStructureViewer.this.fIdMaps.get(idmap_name);
                if (((XMLNode)this.fDiffNode.getId()).getSignature().endsWith("$attribute$")) {
                    XMLNode attrNode = (XMLNode)this.fDiffNode.getId();
                    String signature = attrNode.getSignature();
                    signature = signature.substring(0, signature.indexOf("$attribute$"));
                    int end_of_signature = signature.lastIndexOf(62, signature.length() - 2);
                    String idattr = signature.substring(end_of_signature + 1, signature.length() - 1);
                    signature = signature.substring(0, end_of_signature + 1);
                    idmapHM.put(signature, idattr);
                    XMLPlugin.getDefault().setIdMaps(XMLStructureViewer.this.fIdMaps, null, null, false);
                } else if (((XMLNode)this.fDiffNode.getId()).getSignature().endsWith("$text$")) {
                    XMLNode textNode = (XMLNode)this.fDiffNode.getId();
                    XMLNode idelem = textNode.getParent();
                    XMLNode elem = idelem.getParent();
                    String signature = elem.getSignature().substring(0, elem.getSignature().indexOf("$element$"));
                    String idname = idelem.getOrigId();
                    idname = idname.substring(0, idname.indexOf(60));
                    idname = Character.valueOf('<') + idname;
                    idmapHM.put(signature, idname);
                    XMLPlugin.getDefault().setIdMaps(XMLStructureViewer.this.fIdMaps, null, null, false);
                }
            }
        }
    }

    protected class SetOrderedAction
    extends Action {
        String fIdMapName;
        String fSignature;

        public SetOrderedAction(String idmap_name) {
            this.fIdMapName = idmap_name;
        }

        public void run() {
            if (this.fSignature != null) {
                ArrayList<String> idmapOrdered = (ArrayList<String>)XMLStructureViewer.this.fOrderedElements.get(this.fIdMapName);
                if (idmapOrdered == null) {
                    idmapOrdered = new ArrayList<String>();
                    XMLStructureViewer.this.fOrderedElements.put(this.fIdMapName, idmapOrdered);
                }
                idmapOrdered.add(this.fSignature);
            }
        }

        public void setSignature(String signature) {
            this.fSignature = signature;
        }
    }

    class XMLSorter
    extends ViewerSorter {
        ArrayList fOrdered;
        boolean fAlwaysOrderSort = false;

        public void setOrdered(ArrayList ordered) {
            this.fOrdered = ordered;
        }

        public void setAlwaysOrderSort(boolean alwaysOrderSort) {
            this.fAlwaysOrderSort = alwaysOrderSort;
        }

        public int category(Object node) {
            ITypedElement o;
            if (node instanceof DiffNode && (o = ((DiffNode)node).getId()) instanceof XMLNode) {
                String xmlType = ((XMLNode)o).getXMLType();
                if (xmlType.equals("attribute")) {
                    return 1;
                }
                if (xmlType.equals("element")) {
                    return 2;
                }
                if (xmlType.equals("text")) {
                    return 2;
                }
            }
            return 0;
        }

        public void sort(Viewer viewer, Object[] elements) {
            XMLNode parent;
            String sig;
            ITypedElement o;
            if ((this.fOrdered != null || this.fAlwaysOrderSort) && elements != null && elements.length > 0 && elements[0] instanceof DiffNode && (o = ((DiffNode)elements[0]).getId()) instanceof XMLNode && (sig = (parent = ((XMLNode)o).getParent()).getSignature()).endsWith("$element$")) {
                String newSig = sig.substring(0, sig.length() - "$element$".length());
                if (this.fAlwaysOrderSort || this.fOrdered.contains(newSig)) {
                    ArrayList<Object> originalTree = new ArrayList<Object>(Arrays.asList(parent.getChildren()));
                    Arrays.sort(elements, (a, b) -> this.compare((DiffNode)a, (DiffNode)b, originalTree));
                    return;
                }
            }
            super.sort(viewer, elements);
        }

        private int compare(DiffNode a, DiffNode b, ArrayList originalTree) {
            int index_b;
            int index_a = originalTree.indexOf(a.getId());
            if (index_a < (index_b = originalTree.indexOf(b.getId()))) {
                return -1;
            }
            return 1;
        }
    }
}

