/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.structurecreator;

import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.examples.structurecreator.Util;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class KeyValuePairStructureCreator
implements IStructureCreator {
    public String getName() {
        return Util.getString("KeyValuePairStructureCreator.title");
    }

    public IStructureComparator getStructure(Object input) {
        if (!(input instanceof IStreamContentAccessor)) {
            return null;
        }
        IStreamContentAccessor sca = (IStreamContentAccessor)input;
        try {
            String contents = Util.readString(sca);
            if (contents == null) {
                contents = "";
            }
            Document doc = new Document(contents);
            KeyValueNode root = new KeyValueNode("root", "", (IDocument)doc, 0, doc.getLength());
            int i = 0;
            while (i < doc.getNumberOfLines()) {
                IRegion r = doc.getLineInformation(i);
                String s = doc.get(r.getOffset(), r.getLength());
                int start = r.getOffset();
                String key = "";
                String value = "";
                int pos = s.indexOf(61);
                if (pos >= 0) {
                    key = s.substring(0, pos);
                    value = s.substring(pos + 1);
                } else {
                    key = s;
                }
                if (key.length() > 0) {
                    root.addChild(new KeyValueNode(key, value, (IDocument)doc, start, s.length()));
                }
                ++i;
            }
            return root;
        }
        catch (CoreException ex) {
            String message = Util.getString("KeyValuePairStructureCreator.CoreException.message");
            CompareUI.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.compare", 0, message, (Throwable)ex));
        }
        catch (BadLocationException ex) {
            String message = Util.getString("KeyValuePairStructureCreator.BadLocationException.message");
            CompareUI.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.compare", 0, message, (Throwable)ex));
        }
        return null;
    }

    public void save(IStructureComparator structure, Object input) {
        if (input instanceof IEditableContent && structure instanceof KeyValueNode) {
            IDocument doc = ((KeyValueNode)structure).getDocument();
            IEditableContent bca = (IEditableContent)input;
            String c = doc.get();
            bca.setContent(c.getBytes());
        }
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof KeyValueNode) {
            String s = ((KeyValueNode)((Object)node)).getValue();
            if (ignoreWhitespace) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    static class KeyValueNode
    extends DocumentRangeNode
    implements ITypedElement {
        String fValue;

        public KeyValueNode(String id, String value, IDocument doc, int start, int length) {
            super(0, id, doc, start, length);
            this.fValue = value;
        }

        String getValue() {
            return this.fValue;
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "kvtxt";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }
    }
}

