/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class CompareUIPluginTest
extends TestCase {
    public void testFindContentViewerDescriptor_UnknownType() {
        CompareConfiguration cc = new CompareConfiguration();
        DiffNode in = new DiffNode((ITypedElement)new UnknownTypedElement(), (ITypedElement)new UnknownTypedElement());
        ViewerDescriptor[] result = CompareUIPlugin.getDefault().findContentViewerDescriptor(null, (Object)in, cc);
        CompareUIPluginTest.assertNull((Object)result);
    }

    public void testFindContentViewerDescriptor_TextType_NotStreamAccessor() {
        CompareConfiguration cc = new CompareConfiguration();
        DiffNode in = new DiffNode((ITypedElement)new TextTypedElement(), (ITypedElement)new TextTypedElement());
        ViewerDescriptor[] result = CompareUIPlugin.getDefault().findContentViewerDescriptor(null, (Object)in, cc);
        CompareUIPluginTest.assertNotNull((Object)result);
        CompareUIPluginTest.assertEquals((int)1, (int)result.length);
    }

    public void testFindContentViewerDescriptorForTextType_StreamAccessor() {
        CompareConfiguration cc = new CompareConfiguration();
        DiffNode in = new DiffNode((ITypedElement)new TextTypedElementStreamAccessor(), (ITypedElement)new TextTypedElementStreamAccessor());
        ViewerDescriptor[] result = CompareUIPlugin.getDefault().findContentViewerDescriptor(null, (Object)in, cc);
        CompareUIPluginTest.assertNotNull((Object)result);
        CompareUIPluginTest.assertEquals((int)1, (int)result.length);
    }

    private static class TextTypedElement
    implements ITypedElement {
        private TextTypedElement() {
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "test";
        }

        public String getType() {
            return "txt";
        }
    }

    private static class TextTypedElementStreamAccessor
    implements ITypedElement,
    IStreamContentAccessor {
        private TextTypedElementStreamAccessor() {
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "test";
        }

        public String getType() {
            return "txt";
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(new byte[]{32});
        }
    }

    private static class UnknownTypedElement
    implements ITypedElement {
        private UnknownTypedElement() {
        }

        public Image getImage() {
            return null;
        }

        public String getName() {
            return "test";
        }

        public String getType() {
            return "???";
        }
    }
}

