/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.tests.CompareTestPlugin;
import org.eclipse.core.runtime.Path;
import org.junit.Assert;
import org.junit.Test;

public class LineReaderTest {
    @Test
    public void testReadEmpty() {
        LineReader lr = new LineReader(this.getReader("empty.txt"));
        List inLines = lr.readLines();
        Assert.assertEquals((long)0L, (long)inLines.size());
    }

    @Test
    public void testReadNormal() {
        LineReader lr = new LineReader(this.getReader("normal.txt"));
        List inLines = lr.readLines();
        Assert.assertEquals((long)3L, (long)inLines.size());
        Assert.assertEquals((Object)"[1]\n", (Object)this.convertLineDelimeters(inLines.get(0)));
        Assert.assertEquals((Object)"[2]\n", (Object)this.convertLineDelimeters(inLines.get(1)));
        Assert.assertEquals((Object)"[3]\n", (Object)this.convertLineDelimeters(inLines.get(2)));
    }

    private String convertLineDelimeters(Object object) {
        String line = (String)object;
        if (line.endsWith("\r\n")) {
            return String.valueOf(line.substring(0, line.length() - 2)) + "\n";
        }
        return line;
    }

    @Test
    public void testReadUnterminatedLastLine() {
        LineReader lr = new LineReader(this.getReader("unterminated.txt"));
        List inLines = lr.readLines();
        Assert.assertEquals((long)3L, (long)inLines.size());
        Assert.assertEquals((Object)"[1]\n", (Object)this.convertLineDelimeters(inLines.get(0)));
        Assert.assertEquals((Object)"[2]\n", (Object)this.convertLineDelimeters(inLines.get(1)));
        Assert.assertEquals((Object)"[3]", inLines.get(2));
    }

    private BufferedReader getReader(String name) {
        Path path = new Path("linereaderdata/" + name);
        try {
            URL url = new URL(CompareTestPlugin.getDefault().getBundle().getEntry("/"), path.toString());
            InputStream resourceAsStream = url.openStream();
            InputStreamReader reader2 = new InputStreamReader(resourceAsStream);
            return new BufferedReader(reader2);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

