/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.core.patch.LineReader;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.compare.patch.IFilePatch2;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.patch.PatchBuilder;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.tests.PatchUtils;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.junit.Assert;

public class PatchBuilderTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testModifyHunks() throws CoreException, IOException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_modifyHunks.txt");
        PatchUtils.StringStorage contextStorage = new PatchUtils.StringStorage("context.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchBuilderTest.assertEquals((int)1, (int)patches.length);
        IHunk[] hunksBefore = patches[0].getHunks();
        PatchBuilderTest.assertEquals((int)5, (int)hunksBefore.length);
        String[] lines = new String[]{" [d]", "+[d1]", "+[d2]", "+[d3]", "+[d4]", " [e]"};
        this.addLineDelimiters(lines);
        IHunk[] toAdd = new IHunk[]{PatchBuilder.createHunk((int)3, (String[])lines)};
        IFilePatch2 filePatch = PatchBuilder.addHunks((IFilePatch2)patches[0], (IHunk[])toAdd);
        IHunk[] toRemove = new IHunk[]{hunksBefore[0], hunksBefore[2]};
        filePatch = PatchBuilder.removeHunks((IFilePatch2)filePatch, (IHunk[])toRemove);
        IHunk[] hunksAfter = filePatch.getHunks();
        PatchBuilderTest.assertEquals((int)4, (int)hunksAfter.length);
        PatchBuilderTest.assertEquals((int)3, (int)((Hunk)hunksAfter[0]).getStart(false));
        PatchBuilderTest.assertEquals((int)3, (int)((Hunk)hunksAfter[0]).getStart(true));
        PatchBuilderTest.assertEquals((int)7, (int)((Hunk)hunksAfter[1]).getStart(false));
        PatchBuilderTest.assertEquals((int)11, (int)((Hunk)hunksAfter[1]).getStart(true));
        PatchBuilderTest.assertEquals((int)18, (int)((Hunk)hunksAfter[2]).getStart(false));
        PatchBuilderTest.assertEquals((int)22, (int)((Hunk)hunksAfter[2]).getStart(true));
        PatchBuilderTest.assertEquals((int)28, (int)((Hunk)hunksAfter[3]).getStart(false));
        PatchBuilderTest.assertEquals((int)33, (int)((Hunk)hunksAfter[3]).getStart(true));
        IFilePatchResult result = filePatch.apply(Utilities.getReaderCreator((IStorage)contextStorage), new PatchConfiguration(), (IProgressMonitor)new NullProgressMonitor());
        IHunk[] rejects = result.getRejects();
        PatchBuilderTest.assertEquals((int)1, (int)rejects.length);
        InputStream actual = result.getPatchedContents();
        LineReader lr = new LineReader(PatchUtils.getReader("exp_modifyHunks.txt"));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchBuilderTest.assertEquals((String)expected, (String)PatchUtils.asString(actual));
    }

    public void testAddHunks() throws CoreException, IOException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_addHunks.txt");
        PatchUtils.StringStorage contextStorage = new PatchUtils.StringStorage("context_full.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchBuilderTest.assertEquals((int)1, (int)patches.length);
        IHunk[] hunksBefore = patches[0].getHunks();
        PatchBuilderTest.assertEquals((int)3, (int)hunksBefore.length);
        String[] lines0 = new String[]{" [d]", "+[d1]", "+[d2]", "+[d3]", "+[d4]", " [e]"};
        this.addLineDelimiters(lines0);
        IHunk hunk0 = PatchBuilder.createHunk((int)3, (String[])lines0);
        String[] lines1 = new String[]{" [K]", " [L]", "-[M]", " [N]", "+[N1]", "+[N2]", " [O]", " [P]"};
        this.addLineDelimiters(lines1);
        IHunk hunk1 = PatchBuilder.createHunk((int)36, (String[])lines1);
        IHunk[] toAdd = new IHunk[]{hunk0, hunk1};
        IFilePatch2 filePatch = PatchBuilder.addHunks((IFilePatch2)patches[0], (IHunk[])toAdd);
        IHunk[] hunksAfter = filePatch.getHunks();
        PatchBuilderTest.assertEquals((int)5, (int)hunksAfter.length);
        PatchBuilderTest.assertEquals((int)0, (int)((Hunk)hunksAfter[0]).getStart(false));
        PatchBuilderTest.assertEquals((int)0, (int)((Hunk)hunksAfter[0]).getStart(true));
        PatchBuilderTest.assertEquals((int)3, (int)((Hunk)hunksAfter[1]).getStart(false));
        PatchBuilderTest.assertEquals((int)5, (int)((Hunk)hunksAfter[1]).getStart(true));
        PatchBuilderTest.assertEquals((int)19, (int)((Hunk)hunksAfter[2]).getStart(false));
        PatchBuilderTest.assertEquals((int)25, (int)((Hunk)hunksAfter[2]).getStart(true));
        PatchBuilderTest.assertEquals((int)36, (int)((Hunk)hunksAfter[3]).getStart(false));
        PatchBuilderTest.assertEquals((int)40, (int)((Hunk)hunksAfter[3]).getStart(true));
        PatchBuilderTest.assertEquals((int)46, (int)((Hunk)hunksAfter[4]).getStart(false));
        PatchBuilderTest.assertEquals((int)51, (int)((Hunk)hunksAfter[4]).getStart(true));
        IFilePatchResult result = filePatch.apply(Utilities.getReaderCreator((IStorage)contextStorage), new PatchConfiguration(), (IProgressMonitor)new NullProgressMonitor());
        IHunk[] rejects = result.getRejects();
        PatchBuilderTest.assertEquals((int)0, (int)rejects.length);
        InputStream actual = result.getPatchedContents();
        LineReader lr = new LineReader(PatchUtils.getReader("exp_addHunks.txt"));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchBuilderTest.assertEquals((String)expected, (String)PatchUtils.asString(actual));
    }

    public void testRemoveHunks() throws CoreException, IOException {
        PatchUtils.StringStorage patchStorage = new PatchUtils.StringStorage("patch_removeHunks.txt");
        PatchUtils.StringStorage contextStorage = new PatchUtils.StringStorage("context_full.txt");
        IFilePatch[] patches = ApplyPatchOperation.parsePatch((IStorage)patchStorage);
        PatchBuilderTest.assertEquals((int)1, (int)patches.length);
        IHunk[] hunksBefore = patches[0].getHunks();
        PatchBuilderTest.assertEquals((int)5, (int)hunksBefore.length);
        IHunk[] toRemove = new IHunk[]{hunksBefore[0], hunksBefore[1]};
        IFilePatch2 filePatch = PatchBuilder.removeHunks((IFilePatch2)patches[0], (IHunk[])toRemove);
        IHunk[] hunksAfter = filePatch.getHunks();
        PatchBuilderTest.assertEquals((int)3, (int)hunksAfter.length);
        PatchBuilderTest.assertEquals((int)19, (int)((Hunk)hunksAfter[0]).getStart(false));
        PatchBuilderTest.assertEquals((int)19, (int)((Hunk)hunksAfter[0]).getStart(true));
        PatchBuilderTest.assertEquals((int)29, (int)((Hunk)hunksAfter[1]).getStart(false));
        PatchBuilderTest.assertEquals((int)27, (int)((Hunk)hunksAfter[1]).getStart(true));
        PatchBuilderTest.assertEquals((int)46, (int)((Hunk)hunksAfter[2]).getStart(false));
        PatchBuilderTest.assertEquals((int)43, (int)((Hunk)hunksAfter[2]).getStart(true));
        IFilePatchResult result = filePatch.apply(Utilities.getReaderCreator((IStorage)contextStorage), new PatchConfiguration(), (IProgressMonitor)new NullProgressMonitor());
        IHunk[] rejects = result.getRejects();
        PatchBuilderTest.assertEquals((int)0, (int)rejects.length);
        InputStream actual = result.getPatchedContents();
        LineReader lr = new LineReader(PatchUtils.getReader("exp_removeHunks.txt"));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchBuilderTest.assertEquals((String)expected, (String)PatchUtils.asString(actual));
    }

    public void testCreateFilePatch() throws CoreException, IOException {
        PatchUtils.StringStorage contextStorage = new PatchUtils.StringStorage("context.txt");
        String[] lines0 = new String[]{"+[a1]", "+[a2]", "+[a3]", " [a]"};
        this.addLineDelimiters(lines0);
        Hunk hunk0 = (Hunk)PatchBuilder.createHunk((int)0, (String[])lines0);
        String[] lines1 = new String[]{" [b]", " [c]", "-[d]", "-[e]", " [f]", " [g]", " [h]", "+[h1]", " [i]", " [j]", "+[j1]", "+[j2]", " [k]", " [l]"};
        this.addLineDelimiters(lines1);
        Hunk hunk1 = (Hunk)PatchBuilder.createHunk((int)1, (String[])lines1);
        IHunk[] hunks = new IHunk[]{hunk1, hunk0};
        IFilePatch2 filePatch = PatchBuilder.createFilePatch((IPath)new Path(""), (long)0L, (IPath)new Path(""), (long)0L, (IHunk[])hunks);
        PatchBuilderTest.assertEquals((int)2, (int)filePatch.getHunks().length);
        PatchBuilderTest.assertEquals((Object)hunk0, (Object)filePatch.getHunks()[0]);
        PatchBuilderTest.assertEquals((Object)hunk1, (Object)filePatch.getHunks()[1]);
        IFilePatchResult result = filePatch.apply(Utilities.getReaderCreator((IStorage)contextStorage), new PatchConfiguration(), (IProgressMonitor)new NullProgressMonitor());
        InputStream actual = result.getPatchedContents();
        LineReader lr = new LineReader(PatchUtils.getReader("exp_createFilePatch.txt"));
        List inLines = lr.readLines();
        String expected = LineReader.createString((boolean)false, (List)inLines);
        PatchBuilderTest.assertEquals((String)expected, (String)PatchUtils.asString(actual));
    }

    public void testCreateHunk0() throws CoreException {
        PatchUtils.StringStorage patch = new PatchUtils.StringStorage("patch_createHunk0.txt");
        IFilePatch[] filePatches = ApplyPatchOperation.parsePatch((IStorage)patch);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches.length);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches[0].getHunks().length);
        Object[] lines = new String[]{"+[a1]", "+[a2]", "+[a3]", " [a]", " [b]", "-[c]", " [d]", " [e]", " [f]"};
        this.addLineDelimiters((String[])lines);
        Hunk hunk = (Hunk)PatchBuilder.createHunk((int)0, (String[])lines);
        Object[] actual = hunk.getUnifiedLines();
        PatchBuilderTest.assertTrue((lines != actual ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])lines, (Object[])actual);
        this.assertHunkEquals(hunk, (Hunk)filePatches[0].getHunks()[0]);
    }

    public void testCreateHunk1() throws CoreException {
        PatchUtils.StringStorage patch = new PatchUtils.StringStorage("patch_createHunk1.txt");
        IFilePatch[] filePatches = ApplyPatchOperation.parsePatch((IStorage)patch);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches.length);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches[0].getHunks().length);
        Object[] lines = new String[]{" [a]", " [b]", "-[c]", " [d]", "-[e]", " [f]", " [g]", " [h]", "+[h1]", " [i]", " [j]", "+[j1]", "+[j2]", " [k]", " [l]", " [m]"};
        this.addLineDelimiters((String[])lines);
        Hunk hunk = (Hunk)PatchBuilder.createHunk((int)0, (String[])lines);
        Object[] actual = hunk.getUnifiedLines();
        PatchBuilderTest.assertTrue((lines != actual ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])lines, (Object[])actual);
        this.assertHunkEquals(hunk, (Hunk)filePatches[0].getHunks()[0]);
    }

    public void testCreateHunk2() throws CoreException {
        PatchUtils.StringStorage patch = new PatchUtils.StringStorage("patch_createHunk2.txt");
        IFilePatch[] filePatches = ApplyPatchOperation.parsePatch((IStorage)patch);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches.length);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches[0].getHunks().length);
        Object[] lines = new String[]{"+[aa]", "+[bb]", "+[cc]"};
        this.addLineDelimiters((String[])lines);
        Hunk hunk = (Hunk)PatchBuilder.createHunk((int)0, (String[])lines);
        Object[] actual = hunk.getUnifiedLines();
        PatchBuilderTest.assertTrue((lines != actual ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])lines, (Object[])actual);
        this.assertHunkEquals(hunk, (Hunk)filePatches[0].getHunks()[0]);
    }

    public void testCreateHunk3() throws CoreException {
        PatchUtils.StringStorage patch = new PatchUtils.StringStorage("patch_createHunk3.txt");
        IFilePatch[] filePatches = ApplyPatchOperation.parsePatch((IStorage)patch);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches.length);
        PatchBuilderTest.assertEquals((int)1, (int)filePatches[0].getHunks().length);
        Object[] lines = new String[]{"-[aa]", "-[bb]", "-[cc]", "-[dd]"};
        this.addLineDelimiters((String[])lines);
        Hunk hunk = (Hunk)PatchBuilder.createHunk((int)0, (String[])lines);
        Object[] actual = hunk.getUnifiedLines();
        PatchBuilderTest.assertTrue((lines != actual ? 1 : 0) != 0);
        Assert.assertArrayEquals((Object[])lines, (Object[])actual);
        this.assertHunkEquals(hunk, (Hunk)filePatches[0].getHunks()[0]);
    }

    private void assertHunkEquals(Hunk h1, Hunk h2) {
        String[] l1 = h1.getLines();
        String[] l2 = h2.getLines();
        PatchBuilderTest.assertEquals((int)l1.length, (int)l2.length);
        int i = 0;
        while (i < l1.length) {
            PatchBuilderTest.assertFalse((l1[i] == null && l2[i] != null ? 1 : 0) != 0);
            PatchBuilderTest.assertEquals((String)l1[i], (String)l2[i]);
            ++i;
        }
        PatchBuilderTest.assertEquals((int)h1.getStart(false), (int)h2.getStart(false));
        PatchBuilderTest.assertEquals((int)h1.getStart(true), (int)h2.getStart(true));
        PatchBuilderTest.assertEquals((int)h1.getLength(false), (int)h2.getLength(false));
        PatchBuilderTest.assertEquals((int)h1.getLength(true), (int)h2.getLength(true));
        PatchBuilderTest.assertEquals((int)h1.getHunkType(false), (int)h2.getHunkType(false));
        PatchBuilderTest.assertEquals((int)h1.getHunkType(true), (int)h2.getHunkType(true));
    }

    private void addLineDelimiters(String[] lines) {
        int i = 0;
        while (i < lines.length) {
            lines[i] = String.valueOf(lines[i]) + "\r\n";
            ++i;
        }
    }
}

