/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.tests.CompareTestPlugin;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class PatchUtils {
    public static final String PATCHDATA = "patchdata";

    public static String asString(InputStream exptStream) throws IOException {
        return Utilities.readString((InputStream)exptStream, (String)ResourcesPlugin.getEncoding());
    }

    public static InputStream asInputStream(String name) {
        IPath path = new Path(PATCHDATA).append(name);
        try {
            URL url = new URL(PatchUtils.getBundle().getEntry("/"), path.toString());
            return url.openStream();
        }
        catch (IOException iOException) {
            Assert.fail((String)("Failed while reading " + name));
            return null;
        }
    }

    public static BufferedReader getReader(String name) {
        InputStream resourceAsStream = PatchUtils.asInputStream(name);
        InputStreamReader reader2 = new InputStreamReader(resourceAsStream);
        return new BufferedReader(reader2);
    }

    public static Bundle getBundle() {
        return CompareTestPlugin.getDefault().getBundle();
    }

    public static class FileStorage
    implements IStorage {
        File file;

        public FileStorage(File file) {
            this.file = file;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        public IPath getFullPath() {
            return new Path(this.file.getAbsolutePath());
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }

    public static class JarEntryStorage
    implements IStorage {
        JarEntry jarEntry;
        JarFile jarFile;

        public JarEntryStorage(JarEntry jarEntry, JarFile jarFile) {
            this.jarEntry = jarEntry;
            this.jarFile = jarFile;
        }

        public InputStream getContents() throws CoreException {
            try {
                return this.jarFile.getInputStream(this.jarEntry);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public IPath getFullPath() {
            return new Path(this.jarFile.getName());
        }

        public String getName() {
            return this.jarEntry.getName();
        }

        public boolean isReadOnly() {
            return true;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }

    public static class PatchTestConfiguration {
        String subfolderName;
        PatchConfiguration pc;
        String patchFileName;
        String[] originalFileNames;
        String[] expectedFileNames;
        String[] actualFileNames;
    }

    public static class StringStorage
    implements IStorage {
        String fileName;

        public StringStorage(String old) {
            this.fileName = old;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getName() {
            return this.fileName;
        }

        public IPath getFullPath() {
            return null;
        }

        public InputStream getContents() throws CoreException {
            return new BufferedInputStream(PatchUtils.asInputStream(this.fileName));
        }
    }
}

