/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.IMergeViewerTestAdapter;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class TextMergeViewerTest {
    TestMergeViewer viewer;

    /*
     * Loose catch block
     */
    public static boolean compareContent(InputStream a, InputStream b) {
        int d;
        int c;
        block31: {
            if (a == null && b == null) {
                return true;
            }
            if (a != null && b != null) break block31;
            try {
                if (a != null) {
                    a.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        while ((c = a.read()) == (d = b.read()) && c != -1 && d != -1) {
        }
        boolean bl = c == -1 && d == -1;
        try {
            if (a != null) {
                a.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (b != null) {
                b.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (a != null) {
                        a.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (b != null) {
                        b.close();
                    }
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
            try {
                if (a != null) {
                    a.close();
                }
            }
            catch (IOException iOException4) {}
            try {
                if (b != null) {
                    b.close();
                }
            }
            catch (IOException iOException5) {}
            return false;
        }
    }

    private void runInDialog(Object input, Runnable runnable) throws Exception {
        this.runInDialog(input, runnable, new CompareConfiguration());
    }

    private void runInDialog(Object input, Runnable runnable, final CompareConfiguration cc) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Dialog dialog = new Dialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                TextMergeViewerTest.this.viewer = new TestMergeViewer(composite, cc);
                return composite;
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        this.viewer.setInput(input);
        try {
            runnable.run();
        }
        catch (WrappedException e) {
            e.throwException();
        }
        dialog.close();
        this.viewer = null;
    }

    protected void saveViewerContents() {
        this.viewer.flush((IProgressMonitor)new NullProgressMonitor());
    }

    protected IDocument getDocument(boolean left) {
        char leg = left ? (char)'L' : 'R';
        IDocument document = Utilities.getDocument((char)leg, (Object)this.viewer.getInput(), (boolean)true, (boolean)true);
        if (document == null) {
            return ((IMergeViewerTestAdapter)this.viewer.getAdapter(IMergeViewerTestAdapter.class)).getDocument(leg);
        }
        return document;
    }

    @Test
    public void testCopyRightToLeft() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        String copiedText = "hi there";
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 3, null, (ITypedElement)new EditableTestElement("some text".getBytes()), (ITypedElement)new EditableTestElement(copiedText.getBytes()));
        this.runInDialog(testNode, () -> {
            this.viewer.copy(false);
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)copiedText, (Object)((EditableTestElement)testNode.getLeft()).getContentsAsString());
    }

    @Test
    public void testCopyLeftToRight() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        String copiedText = "hi there";
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 3, null, (ITypedElement)new EditableTestElement(copiedText.getBytes()), (ITypedElement)new EditableTestElement("some text".getBytes()));
        this.runInDialog(testNode, () -> {
            this.viewer.copy(true);
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)copiedText, (Object)((EditableTestElement)testNode.getRight()).getContentsAsString());
    }

    @Test
    public void testCopyRightToEmptyLeft() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 1, null, null, (ITypedElement)new EditableTestElement("hi there".getBytes()));
        this.runInDialog(testNode, () -> {
            this.viewer.copy(false);
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)testNode.getRight(), (Object)testNode.getLeft());
    }

    @Test
    public void testCopyLeftToEmptyRight() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 2, null, (ITypedElement)new EditableTestElement("hi there".getBytes()), null);
        this.runInDialog(testNode, () -> {
            this.viewer.copy(true);
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)testNode.getRight(), (Object)testNode.getLeft());
    }

    @Test
    public void testCopyEmptyLeftToRight() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 1, null, null, (ITypedElement)new EditableTestElement("hi there".getBytes()));
        this.runInDialog(testNode, () -> {
            this.viewer.copy(true);
            this.saveViewerContents();
        });
        Assert.assertNull((Object)testNode.getLeft());
        Assert.assertNull((Object)testNode.getRight());
    }

    @Test
    public void testCopyEmptyRightToLeft() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 2, null, (ITypedElement)new EditableTestElement("hi there".getBytes()), null);
        this.runInDialog(testNode, () -> {
            this.viewer.copy(false);
            this.saveViewerContents();
        });
        Assert.assertNull((Object)testNode.getLeft());
        Assert.assertNull((Object)testNode.getRight());
    }

    @Test
    public void testModifyLeft() throws Exception {
        DiffNode testNode = new DiffNode((ITypedElement)new EditableTestElement("hi there".getBytes()), null);
        this.runInDialog(testNode, () -> {
            IDocument doc = this.getDocument(true);
            doc.set("New text");
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)"New text", (Object)((EditableTestElement)testNode.getLeft()).getContentsAsString());
    }

    @Test
    public void testModifyRight() throws Exception {
        DiffNode testNode = new DiffNode(null, (ITypedElement)new EditableTestElement("hi there".getBytes()));
        this.runInDialog(testNode, () -> {
            IDocument doc = this.getDocument(false);
            doc.set("New text");
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)"New text", (Object)((EditableTestElement)testNode.getRight()).getContentsAsString());
    }

    @Test
    public void testCopyEmptyRightToLeftAndModify() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 1, null, null, (ITypedElement)new EditableTestElement("hi there".getBytes()));
        this.runInDialog(testNode, () -> {
            this.viewer.copy(false);
            IDocument doc = this.getDocument(true);
            doc.set("New text");
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)"New text", (Object)((EditableTestElement)testNode.getLeft()).getContentsAsString());
    }

    @Test
    public void testCopyEmptyLeftToRightAndModify() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 2, null, (ITypedElement)new EditableTestElement("hi there".getBytes()), null);
        this.runInDialog(testNode, () -> {
            this.viewer.copy(true);
            IDocument doc = this.getDocument(false);
            doc.set("New text");
            this.saveViewerContents();
        });
        Assert.assertEquals((Object)"New text", (Object)((EditableTestElement)testNode.getRight()).getContentsAsString());
    }

    @Test
    public void testCompareFilter() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        final EditableTestElement leftElement = new EditableTestElement("HI there".getBytes());
        final EditableTestElement rightElement = new EditableTestElement("hi there".getBytes());
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 3, null, (ITypedElement)leftElement, (ITypedElement)rightElement);
        CompareConfiguration cc = new CompareConfiguration();
        this.runInDialog(testNode, () -> {
            Object adapter = this.viewer.getAdapter(IMergeViewerTestAdapter.class);
            if (adapter instanceof IMergeViewerTestAdapter) {
                IMergeViewerTestAdapter ta = (IMergeViewerTestAdapter)adapter;
                Assert.assertEquals((long)ta.getChangesCount(), (long)1L);
                HashMap<String, 2> filters = new HashMap<String, 2>();
                filters.put("filter.id", new ICompareFilter(){

                    public void setInput(Object input, Object ancestor, Object left, Object right) {
                        Assert.assertTrue((leftElement == left ? 1 : 0) != 0);
                        Assert.assertTrue((rightElement == right ? 1 : 0) != 0);
                    }

                    public IRegion[] getFilteredRegions(HashMap lineComparison) {
                        Object thisLine = lineComparison.get("THIS_LINE");
                        Object thisContributor = lineComparison.get("THIS_CONTRIBUTOR");
                        Object otherLine = lineComparison.get("OTHER_LINE");
                        Object otherContributor = lineComparison.get("OTHER_CONTRIBUTOR");
                        if (thisContributor.equals(Character.valueOf('L'))) {
                            Assert.assertEquals(thisLine, (Object)"HI there");
                            Assert.assertEquals(otherContributor, (Object)Character.valueOf('R'));
                            Assert.assertEquals(otherLine, (Object)"hi there");
                        } else {
                            Assert.assertEquals(thisContributor, (Object)Character.valueOf('R'));
                            Assert.assertEquals(thisLine, (Object)"hi there");
                            Assert.assertEquals(otherContributor, (Object)Character.valueOf('L'));
                            Assert.assertEquals(otherLine, (Object)"HI there");
                        }
                        if (thisContributor.equals(Character.valueOf('L'))) {
                            return new IRegion[]{new Region(0, 1), new Region(1, 1)};
                        }
                        return new IRegion[]{new Region(0, 2)};
                    }

                    public boolean isEnabledInitially() {
                        return false;
                    }

                    public boolean canCacheFilteredRegions() {
                        return true;
                    }
                });
                cc.setProperty("COMPARE_FILTERS", filters);
                Assert.assertEquals((long)ta.getChangesCount(), (long)0L);
                cc.setProperty("COMPARE_FILTERS", null);
                Assert.assertEquals((long)ta.getChangesCount(), (long)1L);
            }
        }, cc);
    }

    @Test
    public void testDocumentAsTypedElement() throws Exception {
        DiffNode parentNode = new DiffNode((ITypedElement)new ParentTestElement(), (ITypedElement)new ParentTestElement());
        class DocumentAsTypedElement
        extends Document
        implements ITypedElement {
            DocumentAsTypedElement() {
            }

            public String getName() {
                return "file";
            }

            public Image getImage() {
                return null;
            }

            public String getType() {
                return "???";
            }
        }
        DocumentAsTypedElement leftDoc = new DocumentAsTypedElement();
        DocumentAsTypedElement rightDoc = new DocumentAsTypedElement();
        DiffNode testNode = new DiffNode((IDiffContainer)parentNode, 2, null, (ITypedElement)leftDoc, (ITypedElement)rightDoc);
        this.runInDialogWithPartioner(testNode, () -> {}, new CompareConfiguration());
        Assert.assertNotNull((Object)leftDoc.getDocumentPartitioner());
        Assert.assertNotNull((Object)rightDoc.getDocumentPartitioner());
    }

    private void runInDialogWithPartioner(Object input, Runnable runnable, final CompareConfiguration cc) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Dialog dialog = new Dialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                TextMergeViewerTest.this.viewer = new TestMergeViewerWithPartitioner(composite, cc);
                return composite;
            }
        };
        dialog.setBlockOnOpen(false);
        dialog.open();
        this.viewer.setInput(input);
        try {
            runnable.run();
        }
        catch (WrappedException e) {
            e.throwException();
        }
        dialog.close();
        this.viewer = null;
    }

    public static class EditableTestElement
    extends TestElement
    implements IStreamContentAccessor,
    IEditableContent {
        byte[] contents = new byte[0];

        public EditableTestElement(byte[] contents) {
            this.contents = contents;
        }

        @Override
        public String getType() {
            return "txt";
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.contents);
        }

        protected Object clone() {
            return new EditableTestElement(this.contents);
        }

        public boolean isEditable() {
            return true;
        }

        public ITypedElement replace(ITypedElement dest, ITypedElement src) {
            return null;
        }

        public void setContent(byte[] newContent) {
            this.contents = newContent;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EditableTestElement) {
                EditableTestElement other = (EditableTestElement)obj;
                return TextMergeViewerTest.compareContent(other.getContents(), this.getContents());
            }
            return false;
        }

        public Object getContentsAsString() {
            return new String(this.contents);
        }
    }

    public static class ParentTestElement
    extends TestElement
    implements IEditableContent {
        public boolean isEditable() {
            return false;
        }

        public ITypedElement replace(ITypedElement child, ITypedElement other) {
            if (child == null && other instanceof EditableTestElement) {
                EditableTestElement ete = (EditableTestElement)other;
                return (ITypedElement)ete.clone();
            }
            if (other == null) {
                return null;
            }
            if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
                IEditableContent dst = (IEditableContent)child;
                try {
                    InputStream is = ((IStreamContentAccessor)other).getContents();
                    byte[] bytes = Utilities.readBytes((InputStream)is);
                    if (bytes != null) {
                        dst.setContent(bytes);
                    }
                }
                catch (CoreException ex) {
                    throw new WrappedException((Exception)((Object)ex));
                }
            }
            return child;
        }

        public void setContent(byte[] newContent) {
        }
    }

    public static class TestElement
    implements ITypedElement {
        public Image getImage() {
            return null;
        }

        public String getName() {
            return "test";
        }

        public String getType() {
            return "???";
        }
    }

    public static class TestMergeViewer
    extends TextMergeViewer {
        public TestMergeViewer(Composite parent) {
            super(parent, new CompareConfiguration());
        }

        public TestMergeViewer(Composite parent, CompareConfiguration cc) {
            super(parent, cc);
        }

        public void copy(boolean leftToRight) {
            super.copy(leftToRight);
        }
    }

    public static class TestMergeViewerWithPartitioner
    extends TestMergeViewer {
        public TestMergeViewerWithPartitioner(Composite parent) {
            super(parent, new CompareConfiguration());
        }

        public TestMergeViewerWithPartitioner(Composite parent, CompareConfiguration cc) {
            super(parent, cc);
        }

        @Override
        public void copy(boolean leftToRight) {
            super.copy(leftToRight);
        }

        protected IDocumentPartitioner getDocumentPartitioner() {
            return new DummyPartitioner();
        }

        public class DummyPartitioner
        implements IDocumentPartitioner {
            public void connect(IDocument document) {
            }

            public void disconnect() {
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public boolean documentChanged(DocumentEvent event) {
                return false;
            }

            public String[] getLegalContentTypes() {
                return null;
            }

            public String getContentType(int offset) {
                return null;
            }

            public ITypedRegion[] computePartitioning(int offset, int length) {
                return null;
            }

            public ITypedRegion getPartition(int offset) {
                return null;
            }
        }
    }

    public static class WrappedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        Exception exception;

        public WrappedException(Exception exception) {
            this.exception = exception;
        }

        public void throwException() throws Exception {
            throw this.exception;
        }
    }
}

