/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.Property;
import org.eclipse.core.internal.expressions.TestExpression;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.internal.expressions.tests.A;
import org.eclipse.core.internal.expressions.tests.B;
import org.eclipse.core.internal.expressions.tests.I;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class PropertyTesterTests
extends TestCase {
    private A a;
    private B b;
    private I i;
    private static final TypeExtensionManager fgManager = new TypeExtensionManager("propertyTesters");
    private static final boolean TEST_DYNAMIC_AND_ACTIVATION = false;

    public static Test suite() {
        return new TestSuite(PropertyTesterTests.class);
    }

    protected void setUp() throws Exception {
        this.a = new A();
        this.b = new B();
        this.i = this.b;
    }

    public void testSimple() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "simple", null, "simple"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "simple", null, "simple"));
    }

    public void testInherited() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "simple", null, "simple"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.i, "simple", null, "simple"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "simple", null, "simple"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.i, "simple", null, "simple"));
    }

    public void testUnknown() throws Exception {
        try {
            this.test(this.a, "unknown", null, null);
        }
        catch (CoreException coreException) {
            return;
        }
        PropertyTesterTests.assertTrue((boolean)false);
    }

    public void testOverridden() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "overridden", null, "A"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "overridden", null, "B"));
        B b_as_a = this.b;
        PropertyTesterTests.assertTrue((boolean)this.test(b_as_a, "overridden", null, "B"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.i, "overridden", null, "B"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "overridden", null, "A"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "overridden", null, "B"));
        PropertyTesterTests.assertTrue((boolean)this.test(b_as_a, "overridden", null, "B"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.i, "overridden", null, "B"));
    }

    public void testOdering() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "ordering", null, "A"));
        I other = new I(){};
        PropertyTesterTests.assertTrue((boolean)this.test(other, "ordering", null, "I"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.b, "ordering", null, "A"));
        PropertyTesterTests.assertTrue((boolean)this.test(other, "ordering", null, "I"));
    }

    public void testChaining() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "chaining", null, "A2"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "chaining", null, "A2"));
    }

    public void testChainOrdering() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "chainOrdering", null, "A"));
        PropertyTesterTests.assertTrue((boolean)this.test(this.a, "chainOrdering", null, "A"));
    }

    public void testWrongNameSpace() throws Exception {
        try {
            this.test(this.a, "differentNamespace", null, null);
        }
        catch (CoreException coreException) {
            return;
        }
        PropertyTesterTests.assertTrue((boolean)false);
    }

    public void testDynamicPlugin() throws Exception {
    }

    public void testPluginActivation() throws Exception {
    }

    public void testPlatformTester() throws Exception {
        TestExpression exp = new TestExpression("org.eclipse.core.runtime", "bundleState", new Object[]{"org.eclipse.core.expressions"}, (Object)"ACTIVE", false);
        EvaluationContext context = new EvaluationContext(null, Platform.class);
        EvaluationResult result = exp.evaluate((IEvaluationContext)context);
        PropertyTesterTests.assertEquals((Object)EvaluationResult.TRUE, (Object)result);
    }

    public void testDifferentNameSpace() throws Exception {
        PropertyTesterTests.assertTrue((boolean)this.test("org.eclipse.core.internal.expressions.tests2", this.a, "differentNamespace", null, "A3"));
    }

    private boolean test(Object receiver, String property, Object[] args, Object expectedValue) throws CoreException {
        Property p = fgManager.getProperty(receiver, "org.eclipse.core.internal.expressions.tests", property);
        PropertyTesterTests.assertTrue((boolean)p.isInstantiated());
        return p.test(receiver, args, expectedValue);
    }

    private boolean test(String namespace, Object receiver, String property, Object[] args, Object expectedValue) throws CoreException {
        Property p = fgManager.getProperty(receiver, namespace, property);
        PropertyTesterTests.assertTrue((boolean)p.isInstantiated());
        return p.test(receiver, args, expectedValue);
    }
}

