/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.MockDocumentSetupParticipants;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractFileBufferDocCreationTests {
    protected ITextFileBufferManager fManager;

    @Test
    public void testCreateDocumentPartipants_FileExt() {
        this.assertParticipantsInvoked("anything.111foo", new Class[]{MockDocumentSetupParticipants.TestDSP1.class, MockDocumentSetupParticipants.TestDSP3.class});
    }

    @Test
    public void testCreateDocumentPartipants_Name() {
        this.assertParticipantsInvoked("111fooname", new Class[]{MockDocumentSetupParticipants.TestDSP2.class, MockDocumentSetupParticipants.TestDSP3.class});
    }

    @Test
    public void testCreateDocumentPartipants_FileExt_Name() {
        this.assertParticipantsInvoked("111fooname.111foo", new Class[]{MockDocumentSetupParticipants.TestDSP1.class, MockDocumentSetupParticipants.TestDSP2.class, MockDocumentSetupParticipants.TestDSP3.class});
    }

    @Test
    public void testCreateDocumentPartipants_FileExt_Extension() {
        this.assertParticipantsInvoked("anything.222foo", new Class[]{MockDocumentSetupParticipants.TestDSP4.class, MockDocumentSetupParticipants.TestDSP6.class});
    }

    @Test
    public void testCreateDocumentPartipants_Name_Extension() {
        this.assertParticipantsInvoked("222fooname", new Class[]{MockDocumentSetupParticipants.TestDSP5.class, MockDocumentSetupParticipants.TestDSP6.class});
    }

    @Test
    public void testCreateDocumentPartipants_FileExt_Name_Extension() {
        this.assertParticipantsInvoked("222fooname.222foo", new Class[]{MockDocumentSetupParticipants.TestDSP4.class, MockDocumentSetupParticipants.TestDSP5.class, MockDocumentSetupParticipants.TestDSP6.class});
    }

    @Test
    public void testDocumentSetupParticipantExtension_1() {
        this.assertDocumentContent("emanoof333/p/", "/p/333fooname", LocationKind.IFILE);
        this.assertDocumentContent("oof333.emanoof333/p/", "/p/333fooname.333foo", LocationKind.IFILE);
        this.assertDocumentContent("oof333.gnihtyna/p/", "/p/anything.333foo", LocationKind.IFILE);
        this.assertDocumentContent("", "333fooname", LocationKind.LOCATION);
        this.assertDocumentContent("", "333fooname.333foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "anything.333foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "333fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "333fooname.333foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "anything.333foo", LocationKind.NORMALIZE);
    }

    @Test
    public void testDocumentSetupParticipantExtension_2() {
        this.assertDocumentContent("", "/p/444fooname", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/444fooname.444foo", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/anything.444foo", LocationKind.IFILE);
        this.assertDocumentContent("emanoof444", "444fooname", LocationKind.LOCATION);
        this.assertDocumentContent("oof444.emanoof444", "444fooname.444foo", LocationKind.LOCATION);
        this.assertDocumentContent("oof444.gnihtyna", "anything.444foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "444fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "444fooname.444foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("", "anything.444foo", LocationKind.NORMALIZE);
    }

    @Test
    public void testDocumentSetupParticipantExtension_3() {
        this.assertDocumentContent("", "/p/555fooname", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/555fooname.555foo", LocationKind.IFILE);
        this.assertDocumentContent("", "/p/anything.555foo", LocationKind.IFILE);
        this.assertDocumentContent("", "555fooname", LocationKind.LOCATION);
        this.assertDocumentContent("", "555fooname.555foo", LocationKind.LOCATION);
        this.assertDocumentContent("", "anything.555foo", LocationKind.LOCATION);
        this.assertDocumentContent("emanoof555", "555fooname", LocationKind.NORMALIZE);
        this.assertDocumentContent("oof555.emanoof555", "555fooname.555foo", LocationKind.NORMALIZE);
        this.assertDocumentContent("oof555.gnihtyna", "anything.555foo", LocationKind.NORMALIZE);
    }

    private void assertParticipantsInvoked(String path, Class<?>[] expectedDSPsArray) {
        LocationKind[] lks = this.getSupportLocationKinds();
        int i = 0;
        while (i < lks.length) {
            IDocument document = this.fManager.createEmptyDocument((IPath)new Path(path), lks[i]);
            String content = document.get();
            HashSet<String> expectedDSPs = new HashSet<String>(Arrays.asList(AbstractFileBufferDocCreationTests.toString(expectedDSPsArray)));
            HashSet<String> actualDSPs = new HashSet<String>(Arrays.asList(content.split("\n")));
            Assert.assertEquals(expectedDSPs, actualDSPs);
            ++i;
        }
    }

    protected abstract LocationKind[] getSupportLocationKinds();

    protected void assertDocumentContent(String expectedContent, String path, LocationKind locKind) {
        Assert.assertEquals((Object)expectedContent, (Object)this.fManager.createEmptyDocument((IPath)new Path(path), locKind).get());
    }

    private static String[] toString(Class<?>[] clss) {
        String[] result = new String[clss.length];
        int i = 0;
        while (i < result.length) {
            String s = null;
            if (clss[i] != null) {
                s = clss[i].toString();
                if (IDocumentSetupParticipantExtension.class.isAssignableFrom(clss[i])) {
                    s = String.valueOf(s) + "%%EXTENSION";
                }
            }
            result[i] = s;
            ++i;
        }
        return result;
    }
}

