/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBufferCreation {
    private static final String CONTENT1 = "This is the content of the workspace file.";
    private static final String CONTENT2 = "This is the content of the link target.";
    private static final String CONTENT3 = "This is the content of the external file.";
    private static final String CONTENT4 = "This is the content of a file in a linked folder.";
    private IProject fProject;

    @Before
    public void setUp() throws Exception {
        this.fProject = ResourceHelper.createProject("project");
    }

    @After
    public void tearDown() throws Exception {
        ResourceHelper.deleteProject("project");
    }

    private IPath createLinkedFile(String linkedFileName, String linkedFileTarget) throws CoreException {
        IFile linkedFile = ResourceHelper.createLinkedFile((IContainer)this.fProject, (IPath)new Path(linkedFileName), FileBuffersTestPlugin.getDefault(), (IPath)new Path(linkedFileTarget));
        return linkedFile.getFullPath();
    }

    private IPath createLinkedFolder(String linkedFolderName, String linkedFolderTarget) throws CoreException {
        IFolder linkedFolder = ResourceHelper.createLinkedFolder((IContainer)this.fProject, (IPath)new Path(linkedFolderName), FileBuffersTestPlugin.getDefault(), (IPath)new Path(linkedFolderTarget));
        return linkedFolder.getFullPath();
    }

    @Test
    public void test1() throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "file", CONTENT1);
        IPath path = file.getFullPath();
        Assert.assertNotNull((Object)path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)CONTENT1, (Object)document.get());
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.NORMALIZE));
    }

    @Test
    public void test1_IFileStore() throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "file", CONTENT1);
        IPath path = file.getFullPath();
        Assert.assertNotNull((Object)path);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.getLocation());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connectFileStore(fileStore, null);
        ITextFileBuffer buffer = manager.getFileStoreTextFileBuffer(fileStore);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)CONTENT1, (Object)document.get());
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnectFileStore(fileStore, null);
        Assert.assertNull((Object)manager.getFileStoreTextFileBuffer(fileStore));
    }

    @Test
    public void test2() throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "file", CONTENT1);
        IPath path1 = file.getFullPath();
        Assert.assertNotNull((Object)path1);
        IPath path2 = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        path2 = path2.append(path1.makeAbsolute());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path1, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer1 = manager.getTextFileBuffer(path1, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer1);
        ITextFileBuffer buffer2 = manager.getTextFileBuffer(path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        manager.connect(path2, LocationKind.NORMALIZE, null);
        buffer2 = manager.getTextFileBuffer(path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        IDocument document1 = buffer1.getDocument();
        Assert.assertNotNull((Object)document1);
        Assert.assertEquals((Object)CONTENT1, (Object)document1.get());
        Assert.assertSame((Object)buffer1, (Object)manager.getTextFileBuffer(document1));
        IDocument document2 = buffer2.getDocument();
        Assert.assertNotNull((Object)document2);
        Assert.assertEquals((Object)CONTENT1, (Object)document2.get());
        Assert.assertSame((Object)buffer2, (Object)manager.getTextFileBuffer(document2));
        try {
            document1.replace(0, document1.getLength(), CONTENT3);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertEquals((Object)CONTENT3, (Object)document2.get());
        manager.disconnect(path1, LocationKind.NORMALIZE, null);
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path1, LocationKind.NORMALIZE));
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
        manager.disconnect(path2, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path1, LocationKind.NORMALIZE));
        Assert.assertNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
    }

    @Test
    public void test3_1() throws Exception {
        IPath path = this.createLinkedFile("file", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT2.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.NORMALIZE));
    }

    @Test
    public void test3_2() throws Exception {
        IPath path = this.createLinkedFolder("linkedFolder", "testResources/linkedFolderTarget");
        Assert.assertNotNull((Object)path);
        path = path.append("FileInLinkedFolder");
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT4.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.NORMALIZE));
    }

    @Test
    public void test4() throws Exception {
        IPath path1 = this.createLinkedFile("file1", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path1);
        IPath path2 = this.createLinkedFile("file2", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path1, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer1 = manager.getTextFileBuffer(path1, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer1);
        manager.connect(path2, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer2 = manager.getTextFileBuffer(path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        IDocument document1 = buffer1.getDocument();
        Assert.assertNotNull((Object)document1);
        Assert.assertSame((Object)buffer1, (Object)manager.getTextFileBuffer(document1));
        IDocument document2 = buffer2.getDocument();
        Assert.assertNotNull((Object)document2);
        Assert.assertSame((Object)buffer2, (Object)manager.getTextFileBuffer(document2));
        Assert.assertEquals((Object)document1.get(), (Object)document2.get());
        Assert.assertEquals((Object)CONTENT2, (Object)document1.get());
        try {
            document1.replace(0, document1.getLength(), CONTENT1);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertFalse((boolean)false);
        }
        Assert.assertFalse((boolean)document1.get().equals(document2.get()));
        manager.disconnect(path1, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path1, LocationKind.NORMALIZE));
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
        manager.disconnect(path2, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
    }

    @Test
    public void test5() throws Exception {
        File externalFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/ExternalFile"));
        Assert.assertNotNull((Object)externalFile);
        Path path = new Path(externalFile.getAbsolutePath());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect((IPath)path, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)path, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT3.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect((IPath)path, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer((IPath)path, LocationKind.NORMALIZE));
    }

    @Test
    public void test6() throws Exception {
        IPath path1 = this.createLinkedFile("file1", "testResources/ExternalFile");
        Assert.assertNotNull((Object)path1);
        File externalFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/ExternalFile"));
        Assert.assertNotNull((Object)externalFile);
        Path path2 = new Path(externalFile.getAbsolutePath());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path1, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer1 = manager.getTextFileBuffer(path1, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer1);
        manager.connect((IPath)path2, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer2 = manager.getTextFileBuffer((IPath)path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        IDocument document1 = buffer1.getDocument();
        Assert.assertNotNull((Object)document1);
        Assert.assertSame((Object)buffer1, (Object)manager.getTextFileBuffer(document1));
        IDocument document2 = buffer2.getDocument();
        Assert.assertNotNull((Object)document2);
        Assert.assertSame((Object)buffer2, (Object)manager.getTextFileBuffer(document2));
        Assert.assertEquals((Object)document1.get(), (Object)document2.get());
        Assert.assertEquals((Object)CONTENT3, (Object)document1.get());
        try {
            document1.replace(0, document1.getLength(), CONTENT1);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertFalse((boolean)false);
        }
        Assert.assertFalse((boolean)document1.get().equals(document2.get()));
        manager.disconnect(path1, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path1, LocationKind.NORMALIZE));
        manager.disconnect((IPath)path2, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer((IPath)path2, LocationKind.NORMALIZE));
    }

    @Test
    public void test7() throws Exception {
        IPath path = FileBuffersTestPlugin.getDefault().getStateLocation();
        path = path.append("NonExistingFile");
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.NORMALIZE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)"".equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.NORMALIZE));
    }

    @Test
    public void test1_IFILE() throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "file", CONTENT1);
        IPath path = file.getFullPath();
        Assert.assertNotNull((Object)path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.IFILE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)CONTENT1, (Object)document.get());
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.IFILE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.IFILE));
    }

    @Test
    public void test2_new() throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "file", CONTENT1);
        IPath path1 = file.getFullPath();
        Assert.assertNotNull((Object)path1);
        IPath path2 = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        path2 = path2.append(path1.makeAbsolute());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path1, LocationKind.IFILE, null);
        ITextFileBuffer buffer1 = manager.getTextFileBuffer(path1, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer1);
        ITextFileBuffer buffer2 = manager.getTextFileBuffer(path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        manager.connect(path2, LocationKind.NORMALIZE, null);
        buffer2 = manager.getTextFileBuffer(path2, LocationKind.NORMALIZE);
        Assert.assertNotNull((Object)buffer2);
        IDocument document1 = buffer1.getDocument();
        Assert.assertNotNull((Object)document1);
        Assert.assertEquals((Object)CONTENT1, (Object)document1.get());
        Assert.assertSame((Object)buffer1, (Object)manager.getTextFileBuffer(document1));
        IDocument document2 = buffer2.getDocument();
        Assert.assertNotNull((Object)document2);
        Assert.assertEquals((Object)CONTENT1, (Object)document2.get());
        Assert.assertSame((Object)buffer2, (Object)manager.getTextFileBuffer(document2));
        try {
            document1.replace(0, document1.getLength(), CONTENT3);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertEquals((Object)CONTENT3, (Object)document2.get());
        manager.disconnect(path1, LocationKind.IFILE, null);
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path1, LocationKind.IFILE));
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
        manager.disconnect(path2, LocationKind.NORMALIZE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path1, LocationKind.IFILE));
        Assert.assertNull((Object)manager.getTextFileBuffer(path2, LocationKind.NORMALIZE));
    }

    @Test
    public void test3_1_IFILE() throws Exception {
        IPath path = this.createLinkedFile("file", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.IFILE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT2.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.IFILE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.IFILE));
    }

    @Test
    public void test3_2_new() throws Exception {
        IPath path = this.createLinkedFolder("linkedFolder", "testResources/linkedFolderTarget");
        Assert.assertNotNull((Object)path);
        path = path.append("FileInLinkedFolder");
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.IFILE, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT4.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.IFILE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.IFILE));
    }

    @Test
    public void test4_IFILE() throws Exception {
        IPath path1 = this.createLinkedFile("file1", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path1);
        IPath path2 = this.createLinkedFile("file2", "testResources/LinkedFileTarget");
        Assert.assertNotNull((Object)path2);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path1, LocationKind.IFILE, null);
        ITextFileBuffer buffer1 = manager.getTextFileBuffer(path1, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer1);
        manager.connect(path2, LocationKind.IFILE, null);
        ITextFileBuffer buffer2 = manager.getTextFileBuffer(path2, LocationKind.IFILE);
        Assert.assertNotNull((Object)buffer2);
        IDocument document1 = buffer1.getDocument();
        Assert.assertNotNull((Object)document1);
        Assert.assertSame((Object)buffer1, (Object)manager.getTextFileBuffer(document1));
        IDocument document2 = buffer2.getDocument();
        Assert.assertNotNull((Object)document2);
        Assert.assertSame((Object)buffer2, (Object)manager.getTextFileBuffer(document2));
        Assert.assertEquals((Object)document1.get(), (Object)document2.get());
        Assert.assertEquals((Object)CONTENT2, (Object)document1.get());
        try {
            document1.replace(0, document1.getLength(), CONTENT1);
        }
        catch (BadLocationException badLocationException) {
            Assert.assertFalse((boolean)false);
        }
        Assert.assertFalse((boolean)document1.get().equals(document2.get()));
        manager.disconnect(path1, LocationKind.IFILE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path1, LocationKind.IFILE));
        Assert.assertNotNull((Object)manager.getTextFileBuffer(path2, LocationKind.IFILE));
        manager.disconnect(path2, LocationKind.IFILE, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path2, LocationKind.IFILE));
    }

    @Test
    public void test5_location() throws Exception {
        File externalFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/ExternalFile"));
        Assert.assertNotNull((Object)externalFile);
        Path path = new Path(externalFile.getAbsolutePath());
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect((IPath)path, LocationKind.LOCATION, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)CONTENT3.equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect((IPath)path, LocationKind.LOCATION, null);
        Assert.assertNull((Object)manager.getTextFileBuffer((IPath)path, LocationKind.LOCATION));
    }

    @Test
    public void test7_location() throws Exception {
        IPath path = FileBuffersTestPlugin.getDefault().getStateLocation();
        path = path.append("NonExistingFile");
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(path, LocationKind.LOCATION, null);
        ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.LOCATION);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)"".equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnect(path, LocationKind.LOCATION, null);
        Assert.assertNull((Object)manager.getTextFileBuffer(path, LocationKind.LOCATION));
    }

    @Test
    public void test7_IFileStore() throws Exception {
        IPath path = FileBuffersTestPlugin.getDefault().getStateLocation();
        path = path.append("NonExistingFile");
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(path);
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connectFileStore(fileStore, null);
        ITextFileBuffer buffer = manager.getFileStoreTextFileBuffer(fileStore);
        Assert.assertNotNull((Object)buffer);
        IDocument document = buffer.getDocument();
        Assert.assertNotNull((Object)document);
        Assert.assertTrue((boolean)"".equals(document.get()));
        Assert.assertSame((Object)buffer, (Object)manager.getTextFileBuffer(document));
        manager.disconnectFileStore(fileStore, null);
        Assert.assertNull((Object)manager.getFileStoreTextFileBuffer(fileStore));
    }
}

