/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileBuffersTestPlugin;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.osgi.framework.Bundle;

public class FileBuffersForLinkedFiles
extends FileBufferFunctions {
    private File fExternalFile;

    @Override
    @After
    public void tearDown() {
        FileTool.delete(this.fExternalFile);
        FileTool.delete(this.fExternalFile.getParentFile());
        super.tearDown();
    }

    @Override
    protected IPath createPath(IProject project) throws Exception {
        File sourceFile = FileTool.getFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("testResources/LinkedFileTarget"));
        this.fExternalFile = FileTool.createTempFileInPlugin(FileBuffersTestPlugin.getDefault(), (IPath)new Path("externalResources/LinkedFileTarget"));
        FileTool.copy(sourceFile, this.fExternalFile);
        IFile file = ResourceHelper.createLinkedFile((IContainer)project, (IPath)new Path("LinkedFile"), this.fExternalFile);
        return file.getFullPath();
    }

    @Override
    protected void setReadOnly(boolean state) throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(state);
        file.setResourceAttributes(attributes);
    }

    @Override
    protected boolean isStateValidationSupported() {
        return true;
    }

    @Override
    protected boolean deleteUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        file.delete(true, false, null);
        return file.exists();
    }

    @Override
    protected IPath moveUnderlyingFile() throws Exception {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        ResourceHelper.createFolder("project/folderA");
        Path path = new Path("/project/folderA/MovedLinkedFile");
        file.move((IPath)path, true, false, null);
        file = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (file != null && file.exists()) {
            return path;
        }
        return null;
    }

    @Override
    protected boolean modifyUnderlyingFile() throws Exception {
        FileTool.write(this.fExternalFile.getAbsolutePath(), new StringBuffer("Changed content of linked file"));
        this.fExternalFile.setLastModified(1000L);
        IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)this.getPath());
        iFile.refreshLocal(2, null);
        return true;
    }

    @Override
    protected Class<IAnnotationModel> getAnnotationModelClass() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.editors");
        return bundle != null ? IAnnotationModel.class : null;
    }
}

