/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class MockDocumentSetupParticipants {
    private static void append(IDocument document, String string) {
        try {
            document.replace(document.getLength(), 0, string);
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
    }

    static abstract class AbstractTestDSP
    implements IDocumentSetupParticipant {
        AbstractTestDSP() {
        }

        public void setup(IDocument document) {
            MockDocumentSetupParticipants.append(document, this.getClass() + "\n");
        }
    }

    static abstract class AbstractTestDSPExtension
    extends AbstractTestDSP
    implements IDocumentSetupParticipantExtension {
        AbstractTestDSPExtension() {
        }

        public void setup(IDocument document, IPath location, LocationKind locationKind) {
            MockDocumentSetupParticipants.append(document, this.getClass() + "%%EXTENSION\n");
        }
    }

    public static class TestDSP1
    extends AbstractTestDSP {
    }

    public static class TestDSP2
    extends AbstractTestDSP {
    }

    public static class TestDSP3
    extends AbstractTestDSP {
    }

    public static class TestDSP4
    extends AbstractTestDSPExtension {
    }

    public static class TestDSP5
    extends AbstractTestDSPExtension {
    }

    public static class TestDSP6
    extends AbstractTestDSPExtension {
    }

    public static class TestDSP7
    extends AbstractTestDSPExtension {
        @Override
        public void setup(IDocument document, IPath location, LocationKind locationKind) {
            if (locationKind == LocationKind.IFILE) {
                MockDocumentSetupParticipants.append(document, new StringBuilder(location.toPortableString()).reverse().toString());
            }
        }
    }

    public static class TestDSP8
    extends AbstractTestDSPExtension {
        @Override
        public void setup(IDocument document, IPath location, LocationKind locationKind) {
            if (locationKind == LocationKind.LOCATION) {
                MockDocumentSetupParticipants.append(document, new StringBuilder(location.toPortableString()).reverse().toString());
            }
        }
    }

    public static class TestDSP9
    extends AbstractTestDSPExtension {
        @Override
        public void setup(IDocument document, IPath location, LocationKind locationKind) {
            if (locationKind == LocationKind.NORMALIZE) {
                MockDocumentSetupParticipants.append(document, new StringBuilder(location.toPortableString()).reverse().toString());
            }
        }
    }
}

