/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.TestRegistryChangeListener;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleTestingHelper {
    public static Bundle[] getBundles(BundleContext context, String symbolicName, String version) {
        ServiceReference packageAdminReference = context.getServiceReference(PackageAdmin.class);
        if (packageAdminReference == null) {
            throw new IllegalStateException("No package admin service found");
        }
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(packageAdminReference);
        Bundle[] result = packageAdmin.getBundles(symbolicName, version);
        context.ungetService(packageAdminReference);
        return result;
    }

    @Deprecated
    public static Bundle installBundle(BundleContext context, String location) throws BundleException, MalformedURLException, IOException {
        return BundleTestingHelper.installBundle("", context, location);
    }

    public static Bundle installBundle(String tag, BundleContext context, String location) throws BundleException, MalformedURLException, IOException {
        URL entry = context.getBundle().getEntry(location);
        if (entry == null) {
            Assert.fail((String)(String.valueOf(tag) + " entry " + location + " could not be found in " + context.getBundle().getSymbolicName()));
        }
        Bundle installed = context.installBundle(FileLocator.toFileURL((URL)entry).toExternalForm());
        return installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void refreshPackages(BundleContext context, Bundle[] bundles) {
        if (bundles.length == 0) {
            return;
        }
        ServiceReference packageAdminRef = context.getServiceReference(PackageAdmin.class);
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        boolean[] flag = new boolean[1];
        FrameworkListener listener = event -> {
            if (event.getType() != 4) return;
            boolean[] blArray2 = flag;
            synchronized (flag) {
                blArray[0] = true;
                flag.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        boolean[] blArray = flag;
        synchronized (flag) {
            while (true) {
                if (flag[0]) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    break;
                }
                try {
                    flag.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            context.removeFrameworkListener(listener);
            context.ungetService(packageAdminRef);
            return;
        }
    }

    public static boolean resolveBundles(BundleContext context, Bundle[] bundles) {
        ServiceReference packageAdminRef = context.getServiceReference(PackageAdmin.class);
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return false;
        }
        boolean result = packageAdmin.resolveBundles(bundles);
        context.ungetService(packageAdminRef);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void runWithBundles(String tag, Runnable runnable, BundleContext context, String[] locations, TestRegistryChangeListener listener) {
        if (listener != null) {
            listener.register();
        }
        try {
            installed = new Bundle[locations.length];
            i = 0;
            while (i < locations.length) {
                try {
                    installed[i] = BundleTestingHelper.installBundle(String.valueOf(tag) + ".setup.0", context, locations[i]);
                    Assert.assertEquals((String)(String.valueOf(tag) + ".setup.1." + locations[i]), (long)2L, (long)installed[i].getState());
                }
                catch (BundleException e) {
                    CoreTest.fail(String.valueOf(tag) + ".setup.2" + locations[i], e);
                }
                catch (IOException e) {
                    CoreTest.fail(String.valueOf(tag) + ".setup.3" + locations[i], e);
                }
                ++i;
            }
            if (listener != null) {
                listener.reset();
            }
            if (!BundleTestingHelper.resolveBundles(context, installed)) {
                Assert.fail((String)(String.valueOf(tag) + ".setup.resolveBundles"));
            }
            if (listener != null) {
                Assert.assertTrue((String)(String.valueOf(tag) + ".setup.4"), (boolean)listener.eventReceived(installed.length * 10000));
            }
            try {
                runnable.run();
            }
            finally {
                if (listener != null) {
                    listener.reset();
                }
                i = 0;
                ** while (i < installed.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    installed[i].uninstall();
                }
                catch (BundleException e) {
                    CoreTest.fail(String.valueOf(tag) + ".tearDown.1." + locations[i], e);
                }
                ++i;
                continue;
            }
lbl39:
            // 1 sources

            BundleTestingHelper.resolveBundles(context, installed);
            if (listener != null) {
                Assert.assertTrue((String)(String.valueOf(tag) + ".tearDown.2"), (boolean)listener.eventReceived(installed.length * 10000));
            }
        }
        finally {
            if (listener != null) {
                listener.unregister();
            }
        }
    }
}

