/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.TestProgressMonitor;
import org.junit.Assert;

public class FussyProgressMonitor
extends TestProgressMonitor {
    private static final double EPS_FACTOR = 0.01;
    private static final long NOTICEABLE_DELAY = 1000L;
    private boolean beginTaskCalled;
    private long beginTime;
    private boolean canceled;
    private int doneCalls;
    private boolean hasFailed;
    private boolean sanityCheckCalled = true;
    private String taskName;
    private int totalWork;
    private double workedSoFar;
    private Job job;

    public FussyProgressMonitor() {
        this.prepare();
    }

    public FussyProgressMonitor(Job job) {
        this();
        this.job = job;
    }

    private void assertTrue(String reason, boolean condition) {
        if (this.hasFailed) {
            return;
        }
        if (!condition) {
            this.hasFailed = true;
            if (this.job != null) {
                reason = String.valueOf(reason) + " in job: " + this.job.getName();
            }
            throw new FussyProgressAssertionFailed(reason);
        }
    }

    public void assertUsedUp() {
        this.assertTrue("beginTask has not been called on ProgressMonitor", this.beginTaskCalled);
        this.assertTrue("ProgressMonitor not used up", Math.round(this.workedSoFar) >= (long)this.totalWork);
    }

    @Override
    public void beginTask(String name, int newTotalWork) {
        Assert.assertFalse((String)("beginTask may only be called once (old name=" + this.taskName + ")"), (boolean)this.beginTaskCalled);
        this.beginTaskCalled = true;
        this.taskName = name;
        this.assertTrue("total work must be positive or UNKNOWN", newTotalWork > 0 || newTotalWork == -1);
        this.totalWork = newTotalWork;
        this.beginTime = System.currentTimeMillis();
    }

    @Override
    public void done() {
        this.workedSoFar = this.totalWork;
        ++this.doneCalls;
    }

    @Override
    public void internalWorked(double work) {
        this.assertTrue("can accept calls to worked/internalWorked only after beginTask", this.beginTaskCalled);
        this.assertTrue("can accept calls to worked/internalWorked only before done is called", this.doneCalls == 0);
        this.assertTrue("amount worked should be positive, not " + work, work >= 0.0);
        if (work == 0.0) {
            CoreTest.debug("INFO: amount worked should be positive, not " + work);
        }
        this.workedSoFar += work;
        this.assertTrue("worked " + (this.workedSoFar - (double)this.totalWork) + " more than totalWork", this.totalWork == -1 || this.workedSoFar <= (double)this.totalWork + (double)this.totalWork * 0.01);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    public void prepare() {
        this.sanityCheckCalled = false;
        this.taskName = null;
        this.totalWork = 0;
        this.workedSoFar = 0.0;
        this.beginTaskCalled = false;
        this.doneCalls = 0;
        this.hasFailed = false;
    }

    public void sanityCheck() {
        if (this.sanityCheckCalled) {
            CoreTest.debug("sanityCheck has already been called");
        }
        this.sanityCheckCalled = true;
        long duration = System.currentTimeMillis() - this.beginTime;
        if (duration > 1000L && this.beginTaskCalled) {
            this.assertTrue("this operation took: " + duration + "ms, it should report progress", this.workedSoFar > 0.0);
        }
    }

    @Override
    public void setCanceled(boolean b) {
        boolean wasCanceled = this.isCanceled();
        this.canceled = b;
        if (this.canceled && !wasCanceled && this.job != null) {
            this.job.cancel();
        }
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }

    public class FussyProgressAssertionFailed
    extends AssertionFailedError {
        private static final long serialVersionUID = 1L;

        FussyProgressAssertionFailed(String name) {
            super(name);
        }
    }
}

