/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;

public class TestRegistryChangeListener
implements IRegistryChangeListener {
    public static final int NO_EVENT = -1;
    private List<IRegistryChangeEvent> events = new LinkedList<IRegistryChangeEvent>();
    private List<Integer> simpleEvents = new LinkedList<Integer>();
    private String xpNamespace;
    private String xpId;
    private String extNamespace;
    private String extId;

    public TestRegistryChangeListener(String xpNamespace, String xpId, String extNamespace, String extId) {
        if (xpId != null && xpNamespace == null) {
            throw new IllegalArgumentException();
        }
        if (extId != null && extNamespace == null) {
            throw new IllegalArgumentException();
        }
        if (xpId == null && extId != null) {
            throw new IllegalArgumentException();
        }
        this.xpNamespace = xpNamespace;
        this.xpId = xpId;
        this.extNamespace = extNamespace;
        this.extId = extId;
    }

    public synchronized void registryChanged(IRegistryChangeEvent newEvent) {
        IExtensionDelta delta = null;
        if (this.xpId != null) {
            if (this.extId != null) {
                delta = newEvent.getExtensionDelta(this.xpNamespace, this.xpId, String.valueOf(this.extNamespace) + '.' + this.extId);
            } else {
                IExtensionDelta[] deltas = newEvent.getExtensionDeltas(this.xpNamespace, this.xpId);
                if (deltas.length != 0) {
                    delta = deltas[0];
                }
            }
        }
        if (delta == null) {
            return;
        }
        this.events.add(newEvent);
        this.simpleEvents.add(delta.getKind());
        this.notifyAll();
    }

    public synchronized IRegistryChangeEvent getEvent(long timeout) {
        if (!this.events.isEmpty()) {
            return this.events.remove(0);
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException interruptedException) {}
        return this.events.isEmpty() ? null : this.events.remove(0);
    }

    public synchronized int eventTypeReceived(long timeout) {
        long start = System.currentTimeMillis();
        while (this.simpleEvents.isEmpty()) {
            try {
                long sleepTime = timeout - (System.currentTimeMillis() - start);
                if (sleepTime <= 0L) break;
                this.wait(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.simpleEvents.isEmpty() ? -1 : this.simpleEvents.remove(0);
    }

    public synchronized boolean eventReceived(long timeout) {
        int notified = this.eventTypeReceived(timeout);
        return notified != -1;
    }

    public void register() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, this.xpNamespace);
    }

    public void unregister() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public synchronized void reset() {
        this.events.clear();
        this.simpleEvents.clear();
    }
}

