/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.session.SessionTestSuite;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.junit.Assert;
import org.osgi.framework.Bundle;

public class ConfigurationSessionTestSuite
extends SessionTestSuite {
    public static String[] MINIMAL_BUNDLE_SET = new String[]{"org.eclipse.equinox.common@2:start", "org.eclipse.core.runtime@:start", "org.eclipse.core.jobs", "org.eclipse.equinox.registry", "org.eclipse.equinox.preferences", "org.eclipse.core.contenttype", "org.eclipse.equinox.app", "org.eclipse.core.tests.harness", "org.eclipse.jdt.junit.runtime", "org.eclipse.jdt.junit4.runtime", "org.eclipse.pde.junit.runtime", "org.hamcrest.core", "org.junit", "org.eclipse.test.performance"};
    private static final String PROP_CONFIG_AREA_READ_ONLY = "osgi.configuration.area.readOnly";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private Collection<String> bundles = new ArrayList<String>();
    private Map<String, String> configIniValues = new HashMap<String, String>();
    private boolean cascaded;
    private boolean cleanUp = true;
    private IPath configurationPath = FileSystemHelper.getRandomLocation(FileSystemHelper.getTempDir());
    private boolean prime = true;
    private boolean readOnly;
    private boolean shouldSort;

    public ConfigurationSessionTestSuite(String pluginId) {
        super(pluginId);
    }

    public ConfigurationSessionTestSuite(String pluginId, Class<?> theClass) {
        super(pluginId, theClass);
        this.shouldSort = true;
    }

    public ConfigurationSessionTestSuite(String pluginId, Class<? extends TestCase> theClass, String name) {
        super(pluginId, theClass, name);
        this.shouldSort = true;
    }

    public ConfigurationSessionTestSuite(String pluginId, String name) {
        super(pluginId, name);
    }

    public void addBundle(String id) {
        this.bundles.addAll(this.getURLs(id));
    }

    public void setConfigIniValue(String key, String value) {
        this.configIniValues.put(key, value);
    }

    private void createConfigINI() throws IOException {
        Assert.assertTrue((String)"1.0", (!this.bundles.isEmpty() ? 1 : 0) != 0);
        Properties contents = new Properties();
        StringBuilder osgiBundles = new StringBuilder();
        for (String string : this.bundles) {
            osgiBundles.append(string);
            osgiBundles.append(',');
        }
        osgiBundles.deleteCharAt(osgiBundles.length() - 1);
        contents.put("osgi.bundles", osgiBundles.toString());
        String osgiFramework = this.getURLs("org.eclipse.osgi").get(0);
        contents.put("osgi.framework", osgiFramework);
        contents.put("osgi.bundles.defaultStartLevel", "4");
        contents.put("osgi.install.area", Platform.getInstallLocation().getURL().toExternalForm());
        contents.put(PROP_CONFIG_CASCADED, Boolean.toString(this.cascaded));
        if (this.cascaded) {
            contents.put(PROP_SHARED_CONFIG_AREA, Platform.getConfigurationLocation().getURL().toExternalForm());
        }
        contents.put(PROP_CONFIG_AREA_READ_ONLY, Boolean.toString(this.readOnly));
        for (Map.Entry<String, String> entry : this.configIniValues.entrySet()) {
            contents.put(entry.getKey(), entry.getValue());
        }
        File configINI = this.configurationPath.append("config.ini").toFile();
        try (OutputStream out = null;){
            out = new BufferedOutputStream(new FileOutputStream(configINI));
            contents.store(out, null);
        }
    }

    @Override
    protected void fillTestDescriptor(TestDescriptor test) throws SetupManager.SetupException {
        super.fillTestDescriptor(test);
        if (this.prime) {
            test.getSetup().setSystemProperty(PROP_CONFIG_AREA_READ_ONLY, Boolean.FALSE.toString());
            this.prime = false;
        }
    }

    public IPath getConfigurationPath() {
        return this.configurationPath;
    }

    private List<String> getURLs(String id) {
        ArrayList<String> result = new ArrayList<String>();
        String suffix = "";
        int atIndex = id.indexOf("@");
        if (atIndex >= 0) {
            suffix = id.substring(atIndex);
            id = id.substring(0, atIndex);
        }
        Bundle[] allVersions = Platform.getBundles((String)id, null);
        Assert.assertNotNull((String)("0.0.1." + id), (Object)allVersions);
        Bundle[] bundleArray = allVersions;
        int n = allVersions.length;
        int n2 = 0;
        while (n2 < n) {
            String externalForm;
            Bundle bundle = bundleArray[n2];
            Assert.assertNotNull((String)("0.1 " + id), (Object)bundle);
            URL url = bundle.getEntry("/");
            Assert.assertNotNull((String)("0.2 " + id), (Object)url);
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException e) {
                CoreTest.fail("0.3 " + url, e);
            }
            if (url.getProtocol().equals("jar")) {
                String path = url.getPath();
                externalForm = path.substring(0, path.length() - 2);
            } else {
                externalForm = url.toExternalForm();
            }
            externalForm = "reference:" + externalForm;
            result.add(String.valueOf(externalForm) + suffix);
            ++n2;
        }
        return result;
    }

    public boolean isCascaded() {
        return this.cascaded;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    protected Setup newSetup() throws SetupManager.SetupException {
        Setup base = super.newSetup();
        base.setEclipseArgument("configuration", null);
        base.setSystemProperty("osgi.configuration.area", this.configurationPath.toOSString());
        return base;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(TestResult result) {
        this.configurationPath.toFile().mkdirs();
        try {
            block15: {
                int i;
                Test[] allTests;
                block14: {
                    if (this.prime) {
                        try {
                            this.createConfigINI();
                        }
                        catch (IOException e) {
                            CoreTest.fail("0.1", e);
                        }
                    }
                    if (!this.shouldSort || this.isSharedSession()) {
                        super.run(result);
                        return;
                    }
                    allTests = this.getTests(true);
                    i = 0;
                    if (!true) break block14;
                    if (i >= allTests.length) return;
                    if (result.shouldStop()) break block15;
                }
                do {
                    if (this.cascaded) {
                        try {
                            this.createConfigINI();
                        }
                        catch (IOException e) {
                            CoreTest.fail("0.1", e);
                        }
                    }
                    this.runTest(allTests[i], result);
                    ++i;
                    if (i >= allTests.length) return;
                } while (!result.shouldStop());
            }
            return;
        }
        finally {
            if (this.cleanUp) {
                FileSystemHelper.clear(this.configurationPath.toFile());
            }
        }
    }

    public void setCascaded(boolean cascaded) {
        this.cascaded = cascaded;
    }

    public void setCleanup(boolean cleanUp) {
        this.cleanUp = cleanUp;
    }

    public void setConfigurationPath(IPath configurationPath) {
        this.configurationPath = configurationPath;
    }

    public void setPrime(boolean prime) {
        this.prime = prime;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public static File getConfigurationDir() {
        Location configurationLocation = Platform.getConfigurationLocation();
        URL configurationURL = configurationLocation.getURL();
        if (!"file".equals(configurationURL.getProtocol())) {
            throw new IllegalStateException();
        }
        File configurationDir = new File(configurationURL.getFile());
        return configurationDir;
    }
}

