/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.session.RemoteAssertionFailedError;
import org.eclipse.core.tests.session.RemoteTestException;
import org.eclipse.core.tests.session.Setup;

public class SessionTestRunner {
    private IStatus launch(Setup setup) {
        Assert.isNotNull((Object)setup.getEclipseArgument("application"), (String)"test application is not defined");
        Assert.isNotNull((Object)setup.getEclipseArgument("testpluginname"), (String)"test plug-in id not defined");
        Assert.isTrue((boolean)(setup.getEclipseArgument("classname") != null ^ setup.getEclipseArgument("test") != null), (String)"either a test suite or a test case must be provided");
        setup.setEclipseArgument("version", "3");
        IStatus outcome = Status.OK_STATUS;
        try {
            int returnCode = setup.run();
            if (returnCode == 23) {
                returnCode = setup.run();
            }
            if (returnCode != 0) {
                outcome = new Status(2, "org.eclipse.core.runtime", returnCode, "Process returned non-zero code: " + returnCode + "\n\tCommand: " + setup, null);
            }
        }
        catch (Exception e) {
            outcome = new Status(4, "org.eclipse.core.runtime", -1, "Error running process\n\tCommand: " + setup, (Throwable)e);
        }
        return outcome;
    }

    public final void run(Test test, TestResult result, Setup setup, boolean crashTest) {
        ResultCollector collector = null;
        try {
            collector = new ResultCollector(test, result);
        }
        catch (IOException e) {
            result.addError(test, (Throwable)e);
            return;
        }
        setup.setEclipseArgument("port", Integer.toString(collector.getPort()));
        new Thread((Runnable)collector, "Test result collector").start();
        IStatus status = this.launch(setup);
        collector.shutdown();
        if (!status.isOK()) {
            CoreTest.log("org.eclipse.core.tests.harness", status);
            if (status.getSeverity() == 4) {
                result.addError(test, (Throwable)new CoreException(status));
                return;
            }
        }
        if (collector.getTestsRun() == 0) {
            if (crashTest) {
                result.endTest(test);
            } else {
                result.addError(test, (Throwable)new Exception("Test did not run: " + test.toString()));
            }
        } else if (crashTest) {
            result.addError(test, (Throwable)new Exception("Should have caused crash"));
        }
    }

    class Result {
        static final int ERROR = 2;
        static final int FAILURE = 1;
        static final int SUCCESS = 0;
        String message;
        String stackTrace;
        Test test;
        int type;

        public Result(Test test) {
            this.test = test;
        }
    }

    class ResultCollector
    implements Runnable {
        private boolean finished;
        private Result newResult;
        private Map<String, Result> results = new HashMap<String, Result>();
        ServerSocket serverSocket = new ServerSocket(0);
        private boolean shouldRun = true;
        private StringBuilder stack;
        private TestResult testResult;
        private int testsRun;

        ResultCollector(Test test, TestResult testResult) throws IOException {
            this.testResult = testResult;
            this.initResults(test);
        }

        public int getPort() {
            return this.serverSocket.getLocalPort();
        }

        public int getTestsRun() {
            return this.testsRun;
        }

        private void initResults(Test test) {
            if (test instanceof TestSuite) {
                Enumeration e = ((TestSuite)test).tests();
                while (e.hasMoreElements()) {
                    this.initResults((Test)e.nextElement());
                }
                return;
            }
            this.results.put(test.toString(), new Result(test));
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        private synchronized void markAsFinished() {
            this.finished = true;
            this.notifyAll();
        }

        private String parseTestId(String message) {
            if (message.length() == 0 || message.charAt(0) != '%') {
                return null;
            }
            int firstComma = message.indexOf(44);
            if (firstComma == -1) {
                return null;
            }
            int secondComma = message.indexOf(44, firstComma + 1);
            if (secondComma == -1) {
                secondComma = message.length();
            }
            return message.substring(firstComma + 1, secondComma);
        }

        private void processAvailableMessages(BufferedReader messageReader) throws IOException {
            while (messageReader.ready()) {
                String message = messageReader.readLine();
                this.processMessage(message);
            }
        }

        private void processMessage(String message) {
            if (message.startsWith("%TESTS")) {
                String testId = this.parseTestId(message);
                if (!this.results.containsKey(testId)) {
                    throw new IllegalStateException("Unknown test id: " + testId);
                }
                this.newResult = this.results.get(testId);
                this.testResult.startTest(this.newResult.test);
                return;
            }
            if (message.startsWith("%TESTE")) {
                if (this.newResult.type == 1) {
                    this.testResult.addFailure(this.newResult.test, (AssertionFailedError)new RemoteAssertionFailedError(this.newResult.message, this.newResult.stackTrace));
                } else if (this.newResult.type == 2) {
                    this.testResult.addError(this.newResult.test, (Throwable)new RemoteTestException(this.newResult.message, this.newResult.stackTrace));
                }
                this.testResult.endTest(this.newResult.test);
                ++this.testsRun;
                this.newResult = null;
                return;
            }
            if (message.startsWith("%ERROR")) {
                this.newResult.type = 2;
                this.newResult.message = "";
                return;
            }
            if (message.startsWith("%FAILED")) {
                this.newResult.type = 1;
                this.newResult.message = "";
                return;
            }
            if (message.startsWith("%TRACES")) {
                this.stack = new StringBuilder();
                return;
            }
            if (message.startsWith("%TRACEE")) {
                this.newResult.stackTrace = this.stack.toString();
                this.stack = null;
                return;
            }
            if (message.startsWith("%")) {
                return;
            }
            if (this.stack != null) {
                this.stack.append(message);
                this.stack.append(System.getProperty("line.separator"));
                return;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 22[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private synchronized boolean shouldRun() {
            return this.shouldRun;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void shutdown() {
            ResultCollector resultCollector = this;
            synchronized (resultCollector) {
                if (this.isFinished()) {
                    return;
                }
                this.shouldRun = false;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    CoreTest.log("org.eclipse.core.tests.harness", e);
                }
                this.notifyAll();
            }
            resultCollector = this;
            synchronized (resultCollector) {
                while (true) {
                    if (this.isFinished()) {
                        return;
                    }
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

