/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class FileStoreTest
extends LocalStoreTest {
    public static Test suite() {
        return new TestSuite(FileStoreTest.class);
    }

    public FileStoreTest() {
    }

    public FileStoreTest(String name) {
        super(name);
    }

    private IFileStore createDir(IFileStore store, boolean clear) throws CoreException {
        if (clear && store.fetchInfo().exists()) {
            store.delete(0, null);
        }
        store.mkdir(0, null);
        IFileInfo info = store.fetchInfo();
        FileStoreTest.assertTrue((String)"createDir.1", (boolean)info.exists());
        FileStoreTest.assertTrue((String)"createDir.1", (boolean)info.isDirectory());
        return store;
    }

    private IFileStore createDir(String string, boolean clear) throws CoreException {
        return this.createDir(EFS.getFileSystem((String)"file").getStore((IPath)new Path(string)), clear);
    }

    public void testBrokenFetchInfo() {
        IFileStore broken = null;
        try {
            broken = EFS.getStore((URI)new URI("broken://a/b/c"));
        }
        catch (CoreException e) {
            FileStoreTest.fail((String)"0.98", (Throwable)e);
        }
        catch (URISyntaxException e) {
            FileStoreTest.fail((String)"0.99", (Throwable)e);
        }
        IFileInfo info = broken.fetchInfo();
        FileStoreTest.assertTrue((String)"1.0", (!info.exists() ? 1 : 0) != 0);
        try {
            info = broken.fetchInfo(0, this.getMonitor());
            FileStoreTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
    }

    private IFileStore getDirFileStore(String path) throws CoreException {
        IFileStore store = EFS.getFileSystem((String)"file").getStore((IPath)new Path(path));
        store.mkdir(0, null);
        return store;
    }

    private IFileStore[] getFileStoresOnTwoVolumes() {
        IFileStore[] tempDirs = new IFileStore[2];
        int i = 99;
        while (i < 123) {
            block4: {
                char c = (char)i;
                try {
                    IFileStore store = this.getDirFileStore(String.valueOf(c) + ":/temp");
                    IFileInfo info = store.fetchInfo();
                    if (!info.exists() || !info.isDirectory() || info.getAttribute(2)) break block4;
                    if (tempDirs[0] == null) {
                        tempDirs[0] = store;
                        break block4;
                    }
                    tempDirs[1] = store;
                    break;
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return tempDirs;
    }

    public void testCopyAcrossVolumes() throws Throwable {
        IFileStore[] tempDirectories = this.getFileStoresOnTwoVolumes();
        if (tempDirectories == null || tempDirectories.length < 2 || tempDirectories[0] == null || tempDirectories[1] == null) {
            return;
        }
        IFileStore tempSrc = tempDirectories[0];
        IFileStore tempDest = tempDirectories[1];
        IFileStore target = tempSrc.getChild("target");
        this.createDir(target, true);
        this.createTree(this.getTree(target));
        IFileStore destination = tempDest.getChild("target");
        target.copy(destination, 0, null);
        FileStoreTest.assertTrue((String)"3.1", (boolean)this.verifyTree(this.getTree(destination)));
        destination.delete(0, null);
        destination = tempDest.getChild("copy of target");
        target.copy(destination, 0, null);
        FileStoreTest.assertTrue((String)"4.1", (boolean)this.verifyTree(this.getTree(destination)));
        destination.delete(0, null);
        destination = tempDest.getChild("target");
        String anotherContent = "nothing..................gnihton";
        this.createFile(destination, anotherContent);
        FileStoreTest.assertTrue((String)"5.1", (!destination.fetchInfo().isDirectory() ? 1 : 0) != 0);
        try {
            target.copy(destination, 0, null);
            FileStoreTest.fail((String)"5.2");
        }
        catch (CoreException coreException) {}
        FileStoreTest.assertTrue((String)"5.3", (!this.verifyTree(this.getTree(destination)) ? 1 : 0) != 0);
        destination.delete(0, null);
        destination = tempDest.getChild("target");
        this.createDir(destination, true);
        target.copy(destination, 0, null);
        FileStoreTest.assertTrue((String)"6.2", (boolean)this.verifyTree(this.getTree(destination)));
        destination.delete(0, null);
        target.delete(0, null);
    }

    public void testCopyDirectory() throws Throwable {
        IFileStore temp = EFS.getFileSystem((String)"file").getStore(FileStoreTest.getWorkspace().getRoot().getLocation().append("temp"));
        temp.mkdir(0, null);
        FileStoreTest.assertTrue((String)"1.1", (boolean)temp.fetchInfo().isDirectory());
        IFileStore target = temp.getChild("target");
        target.delete(0, null);
        this.createTree(this.getTree(target));
        IFileStore copyOfTarget = temp.getChild("copy of target");
        target.copy(copyOfTarget, 0, null);
        FileStoreTest.assertTrue((String)"2.1", (boolean)this.verifyTree(this.getTree(copyOfTarget)));
        target.delete(0, null);
        copyOfTarget.delete(0, null);
    }

    public void testCopyDirectoryParentMissing() throws Throwable {
        IFileStore parent = this.getTempStore();
        IFileStore child = parent.getChild("child");
        IFileStore existing = this.getTempStore();
        this.createFile(existing, this.getRandomString());
        try {
            existing.copy(child, 0, this.getMonitor());
            FileStoreTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        FileStoreTest.assertTrue((String)"1.1", (!child.fetchInfo().exists() ? 1 : 0) != 0);
    }

    public void testCopyFile() throws Throwable {
        IFileStore temp = this.createDir(FileStoreTest.getWorkspace().getRoot().getLocation().append("temp").toString(), true);
        String content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore target = temp.getChild("target");
        target.delete(0, null);
        this.createFile(target, content);
        FileStoreTest.assertTrue((String)"1.3", (boolean)target.fetchInfo().exists());
        FileStoreTest.assertTrue((String)"1.4", (boolean)this.compareContent(this.getContents(content), target.openInputStream(0, null)));
        IFileStore copyOfTarget = temp.getChild("copy of target");
        target.copy(copyOfTarget, 2, null);
        FileStoreTest.assertTrue((String)"2.1", (boolean)this.compareContent(this.getContents(content), copyOfTarget.openInputStream(0, null)));
        copyOfTarget.delete(0, null);
        if (this.isReadOnlySupported()) {
            copyOfTarget = temp.getChild("copy of target");
            this.setReadOnly(target, true);
            target.copy(copyOfTarget, 2, null);
            FileStoreTest.assertTrue((String)"3.1", (boolean)this.compareContent(this.getContents(content), copyOfTarget.openInputStream(0, null)));
            this.setReadOnly(copyOfTarget, false);
            copyOfTarget.delete(0, null);
            this.setReadOnly(target, false);
            target.delete(0, null);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 1000) {
            sb.append("asdjhasldhaslkfjhasldkfjhasdlkfjhasdlfkjhasdflkjhsdaf");
            ++i;
        }
        IFileStore bigFile = temp.getChild("bigFile");
        this.createFile(bigFile, sb.toString());
        FileStoreTest.assertTrue((String)"7.1", (boolean)bigFile.fetchInfo().exists());
        FileStoreTest.assertTrue((String)"7.2", (boolean)this.compareContent(this.getContents(sb.toString()), bigFile.openInputStream(0, null)));
        IFileStore destination = temp.getChild("copy of bigFile");
        IProgressMonitor monitor = this.getMonitor();
        bigFile.copy(destination, 0, monitor);
        FileStoreTest.assertTrue((String)"7.3", (boolean)this.compareContent(this.getContents(sb.toString()), destination.openInputStream(0, null)));
        destination.delete(0, null);
        temp.delete(0, null);
    }

    public void testCopyFileAcrossVolumes() throws Throwable {
        IFileStore[] tempDirectories = this.getFileStoresOnTwoVolumes();
        if (tempDirectories == null || tempDirectories.length < 2 || tempDirectories[0] == null || tempDirectories[1] == null) {
            return;
        }
        IFileStore tempSrc = tempDirectories[0];
        IFileStore tempDest = tempDirectories[1];
        String content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore target = tempSrc.getChild("target");
        target.delete(0, null);
        this.createFile(target, content);
        FileStoreTest.assertTrue((String)"1.3", (boolean)target.fetchInfo().exists());
        FileStoreTest.assertTrue((String)"1.4", (boolean)this.compareContent(this.getContents(content), target.openInputStream(0, null)));
        IFileStore destination = tempDest.getChild("target");
        target.copy(destination, 2, null);
        FileStoreTest.assertTrue((String)"3.1", (boolean)this.compareContent(this.getContents(content), destination.openInputStream(0, null)));
        destination.delete(0, null);
        destination = tempDest.getChild("copy of target");
        target.copy(destination, 2, null);
        FileStoreTest.assertTrue((String)"4.1", (boolean)this.compareContent(this.getContents(content), destination.openInputStream(0, null)));
        destination.delete(0, null);
        destination = tempDest.getChild("target");
        String anotherContent = "nothing..................gnihton";
        this.createFile(destination, anotherContent);
        FileStoreTest.assertTrue((String)"5.1", (!destination.fetchInfo().isDirectory() ? 1 : 0) != 0);
        target.copy(destination, 2, null);
        FileStoreTest.assertTrue((String)"5.2", (boolean)this.compareContent(this.getContents(content), destination.openInputStream(0, null)));
        destination.delete(0, null);
        destination = tempDest.getChild("target");
        this.createDir(destination, true);
        FileStoreTest.assertTrue((String)"6.1", (boolean)destination.fetchInfo().isDirectory());
        boolean ok = false;
        try {
            target.copy(destination, 0, null);
        }
        catch (CoreException coreException) {
            target.delete(0, null);
            this.createFile(target, content);
            ok = true;
        }
        FileStoreTest.assertTrue((String)"6.2", (boolean)ok);
        FileStoreTest.assertTrue((String)"6.3", (boolean)destination.fetchInfo().isDirectory());
        destination.delete(0, null);
        target.delete(0, null);
    }

    public void testGetLength() throws Exception {
        IPath root = FileStoreTest.getWorkspace().getRoot().getLocation().append("" + new Date().getTime());
        IFileStore temp = this.createDir(root.toString(), true);
        try {
            IFileStore target = temp.getChild("target");
            FileStoreTest.assertEquals((String)"1.0", (long)0L, (long)target.fetchInfo().getLength());
            target.openOutputStream(0, null).close();
            FileStoreTest.assertEquals((String)"1.0", (long)0L, (long)target.fetchInfo().getLength());
            OutputStream out = target.openOutputStream(0, null);
            out.write(5);
            out.close();
            FileStoreTest.assertEquals((String)"1.0", (long)1L, (long)target.fetchInfo().getLength());
        }
        finally {
            temp.delete(0, null);
        }
    }

    public void testGetStat() throws CoreException {
        IPath root = FileStoreTest.getWorkspace().getRoot().getLocation().append("" + new Date().getTime());
        IFileStore temp = this.createDir(root.toString(), true);
        IFileStore target = temp.getChild("target");
        long stat = target.fetchInfo().getLastModified();
        FileStoreTest.assertEquals((String)"1.0", (long)0L, (long)stat);
        this.createDir(target, true);
        stat = target.fetchInfo().getLastModified();
        FileStoreTest.assertTrue((String)"2.0", (0L != stat ? 1 : 0) != 0);
        temp.delete(0, null);
    }

    public void testMove() throws Throwable {
        IFileStore tempC = this.createDir(FileStoreTest.getWorkspace().getRoot().getLocation().append("temp").toString(), true);
        IFileStore target = tempC.getChild("target");
        String content = "just a content.....tnetnoc a tsuj";
        this.createFile(target, content);
        FileStoreTest.assertTrue((String)"1.3", (boolean)target.fetchInfo().exists());
        IFileStore tree = tempC.getChild("tree");
        this.createDir(tree, true);
        this.createTree(this.getTree(tree));
        IFileStore destination = tempC.getChild("destination");
        target.move(destination, 0, null);
        FileStoreTest.assertTrue((String)"2.1", (!destination.fetchInfo().isDirectory() ? 1 : 0) != 0);
        FileStoreTest.assertTrue((String)"2.2", (!target.fetchInfo().exists() ? 1 : 0) != 0);
        destination.move(target, 0, null);
        FileStoreTest.assertTrue((String)"2.3", (!target.fetchInfo().isDirectory() ? 1 : 0) != 0);
        FileStoreTest.assertTrue((String)"2.4", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        String anotherContent = "another content";
        this.createFile(destination, anotherContent);
        boolean ok = false;
        try {
            target.move(destination, 0, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        FileStoreTest.assertTrue((String)"3.1", (boolean)ok);
        FileStoreTest.assertTrue((String)"3.2", (!target.fetchInfo().isDirectory() ? 1 : 0) != 0);
        destination.delete(0, null);
        FileStoreTest.assertTrue((String)"3.3", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        this.createDir(destination, true);
        try {
            target.move(destination, 0, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        FileStoreTest.assertTrue((String)"4.1", (boolean)ok);
        FileStoreTest.assertTrue((String)"4.2", (!target.fetchInfo().isDirectory() ? 1 : 0) != 0);
        destination.delete(0, null);
        FileStoreTest.assertTrue((String)"4.3", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        destination = tempC.getChild("destination");
        tree.move(destination, 0, null);
        FileStoreTest.assertTrue((String)"6.1", (boolean)this.verifyTree(this.getTree(destination)));
        FileStoreTest.assertTrue((String)"6.2", (!tree.fetchInfo().exists() ? 1 : 0) != 0);
        destination.move(tree, 0, null);
        FileStoreTest.assertTrue((String)"6.3", (boolean)this.verifyTree(this.getTree(tree)));
        FileStoreTest.assertTrue((String)"6.4", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        target.delete(0, null);
        tree.delete(0, null);
    }

    public void testMoveAcrossVolumes() throws Throwable {
        IFileStore[] tempDirectories = this.getFileStoresOnTwoVolumes();
        if (tempDirectories == null || tempDirectories.length < 2 || tempDirectories[0] == null || tempDirectories[1] == null) {
            return;
        }
        IFileStore tempSrc = tempDirectories[0];
        IFileStore tempDest = tempDirectories[1];
        IFileStore target = tempSrc.getChild("target");
        String content = "just a content.....tnetnoc a tsuj";
        this.createFile(target, content);
        FileStoreTest.assertTrue((String)"1.3", (boolean)target.fetchInfo().exists());
        IFileStore tree = tempSrc.getChild("tree");
        this.createDir(tree, true);
        this.createTree(this.getTree(tree));
        IFileStore destination = tempDest.getChild("target");
        target.move(destination, 0, null);
        FileStoreTest.assertTrue((String)"5.1", (!destination.fetchInfo().isDirectory() ? 1 : 0) != 0);
        FileStoreTest.assertTrue((String)"5.2", (!target.fetchInfo().exists() ? 1 : 0) != 0);
        destination.move(target, 0, null);
        FileStoreTest.assertTrue((String)"5.3", (!target.fetchInfo().isDirectory() ? 1 : 0) != 0);
        FileStoreTest.assertTrue((String)"5.4", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        destination = tempDest.getChild("target");
        tree.move(destination, 0, null);
        FileStoreTest.assertTrue((String)"9.1", (boolean)this.verifyTree(this.getTree(destination)));
        FileStoreTest.assertTrue((String)"9.2", (!tree.fetchInfo().exists() ? 1 : 0) != 0);
        destination.move(tree, 0, null);
        FileStoreTest.assertTrue((String)"9.3", (boolean)this.verifyTree(this.getTree(tree)));
        FileStoreTest.assertTrue((String)"9.4", (!destination.fetchInfo().exists() ? 1 : 0) != 0);
        target.delete(0, null);
        tree.delete(0, null);
    }

    public void testMoveDirectoryParentMissing() throws Throwable {
        IFileStore parent = this.getTempStore();
        IFileStore child = parent.getChild("child");
        IFileStore existing = this.getTempStore();
        this.createFile(existing, this.getRandomString());
        try {
            existing.move(child, 0, this.getMonitor());
            FileStoreTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        FileStoreTest.assertTrue((String)"1.1", (!child.fetchInfo().exists() ? 1 : 0) != 0);
    }

    public void testPutInfo() {
        IFileStore nonExisting = this.getTempStore();
        IFileInfo info = nonExisting.fetchInfo();
        info.setLastModified(System.currentTimeMillis());
        try {
            nonExisting.putInfo(info, 2048, this.getMonitor());
            FileStoreTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        info = nonExisting.fetchInfo();
        info.setAttribute(2, false);
        try {
            nonExisting.putInfo(info, 1024, this.getMonitor());
            FileStoreTest.fail((String)"1.1");
        }
        catch (CoreException coreException) {}
    }

    public void testReadOnly() throws CoreException {
        this.testAttribute(2);
    }

    public void testPermissionsEnabled() {
        String os = Platform.getOS();
        if ("linux".equals(os) || "macosx".equals(os)) {
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x400000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x800000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x1000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x2000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x4000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x8000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x10000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x20000000));
            FileStoreTest.assertTrue((boolean)this.isAttributeSupported(0x40000000));
        } else {
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x400000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x800000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x1000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x2000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x4000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x8000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x10000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x20000000));
            FileStoreTest.assertFalse((boolean)this.isAttributeSupported(0x40000000));
        }
    }

    public void testPermissions() throws CoreException {
        this.testAttribute(0x400000);
        this.testAttribute(0x800000);
        this.testAttribute(0x1000000);
        this.testAttribute(0x2000000);
        this.testAttribute(0x4000000);
        this.testAttribute(0x8000000);
        this.testAttribute(0x10000000);
        this.testAttribute(0x20000000);
        this.testAttribute(0x40000000);
    }

    private void testAttribute(int attribute) throws CoreException {
        if (!this.isAttributeSupported(attribute)) {
            return;
        }
        IPath root = FileStoreTest.getWorkspace().getRoot().getLocation().append("" + new Date().getTime());
        IFileStore targetFolder = this.createDir(root.toString(), true);
        try {
            IFileStore targetFile = targetFolder.getChild("targetFile");
            this.createFileInFileSystem(targetFile);
            boolean init = targetFile.fetchInfo().getAttribute(attribute);
            this.setAttribute(targetFile, attribute, !init);
            FileStoreTest.assertTrue((String)"1.2", (boolean)(targetFile.fetchInfo().getAttribute(attribute) ^ init));
            this.setAttribute(targetFile, attribute, init);
            FileStoreTest.assertTrue((String)"1.4", (targetFile.fetchInfo().getAttribute(attribute) == init ? 1 : 0) != 0);
            init = targetFolder.fetchInfo().getAttribute(attribute);
            this.setAttribute(targetFolder, attribute, !init);
            FileStoreTest.assertTrue((String)"2.2", (boolean)(targetFolder.fetchInfo().getAttribute(attribute) ^ init));
            this.setAttribute(targetFolder, attribute, init);
            FileStoreTest.assertTrue((String)"2.4", (targetFolder.fetchInfo().getAttribute(attribute) == init ? 1 : 0) != 0);
        }
        finally {
            targetFolder.delete(0, null);
        }
    }

    public void testGetFileStore() throws Exception {
        File file = this.getTempDir().append("test.txt").toFile();
        file.createNewFile();
        FileStoreTest.assertTrue((String)"1.0", (boolean)file.exists());
        IFileStore tempStore = this.createDir(this.getTempDir().append("temp").toString(), true);
        this.createDir(this.getTempDir().append("temp/temp2").toString(), true);
        file = this.getTempDir().append("temp/temp2/test.txt").toFile();
        file.createNewFile();
        FileStoreTest.assertTrue((String)"2.0", (boolean)file.exists());
        Path relativePath = new Path("../test.txt");
        IFileStore relativeStore = tempStore.getFileStore((IPath)relativePath);
        FileStoreTest.assertNotNull((String)"3.0", (Object)relativeStore);
        IFileInfo info = relativeStore.fetchInfo();
        FileStoreTest.assertNotNull((String)"4.0", (Object)info);
        FileStoreTest.assertTrue((String)"5.0", (boolean)info.exists());
        relativePath = new Path(".././test.txt");
        relativeStore = tempStore.getFileStore((IPath)relativePath);
        FileStoreTest.assertNotNull((String)"6.0", (Object)relativeStore);
        info = relativeStore.fetchInfo();
        FileStoreTest.assertNotNull((String)"7.0", (Object)info);
        FileStoreTest.assertTrue((String)"8.0", (boolean)info.exists());
        relativePath = new Path("temp2/test.txt");
        relativeStore = tempStore.getFileStore((IPath)relativePath);
        FileStoreTest.assertNotNull((String)"9.0", (Object)relativeStore);
        info = relativeStore.fetchInfo();
        FileStoreTest.assertNotNull((String)"10.0", (Object)info);
        FileStoreTest.assertTrue((String)"11.0", (boolean)info.exists());
    }
}

