/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;

public abstract class FileSystemTest
extends CoreTest {
    protected IFileStore baseStore;
    protected IFileStore localFileBaseStore;

    public FileSystemTest() {
    }

    public FileSystemTest(String name) {
        super(name);
    }

    protected void ensureDoesNotExist(IFileStore store) {
        try {
            store.delete(0, this.getMonitor());
            FileSystemTest.assertTrue((String)"1.0", (!store.fetchInfo().exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            FileSystemTest.fail((String)"ensureDoesNotExist", (Throwable)e);
        }
    }

    protected void assertExists(String message, IFileStore store) {
        IFileInfo info = store.fetchInfo();
        FileSystemTest.assertTrue((String)message, (boolean)info.exists());
        try {
            IFileInfo[] children;
            IFileInfo[] iFileInfoArray = children = store.getParent().childInfos(0, this.getMonitor());
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo element = iFileInfoArray[n2];
                if (element.getName().equals(store.getName())) {
                    return;
                }
                ++n2;
            }
            FileSystemTest.assertTrue((String)message, (boolean)false);
        }
        catch (CoreException e) {
            FileSystemTest.fail((String)message, (Throwable)e);
        }
    }

    protected void ensureExists(IFileStore store, boolean directory) {
        try {
            if (directory) {
                store.mkdir(0, this.getMonitor());
                IFileInfo info = store.fetchInfo();
                FileSystemTest.assertTrue((String)"1.0", (boolean)info.exists());
                FileSystemTest.assertTrue((String)"1.1", (boolean)info.isDirectory());
            } else {
                OutputStream out = store.openOutputStream(0, this.getMonitor());
                out.write(5);
                out.close();
                IFileInfo info = store.fetchInfo();
                FileSystemTest.assertTrue((String)"1.5", (boolean)info.exists());
                FileSystemTest.assertTrue((String)"1.6", (!info.isDirectory() ? 1 : 0) != 0);
            }
        }
        catch (CoreException e) {
            FileSystemTest.fail((String)"ensureExists", (Throwable)e);
        }
        catch (IOException e) {
            FileSystemTest.fail((String)"ensureExists", (Throwable)e);
        }
    }

    protected boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.doFSSetUp();
        this.localFileBaseStore = EFS.getLocalFileSystem().getStore(FileSystemHelper.getRandomLocation((IPath)this.getTempDir()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.localFileBaseStore.delete(0, null);
        this.doFSTearDown();
    }

    protected void doFSSetUp() throws Exception {
        MemoryTree.TREE.deleteAll();
        this.baseStore = EFS.getStore((URI)URI.create("mem:/baseStore"));
        this.baseStore.mkdir(0, null);
    }

    protected void doFSTearDown() throws Exception {
        this.baseStore.delete(0, null);
        MemoryTree.TREE.deleteAll();
    }
}

