/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.filesystem.FileSystemTest;

public class OpenOutputStreamTest
extends FileSystemTest {
    public OpenOutputStreamTest() {
    }

    public OpenOutputStreamTest(String name) {
        super(name);
    }

    public void testAppend() {
        IFileStore file = this.baseStore.getChild("file");
        this.ensureDoesNotExist(file);
        OutputStream out = null;
        try {
            out = file.openOutputStream(1, this.getMonitor());
            out.write(1);
            out.close();
        }
        catch (CoreException e) {
            OpenOutputStreamTest.fail((String)"1.99", (Throwable)e);
        }
        catch (IOException e) {
            OpenOutputStreamTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            out = file.openOutputStream(1, this.getMonitor());
            out.write(2);
            out.close();
        }
        catch (CoreException e) {
            OpenOutputStreamTest.fail((String)"3.99", (Throwable)e);
        }
        catch (IOException e) {
            OpenOutputStreamTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            InputStream in = file.openInputStream(0, this.getMonitor());
            OpenOutputStreamTest.assertEquals((String)"1.0", (int)1, (int)in.read());
            OpenOutputStreamTest.assertEquals((String)"1.1", (int)2, (int)in.read());
            OpenOutputStreamTest.assertEquals((String)"1.2", (int)-1, (int)in.read());
            in.close();
        }
        catch (CoreException e) {
            OpenOutputStreamTest.fail((String)"4.99", (Throwable)e);
        }
        catch (IOException e) {
            OpenOutputStreamTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testParentExists() {
        IFileStore file = this.baseStore.getChild("file");
        this.ensureDoesNotExist(file);
        OutputStream out = null;
        try {
            out = file.openOutputStream(0, this.getMonitor());
            out.write(1);
            out.close();
        }
        catch (CoreException e) {
            OpenOutputStreamTest.fail((String)"1.99", (Throwable)e);
        }
        catch (IOException e) {
            OpenOutputStreamTest.fail((String)"2.99", (Throwable)e);
        }
        IFileInfo info = file.fetchInfo();
        this.assertExists("1.0", file);
        OpenOutputStreamTest.assertTrue((String)"1.1", (!info.isDirectory() ? 1 : 0) != 0);
        OpenOutputStreamTest.assertEquals((String)"1.2", (String)file.getName(), (String)info.getName());
    }

    public void testParentNotExists() {
        IFileStore dir = this.baseStore.getChild("dir");
        IFileStore file = dir.getChild("file");
        this.ensureDoesNotExist(dir);
        try {
            file.openOutputStream(0, this.getMonitor());
            OpenOutputStreamTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        IFileInfo info = file.fetchInfo();
        OpenOutputStreamTest.assertTrue((String)"1.1", (!info.exists() ? 1 : 0) != 0);
        OpenOutputStreamTest.assertTrue((String)"1.2", (!info.isDirectory() ? 1 : 0) != 0);
    }
}

