/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.alias;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTest;

public class SyncAliasTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(SyncAliasTest.class);
    }

    public SyncAliasTest() {
    }

    public SyncAliasTest(String name) {
        super(name);
    }

    public void testNestedProjects() throws CoreException {
        IWorkspaceRoot root = SyncAliasTest.getWorkspace().getRoot();
        File fsRoot = root.getLocation().toFile();
        File fsParent = new File(fsRoot, "parent");
        fsParent.mkdirs();
        File childProject = new File(fsParent, "nestedProject");
        childProject.mkdirs();
        IProject nestedProject = root.getProject("nestedProject");
        IFolder nestedTarget = nestedProject.getFolder("target");
        SyncAliasTest.getWorkspace().run(monitor -> {
            IProject parent = root.getProject("parent");
            parent.create(monitor);
            parent.open(monitor);
            parent.refreshLocal(2, monitor);
            IProjectDescription description = SyncAliasTest.getWorkspace().newProjectDescription("nestedProject");
            description.setLocation((IPath)new Path(childProject.getAbsolutePath()));
            nestedProject.create(description, monitor);
            nestedProject.open(monitor);
            nestedTarget.create(false, true, monitor);
        }, (IProgressMonitor)new NullProgressMonitor());
        SyncAliasTest.getWorkspace().run(monitor -> {
            File file2 = new File(childProject, "target/classes/META-INF/ejb.xml");
            file2.getParentFile().mkdirs();
            try {
                FileOutputStream fos = new FileOutputStream(file2);
                fos.close();
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.tests.resources", "Test failed due to unexpected IOException"));
            }
            nestedTarget.refreshLocal(2, monitor);
        }, (IProgressMonitor)new NullProgressMonitor());
    }
}

