/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.harness.TestBarrier;
import org.eclipse.core.tests.harness.TestJob;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.internal.builders.TestBuilder;

public class BuilderTest
extends AbstractBuilderTest {
    public static Test suite() {
        return new TestSuite(BuilderTest.class);
    }

    public BuilderTest() {
        super(null);
    }

    public BuilderTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        BuilderTest.getWorkspace().getRoot().delete(true, null);
        TestBuilder builder = SortBuilder.getInstance();
        if (builder != null) {
            builder.reset();
        }
        if ((builder = DeltaVerifierBuilder.getInstance()) != null) {
            builder.reset();
        }
    }

    public void testAardvarkBuildOrder() {
        IWorkspace workspace = BuilderTest.getWorkspace();
        this.assertEquals("1.0", null, workspace.getDescription().getBuildOrder());
    }

    public void testAutoBuildPR() {
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("PROJECT1");
        IFolder folder = project1.getFolder("FOLDER");
        IFolder sub = folder.getFolder("sub");
        IFile fileA = folder.getFile("A");
        IFile fileB = sub.getFile("B");
        try {
            this.setAutoBuilding(true);
            project1.create(this.getMonitor());
            project1.open(this.getMonitor());
            IProjectDescription desc = project1.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            command.getArguments().put("BuildID", "Project1Build1");
            desc.setBuildSpec(new ICommand[]{command});
            project1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            folder.create(true, true, this.getMonitor());
            fileA.create(this.getRandomContents(), true, this.getMonitor());
            sub.create(true, true, this.getMonitor());
            fileB.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testBrokenBuilder() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command1 = desc.newCommand();
            command1.setBuilderName("org.eclipse.core.tests.resources.brokenbuilder");
            ICommand command2 = desc.newCommand();
            command2.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command1, command2});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            BuilderTest.getWorkspace().build(10, this.getMonitor());
            BuilderTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents("3.1");
        try {
            BuilderTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.0", (Throwable)e);
        }
    }

    public void testBuildClean() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2")});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            BuilderTest.getWorkspace().build(15, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.1", (Throwable)e);
        }
        DeltaVerifierBuilder verifier = DeltaVerifierBuilder.getInstance();
        BuilderTest.assertTrue((String)"3.2", (boolean)verifier.wasCleanBuild());
        try {
            BuilderTest.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.3", (Throwable)e);
        }
        BuilderTest.assertTrue((String)"3.4", (boolean)verifier.wasFullBuild());
        try {
            project.touch(this.getMonitor());
            BuilderTest.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.5", (Throwable)e);
        }
        BuilderTest.assertTrue((String)"3.6", (boolean)verifier.wasIncrementalBuild());
        try {
            BuilderTest.getWorkspace().build(15, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.7", (Throwable)e);
        }
        BuilderTest.assertTrue((String)"3.8", (boolean)verifier.wasCleanBuild());
        try {
            BuilderTest.getWorkspace().build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.9", (Throwable)e);
        }
        BuilderTest.assertTrue((String)"3.10", (boolean)verifier.wasFullBuild());
    }

    public void testBuildCommands() {
        IProjectDescription desc;
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("PROJECT1");
        IProject project2 = workspace.getRoot().getProject("PROJECT2");
        IFile file1 = project1.getFile("FILE1");
        IFile file2 = project2.getFile("FILE2");
        try {
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setBuildOrder(new String[]{project1.getName(), project2.getName()});
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"0.0", (Throwable)e);
        }
        TestBuilder verifier = null;
        try {
            this.setAutoBuilding(false);
            project1.create(this.getMonitor());
            project1.open(this.getMonitor());
            project2.create(this.getMonitor());
            project2.open(this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            desc = project1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Project1Build1")});
            project1.setDescription(desc, this.getMonitor());
            project1.build(6, this.getMonitor());
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Project1Build1");
            verifier.assertLifecycleEvents("1.0");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            desc = project1.getDescription();
            desc.setBuildSpec(new ICommand[0]);
            project1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            verifier.reset();
            this.dirty(file1);
            project1.build(6, this.getMonitor());
            verifier.assertLifecycleEvents("3.1");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.99", (Throwable)e);
        }
        try {
            desc = project1.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            this.dirty(file1);
            project1.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("5.2");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"5.99", (Throwable)e);
        }
        try {
            desc = project1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Project1Build1")});
            project1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"6.99", (Throwable)e);
        }
        try {
            desc = project2.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project2Build1"), this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2")});
            project2.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"7.99", (Throwable)e);
        }
        try {
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Project1Build1");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Project2Build1");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Project2Build2");
            this.dirty(file1);
            this.dirty(file2);
            workspace.build(6, this.getMonitor());
            verifier.assertLifecycleEvents("8.0");
            verifier.addExpectedLifecycleEvent("Project1Build1");
            this.dirty(file1);
            project1.build(10, this.getMonitor());
            verifier.assertLifecycleEvents("8.2");
            this.dirty(file2);
            project2.build(10, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Project2Build1");
            verifier.addExpectedLifecycleEvent("Project2Build2");
            verifier.assertLifecycleEvents("8.3");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"8.99", (Throwable)e);
        }
        try {
            desc = project2.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.deltaverifierbuilder", "Project2Build2"), this.createCommand(desc, "org.eclipse.core.tests.resources.sortbuilder", "Project2Build1")});
            project2.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"10.99", (Throwable)e);
        }
        try {
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Project1Build1");
            verifier.addExpectedLifecycleEvent("Project2Build2");
            verifier.addExpectedLifecycleEvent("Project2Build1");
            verifier.assertLifecycleEvents("11.0");
            this.dirty(file1);
            this.dirty(file2);
            project1.build(10, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Project1Build1");
            verifier.assertLifecycleEvents("11.2");
            this.dirty(file1);
            this.dirty(file2);
            project2.build(10, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Project2Build2");
            verifier.addExpectedLifecycleEvent("Project2Build1");
            verifier.assertLifecycleEvents("11.3 ");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"11.99", (Throwable)e);
        }
    }

    public void testPreBuildEvent() {
        IWorkspace workspace = BuilderTest.getWorkspace();
        boolean[] notified = new boolean[1];
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IResourceChangeListener listener = event -> {
            boolean bl = blArray[0] = true;
        };
        workspace.addResourceChangeListener(listener, 8);
        try {
            try {
                this.setAutoBuilding(false);
                proj1.create(this.getMonitor());
                proj1.open(this.getMonitor());
                IProjectDescription desc = proj1.getDescription();
                desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
                proj1.setDescription(desc, this.getMonitor());
                proj1.build(6, "org.eclipse.core.tests.resources.sortbuilder", new HashMap(), null);
                notified[0] = false;
                this.setAutoBuilding(true);
                this.waitForBuild();
                BuilderTest.assertTrue((String)"1.0", (!notified[0] ? 1 : 0) != 0);
            }
            catch (CoreException e) {
                BuilderTest.fail((String)"2.99", (Throwable)e);
                workspace.removeResourceChangeListener(listener);
            }
        }
        finally {
            workspace.removeResourceChangeListener(listener);
        }
    }

    public void testBuildOrder() {
        IProjectDescription desc;
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        try {
            this.setAutoBuilding(false);
            proj1.create(this.getMonitor());
            proj1.open(this.getMonitor());
            proj2.create(this.getMonitor());
            proj2.open(this.getMonitor());
            this.setBuildOrder(proj1, proj2);
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            desc = proj1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
            proj1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            desc = proj2.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build1"), this.createCommand(desc, "Build2")});
            proj2.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.99", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            workspace.build(6, this.getMonitor());
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.assertLifecycleEvents("4.0 ");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            this.setBuildOrder(proj2, proj1);
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("5.0");
        }
        catch (CoreException coreException) {
            BuilderTest.fail((String)"5.99");
        }
        try {
            this.setBuildOrder(proj1);
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.assertLifecycleEvents("6.0");
        }
        catch (CoreException coreException) {
            BuilderTest.fail((String)"6.99");
        }
        try {
            this.setBuildOrder(proj2, proj1);
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("7.0");
        }
        catch (CoreException coreException) {
            BuilderTest.fail((String)"7.99");
        }
    }

    public void testChangeDynamicBuildOrder() {
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        try {
            this.setAutoBuilding(true);
            IWorkspaceDescription wsDescription = BuilderTest.getWorkspace().getDescription();
            wsDescription.setBuildOrder(null);
            BuilderTest.getWorkspace().setDescription(wsDescription);
            BuilderTest.getWorkspace().run(monitor -> {
                proj2.create(this.getMonitor());
                proj2.open(this.getMonitor());
                IProjectDescription desc = proj2.getDescription();
                desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build1")});
                proj2.setDescription(desc, this.getMonitor());
            }, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.reset();
        try {
            BuilderTest.getWorkspace().run(monitor -> {
                proj1.create(this.getMonitor());
                proj1.open(this.getMonitor());
                IProjectDescription desc = proj1.getDescription();
                desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
                proj1.setDescription(desc, this.getMonitor());
                IProjectDescription description = proj2.getDescription();
                description.setDynamicReferences(new IProject[]{proj1});
                proj2.setDescription(description, 0, null);
            }, this.getMonitor());
        }
        catch (CoreException e1) {
            BuilderTest.fail((String)"2.99", (Throwable)e1);
        }
        this.waitForBuild();
        verifier.addExpectedLifecycleEvent("SetInitializationData");
        verifier.addExpectedLifecycleEvent("StartupOnInitialize");
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.addExpectedLifecycleEvent("Build1");
        verifier.assertLifecycleEvents("3.0");
    }

    public void testChangeDynamicBuildOrderDuringPreBuild() throws Exception {
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("bug_330194_referencer");
        IProject proj2 = workspace.getRoot().getProject("bug_330194_referencee");
        this.setAutoBuilding(false);
        this.ensureExistsInWorkspace((IResource)proj1, false);
        this.ensureExistsInWorkspace((IResource)proj2, false);
        IProjectDescription desc = proj1.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
        proj1.setDescription(desc, this.getMonitor());
        desc = proj2.getDescription();
        desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build1")});
        proj2.setDescription(desc, this.getMonitor());
        workspace.build(6, this.getMonitor());
        IResourceChangeListener buildListener = event -> {
            try {
                IProjectDescription desc1 = proj1.getDescription();
                IProjectDescription desc2 = proj2.getDescription();
                if (desc1.getDynamicReferences().length == 0) {
                    desc1.setDynamicReferences(new IProject[]{proj2});
                    desc2.setDynamicReferences(new IProject[0]);
                } else {
                    desc1.setDynamicReferences(new IProject[0]);
                    desc2.setDynamicReferences(new IProject[]{proj1});
                }
                proj1.setDescription(desc1, this.getMonitor());
                proj2.setDescription(desc2, this.getMonitor());
            }
            catch (CoreException coreException) {
                BuilderTest.fail();
            }
        };
        try {
            BuilderTest.getWorkspace().addResourceChangeListener(buildListener, 8);
            SortBuilder verifier = SortBuilder.getInstance();
            verifier.reset();
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("1.0");
            verifier.reset();
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.assertLifecycleEvents("2.0");
            verifier.reset();
            this.setAutoBuilding(true);
            proj1.touch(this.getMonitor());
            this.waitForBuild();
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.0");
            verifier.reset();
            proj1.touch(this.getMonitor());
            this.waitForBuild();
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.assertLifecycleEvents("4.0");
            verifier.reset();
        }
        finally {
            BuilderTest.getWorkspace().removeResourceChangeListener(buildListener);
        }
    }

    public void testCloseOpenProject() {
        IProjectDescription desc;
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build1"), this.createCommand(desc, "Build2")});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.99", (Throwable)e);
        }
        try {
            desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            BuilderTest.assertEquals((String)"4.0", (int)2, (int)commands.length);
            BuilderTest.assertEquals((String)"4.1", (String)commands[0].getBuilderName(), (String)"org.eclipse.core.tests.resources.sortbuilder");
            BuilderTest.assertEquals((String)"4.2", (String)commands[1].getBuilderName(), (String)"org.eclipse.core.tests.resources.sortbuilder");
            Map args = commands[0].getArguments();
            BuilderTest.assertEquals((String)"4.3", (String)"Build1", (String)((String)args.get("BuildID")));
            args = commands[1].getArguments();
            BuilderTest.assertEquals((String)"4.4", (String)"Build2", (String)((String)args.get("BuildID")));
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testCopyProject() {
        IProjectDescription desc;
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("testCopyProject1");
        IProject proj2 = workspace.getRoot().getProject("testCopyProject2");
        try {
            this.setAutoBuilding(true);
            proj1.create(this.getMonitor());
            proj1.open(this.getMonitor());
            this.ensureDoesNotExistInWorkspace((IResource)proj2);
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            desc = proj1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
            proj1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.99", (Throwable)e);
        }
        this.waitForBuild();
        SortBuilder.getInstance().reset();
        try {
            desc = proj1.getDescription();
            desc.setName(proj2.getName());
            proj1.copy(desc, 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.99", (Throwable)e);
        }
        this.waitForBuild();
        SortBuilder builder = SortBuilder.getInstance();
        BuilderTest.assertEquals((String)"4.0", (Object)proj2, (Object)builder.getProject());
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("Build0");
        builder.assertLifecycleEvents("4.4");
        BuilderTest.assertTrue((String)"4.5", (boolean)builder.wasFullBuild());
    }

    public void testDynamicBuildOrder() {
        IProjectDescription desc;
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("PROJECT2");
        try {
            this.setAutoBuilding(false);
            proj1.create(this.getMonitor());
            proj1.open(this.getMonitor());
            proj2.create(this.getMonitor());
            proj2.open(this.getMonitor());
            IProjectDescription description = proj2.getDescription();
            description.setDynamicReferences(new IProject[]{proj1});
            proj2.setDescription(description, 0, null);
            IWorkspaceDescription wsDescription = BuilderTest.getWorkspace().getDescription();
            wsDescription.setBuildOrder(null);
            BuilderTest.getWorkspace().setDescription(wsDescription);
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            desc = proj1.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
            proj1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            desc = proj2.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build1"), this.createCommand(desc, "Build2")});
            proj2.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.99", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            workspace.build(6, this.getMonitor());
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.assertLifecycleEvents("4.0 ");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            IProjectDescription description = proj2.getDescription();
            description.setDynamicReferences(new IProject[0]);
            proj2.setDescription(description, 0, null);
            description = proj1.getDescription();
            description.setDynamicReferences(new IProject[]{proj2});
            proj1.setDescription(description, 0, null);
            workspace.build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build1");
            verifier.addExpectedLifecycleEvent("Build2");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("5.0");
        }
        catch (CoreException coreException) {
            BuilderTest.fail((String)"5.99");
        }
    }

    public void testEnableAutobuild() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            this.setAutoBuilding(true);
            this.waitForBuild();
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.1");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.2", (Throwable)e);
        }
    }

    public void testExceptionBuilder() {
        boolean[] listenerCalled;
        block9: {
            IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
            try {
                this.setAutoBuilding(false);
                project.create(this.getMonitor());
                project.open(this.getMonitor());
            }
            catch (CoreException e) {
                BuilderTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                IProjectDescription desc = project.getDescription();
                ICommand command1 = desc.newCommand();
                command1.setBuilderName("org.eclipse.core.tests.resources.exceptionbuilder");
                desc.setBuildSpec(new ICommand[]{command1});
                project.setDescription(desc, this.getMonitor());
            }
            catch (CoreException e) {
                BuilderTest.fail((String)"2.0", (Throwable)e);
            }
            listenerCalled = new boolean[1];
            IResourceChangeListener listener = event -> {
                boolean bl = blArray[0] = true;
            };
            BuilderTest.getWorkspace().addResourceChangeListener(listener, 16);
            try {
                try {
                    BuilderTest.getWorkspace().build(10, this.getMonitor());
                    BuilderTest.fail((String)"3.0");
                }
                catch (CoreException e) {
                    BuilderTest.assertEquals((String)"3.1", (int)4, (int)e.getStatus().getSeverity());
                    BuilderTest.getWorkspace().removeResourceChangeListener(listener);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                BuilderTest.getWorkspace().removeResourceChangeListener(listener);
                throw throwable;
            }
            BuilderTest.getWorkspace().removeResourceChangeListener(listener);
        }
        BuilderTest.assertTrue((String)"1.0", (boolean)listenerCalled[0]);
    }

    public void testForgetLastBuiltState() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, this.getMonitor());
            verifier = SortBuilder.getInstance();
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.2", (Throwable)e);
        }
        verifier.forgetLastBuiltState();
        try {
            project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, this.getMonitor());
            BuilderTest.assertTrue((String)"4.0", (boolean)verifier.wasDeltaNull());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.99", (Throwable)e);
        }
        verifier.requestForgetLastBuildState();
        try {
            project.touch(this.getMonitor());
            project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, this.getMonitor());
            BuilderTest.assertTrue((String)"5.0", (!verifier.wasDeltaNull() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"5.99", (Throwable)e);
        }
        try {
            BuilderTest.getWorkspace().save(false, this.getMonitor());
        }
        catch (CoreException coreException) {
            BuilderTest.fail((String)"6.99");
        }
        try {
            project.build(10, "org.eclipse.core.tests.resources.sortbuilder", null, this.getMonitor());
            BuilderTest.assertTrue((String)"7.0", (boolean)verifier.wasDeltaNull());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"7.99", (Throwable)e);
        }
        try {
            project.delete(false, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"99.99", (Throwable)e);
        }
    }

    public void testIncrementalBuildBeforeAutobuild() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        IFile input = project.getFolder(SortBuilder.DEFAULT_UNSORTED_FOLDER).getFile("File.txt");
        IFile output = project.getFolder(SortBuilder.DEFAULT_SORTED_FOLDER).getFile("File.txt");
        try {
            this.setAutoBuilding(true);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
            this.ensureExistsInWorkspace(input, this.getRandomContents());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"0.99", (Throwable)e);
        }
        this.waitForBuild();
        BuilderTest.assertTrue((String)"1.0", (boolean)output.exists());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BuilderTest.getWorkspace().run(monitor -> {
                input.setContents((InputStream)new ByteArrayInputStream(new byte[]{5, 4, 3, 2, 1}), 0, this.getMonitor());
                project.build(10, this.getMonitor());
                BuilderTest.transferStreams(output.getContents(), out, null, null);
            }, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.99", (Throwable)e);
        }
        byte[] result = out.toByteArray();
        byte[] expected = new byte[]{1, 2, 3, 4, 5};
        BuilderTest.assertEquals((String)"2.0", (int)expected.length, (int)result.length);
        int i = 0;
        while (i < expected.length) {
            BuilderTest.assertEquals((String)("2.1." + i), (byte)expected[i], (byte)result[i]);
            ++i;
        }
    }

    public void testInterruptAutobuild() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        IFile file = project.getFile("File.txt");
        try {
            this.setAutoBuilding(true);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        this.waitForBuild();
        SortBuilder verifier = SortBuilder.getInstance();
        verifier.reset();
        TestJob blockedJob = new TestJob("Interrupt build", 3, 1000L);
        blockedJob.setRule((ISchedulingRule)BuilderTest.getWorkspace().getRoot());
        TestBarrier barrier = new TestBarrier();
        barrier.setStatus(0);
        IResourceChangeListener listener = event -> {
            blockedJob.schedule();
            while (!Job.getJobManager().currentJob().isBlocking()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            barrier.setStatus(3);
        };
        try {
            try {
                BuilderTest.getWorkspace().addResourceChangeListener(listener, 8);
                file.setContents(this.getRandomContents(), 0, this.getMonitor());
                barrier.waitForStatus(3);
                try {
                    blockedJob.join();
                }
                catch (InterruptedException e) {
                    BuilderTest.fail((String)"1.99", (Throwable)e);
                }
                this.waitForBuild();
                verifier.addExpectedLifecycleEvent("Build0");
                verifier.assertLifecycleEvents("2.0");
            }
            catch (CoreException e) {
                BuilderTest.fail((String)"2.99", (Throwable)e);
                BuilderTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            BuilderTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testLifecycleEvents() {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            BuilderTest.getWorkspace().build(10, this.getMonitor());
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.1");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.2", (Throwable)e);
        }
        try {
            BuilderTest.getWorkspace().build(10, this.getMonitor());
            verifier.assertLifecycleEvents("3.4");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.5", (Throwable)e);
        }
        try {
            BuilderTest.getWorkspace().build(6, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.6");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.8", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.1", (Throwable)e);
        }
        try {
            project.open(this.getMonitor());
            BuilderTest.getWorkspace().build(6, this.getMonitor());
            project.delete(false, this.getMonitor());
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("5.0");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"5.1", (Throwable)e);
        }
    }

    public void testMoveProject() {
        IWorkspace workspace = BuilderTest.getWorkspace();
        IProject proj1 = workspace.getRoot().getProject("PROJECT1");
        IProject proj2 = workspace.getRoot().getProject("Destination");
        try {
            this.setAutoBuilding(false);
            proj1.create(this.getMonitor());
            proj1.open(this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = proj1.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            command.getArguments().put("BuildID", "Build0");
            desc.setBuildSpec(new ICommand[]{command});
            proj1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            proj1.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            proj1.move(proj2.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            proj2.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"5.0", (Throwable)e);
        }
    }

    public void testTurnOnAutobuild() throws CoreException {
        IProject project = BuilderTest.getWorkspace().getRoot().getProject("PROJECT");
        IFile file = project.getFile("File.txt");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"2.0", (Throwable)e);
        }
        SortBuilder verifier = null;
        try {
            BuilderTest.getWorkspace().build(10, this.getMonitor());
            verifier = SortBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.1");
        }
        catch (CoreException e) {
            BuilderTest.fail((String)"3.2", (Throwable)e);
        }
        IWorkspaceRunnable r = monitor -> {
            file.setContents(this.getRandomContents(), 0, this.getMonitor());
            IWorkspaceDescription desc = BuilderTest.getWorkspace().getDescription();
            desc.setAutoBuilding(true);
            BuilderTest.getWorkspace().setDescription(desc);
        };
        this.waitForBuild();
        BuilderTest.getWorkspace().run(r, this.getMonitor());
        this.waitForBuild();
        verifier.addExpectedLifecycleEvent("Build0");
        verifier.assertLifecycleEvents("4.0");
    }
}

