/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ComputeProjectOrderTest {
    public static Test suite() {
        return new JUnit4TestAdapter(ComputeProjectOrderTest.class);
    }

    @org.junit.Test
    public void testComputeVertexOrderDuration() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        int i = 0;
        while (i < 320) {
            HashSet existingVertexes = new HashSet(digraph.vertexMap.keySet());
            Object newVertex = new Object();
            digraph.addVertex(newVertex);
            existingVertexes.forEach(existingVertex -> digraph.addEdge(existingVertex, newVertex));
            ++i;
        }
        long timestamp = System.currentTimeMillis();
        digraph.freeze();
        ComputeProjectOrder.computeVertexOrder((ComputeProjectOrder.Digraph)digraph, Object.class);
        long duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assert.assertTrue((duration < 1000L ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testFilterDigraphDuration() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        Object initialVertex = new Object();
        digraph.addVertex(initialVertex);
        int i = 0;
        while (i < 320) {
            HashSet existingVertexes = new HashSet(digraph.vertexMap.keySet());
            Object newVertex = new Object();
            digraph.addVertex(newVertex);
            existingVertexes.forEach(existingVertex -> digraph.addEdge(existingVertex, newVertex));
            ++i;
        }
        long timestamp = System.currentTimeMillis();
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, o -> false, Object.class);
        Assert.assertEquals(digraph.vertexMap.keySet(), filtered.vertexMap.keySet());
        long duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assert.assertTrue((duration < 1000L ? 1 : 0) != 0);
        timestamp = System.currentTimeMillis();
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, o -> o != initialVertex, Object.class);
        Assert.assertEquals(Collections.singleton(initialVertex), filtered.vertexMap.keySet());
        duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assert.assertTrue((duration < 1000L ? 1 : 0) != 0);
        timestamp = System.currentTimeMillis();
        Predicate<Object> removeOneOutOfTwo = new Predicate<Object>(){
            private int i = 0;

            @Override
            public boolean test(Object t) {
                return this.i++ % 2 == 0;
            }
        };
        filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, (Predicate)removeOneOutOfTwo, Object.class);
        duration = System.currentTimeMillis() - timestamp;
        System.err.println(duration);
        Assert.assertTrue((duration < 1000L ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testFilterDigraphBasic() {
        ComputeProjectOrder.Digraph digraph = new ComputeProjectOrder.Digraph(Object.class);
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        Object d = new Object();
        Object e = new Object();
        Object f = new Object();
        digraph.addVertex(a);
        digraph.addVertex(b);
        digraph.addEdge(a, b);
        digraph.addVertex(c);
        digraph.addEdge(b, c);
        digraph.addVertex(d);
        digraph.addEdge(c, d);
        digraph.addVertex(e);
        digraph.addEdge(d, e);
        digraph.addVertex(f);
        digraph.addEdge(e, f);
        ComputeProjectOrder.Digraph filtered = ComputeProjectOrder.buildFilteredDigraph((ComputeProjectOrder.Digraph)digraph, v -> v == b || v == e, Object.class);
        HashSet<Object> expectedVertexes = new HashSet<Object>(2, 1.0f);
        expectedVertexes.add(a);
        expectedVertexes.add(c);
        expectedVertexes.add(d);
        expectedVertexes.add(f);
        Assert.assertEquals(expectedVertexes, filtered.vertexMap.keySet());
        HashSet<ComputeProjectOrder.Digraph.Edge> expectedEdges = new HashSet<ComputeProjectOrder.Digraph.Edge>(3, 1.0f);
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(a, c));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(c, d));
        expectedEdges.add(new ComputeProjectOrder.Digraph.Edge(d, f));
        Assert.assertEquals(expectedEdges, (Object)filtered.getEdges());
    }
}

