/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.junit.Assert;

public class CycleBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.cyclebuilder";
    protected IProject[] beforeProjects = new IProject[0];
    protected IProject[] afterProjects = new IProject[0];
    protected int rebuildsToRequest = 0;
    private static CycleBuilder singleton;
    protected int buildCount = 0;

    public static CycleBuilder getInstance() {
        return singleton;
    }

    public CycleBuilder() {
        singleton = this;
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (this.beforeProjects != null) {
            IProject[] iProjectArray = this.beforeProjects;
            int n = this.beforeProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject beforeProject = iProjectArray[n2];
                Assert.assertTrue((String)("Missing before project: " + beforeProject), (boolean)this.hasBeenBuilt(beforeProject));
                ++n2;
            }
        }
        if (this.afterProjects != null) {
            int i = 0;
            while (i < this.afterProjects.length) {
                Assert.assertTrue((String)("Missing after project: " + this.afterProjects[i]), (!this.hasBeenBuilt(this.afterProjects[i]) ? 1 : 0) != 0);
                ++i;
            }
        }
        if (this.rebuildsToRequest > this.buildCount) {
            this.changeAllFiles();
            this.needRebuild();
        }
        if (this.buildCount > 0) {
            Assert.assertTrue((String)"Should be incremental build", (kind == 10 ? 1 : 0) != 0);
        }
        ++this.buildCount;
        return null;
    }

    protected InputStream getRandomContents() {
        return new ByteArrayInputStream("foo".getBytes());
    }

    private void changeAllFiles() throws CoreException {
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 1) {
                if (resource.getName().equals(".project")) {
                    return false;
                }
                ((IFile)resource).setContents(this.getRandomContents(), 0, null);
            }
            return true;
        };
        this.getProject().accept(visitor, 2, 0);
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public void resetBuildCount() {
        this.buildCount = 0;
    }

    public void setAfterProjects(IProject[] afterProjects) {
        this.afterProjects = afterProjects;
    }

    public void setBeforeProjects(IProject[] beforeProjects) {
        this.beforeProjects = beforeProjects;
    }

    public void setRebuildsToRequest(int rebuildsToRequest) {
        this.rebuildsToRequest = rebuildsToRequest;
    }
}

