/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.junit.Assert;

public class DeltaVerifierBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.deltaverifierbuilder";
    protected static DeltaVerifierBuilder fgSingleton;
    protected static final ResourceDeltaVerifier verifier;
    protected IProject[] checkDeltas;
    protected boolean deltaWasEmpty = false;
    protected ArrayList<IProject> emptyDeltas = new ArrayList();
    protected ArrayList<IProject> receivedDeltas = new ArrayList();
    protected IProject[] requestedDeltas;
    protected int triggerForLastBuild = 0;

    static {
        verifier = new ResourceDeltaVerifier();
    }

    public static DeltaVerifierBuilder getInstance() {
        if (fgSingleton == null) {
            new DeltaVerifierBuilder();
        }
        return fgSingleton;
    }

    public DeltaVerifierBuilder() {
        if (fgSingleton != null) {
            this.triggerForLastBuild = DeltaVerifierBuilder.fgSingleton.triggerForLastBuild;
            this.deltaWasEmpty = DeltaVerifierBuilder.fgSingleton.deltaWasEmpty;
            this.requestedDeltas = DeltaVerifierBuilder.fgSingleton.requestedDeltas;
            this.checkDeltas = DeltaVerifierBuilder.fgSingleton.checkDeltas;
            this.receivedDeltas = DeltaVerifierBuilder.fgSingleton.receivedDeltas;
            this.emptyDeltas = DeltaVerifierBuilder.fgSingleton.emptyDeltas;
        }
        fgSingleton = this;
    }

    public void addExpectedChange(IResource resource, IResource topLevelParent, int status, int changeFlags) {
        verifier.addExpectedChange(resource, topLevelParent, status, changeFlags, null, null);
    }

    public void addExpectedChange(IResource resource, IResource topLevelParent, int status, int changeFlags, IPath movedFromPath, IPath movedToPath) {
        verifier.addExpectedChange(resource, topLevelParent, status, changeFlags, movedFromPath, movedToPath);
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        super.build(kind, args, monitor);
        this.triggerForLastBuild = kind;
        this.doCheckDeltas();
        IResourceDelta delta = this.getDelta(this.getProject());
        boolean bl = this.deltaWasEmpty = delta == null || delta.getKind() == 0;
        if (!this.deltaWasEmpty) {
            verifier.verifyDelta(delta);
        }
        return this.getRequestedDeltas();
    }

    public void checkDeltas(IProject[] projects) {
        this.checkDeltas = projects;
    }

    protected void clean(IProgressMonitor monitor) {
        this.triggerForLastBuild = 15;
    }

    protected void doCheckDeltas() {
        if (this.checkDeltas == null) {
            return;
        }
        this.receivedDeltas.clear();
        IProject[] iProjectArray = this.checkDeltas;
        int n = this.checkDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IProject checkDelta = iProjectArray[n2];
            IResourceDelta delta = this.getDelta(checkDelta);
            if (delta != null) {
                this.receivedDeltas.add(checkDelta);
                if (delta.getKind() == 0 && delta.getAffectedChildren().length == 0) {
                    this.emptyDeltas.add(checkDelta);
                }
                Assert.assertTrue((String)"Non-null delta", (delta.getResource() != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Delta rooted at project", (delta.getResource().getType() == 4 ? 1 : 0) != 0);
            }
            ++n2;
        }
    }

    public void emptyBuild() throws CoreException {
        this.build(10, null, null);
    }

    public ArrayList<IProject> getEmptyDeltas() {
        return this.emptyDeltas;
    }

    public String getMessage() {
        String msg = this.deltaWasEmpty ? (verifier.hasExpectedChanges() ? "Had expected changes but delta was empty" : "No Delta") : verifier.getMessage();
        return msg;
    }

    public ArrayList<IProject> getReceivedDeltas() {
        return this.receivedDeltas;
    }

    protected IProject[] getRequestedDeltas() {
        return this.requestedDeltas == null ? new IProject[]{} : this.requestedDeltas;
    }

    public boolean isDeltaValid() {
        return this.deltaWasEmpty && !verifier.hasExpectedChanges() || verifier.isDeltaValid();
    }

    public void requestDeltas(IProject[] projects) {
        this.requestedDeltas = projects;
        this.receivedDeltas.clear();
        this.emptyDeltas.clear();
    }

    @Override
    public void reset() {
        super.reset();
        this.triggerForLastBuild = 0;
        if (verifier != null) {
            verifier.reset();
        }
    }

    public boolean wasAutoBuild() {
        return this.triggerForLastBuild == 9;
    }

    public boolean wasBuilt() {
        return this.triggerForLastBuild != 0;
    }

    public boolean wasCleanBuild() {
        return this.triggerForLastBuild == 15;
    }

    public boolean wasFullBuild() {
        return this.triggerForLastBuild == 6;
    }

    public boolean wasIncrementalBuild() {
        return this.triggerForLastBuild == 10;
    }
}

