/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.EmptyDeltaBuilder;

public class EmptyDeltaTest
extends AbstractBuilderTest {
    public static Test suite() {
        return new TestSuite(EmptyDeltaTest.class);
    }

    public EmptyDeltaTest() {
        super("");
    }

    public EmptyDeltaTest(String name) {
        super(name);
    }

    public void testBuildEvents() {
        IProject project = EmptyDeltaTest.getWorkspace().getRoot().getProject("TestBuildEvents");
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            EmptyDeltaTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = project.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.emptydeltabuilder");
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            EmptyDeltaTest.fail((String)"2.0", (Throwable)e);
        }
        EmptyDeltaBuilder verifier = null;
        try {
            new EmptyDeltaBuilder().reset();
            EmptyDeltaTest.getWorkspace().build(10, this.getMonitor());
            verifier = EmptyDeltaBuilder.getInstance();
            verifier.addExpectedLifecycleEvent("SetInitializationData");
            verifier.addExpectedLifecycleEvent("StartupOnInitialize");
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.1");
        }
        catch (CoreException e) {
            EmptyDeltaTest.fail((String)"3.2", (Throwable)e);
            return;
        }
        try {
            verifier.reset();
            EmptyDeltaTest.getWorkspace().build(10, this.getMonitor());
            verifier.addExpectedLifecycleEvent("Build0");
            verifier.assertLifecycleEvents("3.3");
        }
        catch (CoreException e) {
            EmptyDeltaTest.fail((String)"3.4", (Throwable)e);
        }
    }
}

