/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;
import org.eclipse.core.tests.resources.TestPerformer;

public class MultiProjectBuildTest
extends AbstractBuilderTest {
    private IProject project1;
    private IProject project2;
    private IProject project3;
    private IProject project4;
    private IFile file1;
    private IFile file2;
    private IFile file3;
    private IFile file4;

    public MultiProjectBuildTest() {
        super(null);
    }

    public MultiProjectBuildTest(String name) {
        super(name);
    }

    protected IProject[][] interestingProjects() {
        return new IProject[][]{new IProject[0], {this.project3}, {this.project1}, {this.project1, this.project2, this.project3}, {this.project2}, {this.project3}, {this.project4}, {this.project1, this.project2}, {this.project1, this.project3}, {this.project3}, {this.project2, this.project3}, {this.project1, this.project2, this.project3}, {this.project1, this.project2, this.project4}, {this.project1}, {this.project1, this.project3, this.project4}, {this.project1, this.project2}, {this.project2, this.project3, this.project4}, {this.project3, this.project4}, {this.project1, this.project2, this.project3, this.project4}};
    }

    public static Test suite() {
        return new TestSuite(MultiProjectBuildTest.class);
    }

    protected void dirty(IProject[] projects) throws CoreException {
        MultiProjectBuildTest.getWorkspace().run(monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray2[n2];
                IResource[] members = project.members();
                int j = 0;
                while (j < members.length) {
                    if (members[j].getType() == 1 && !members[j].getName().equals(".project")) {
                        ((IFile)members[j]).setContents(this.getRandomContents(), true, true, null);
                    }
                    ++j;
                }
                ++n2;
            }
            MultiProjectBuildTest.getWorkspace().build(10, null);
        }, this.getMonitor());
    }

    IProject[][] reverse(IProject[][] input) {
        if (input == null) {
            return null;
        }
        int len = input.length;
        IProject[][] output = (IProject[][])Array.newInstance(IProject[].class, len);
        int i = 0;
        while (i < len) {
            output[len - i - 1] = input[i];
            ++i;
        }
        return output;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setAutoBuilding(true);
        IWorkspaceRoot root = MultiProjectBuildTest.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.project2 = root.getProject("Project2");
        this.project3 = root.getProject("Project3");
        this.project4 = root.getProject("Project4");
        this.file1 = this.project1.getFile("File1");
        this.file2 = this.project2.getFile("File2");
        this.file3 = this.project3.getFile("File3");
        this.file4 = this.project4.getFile("File4");
        IResource[] resources = new IResource[]{this.project1, this.project2, this.project3, this.project4, this.file1, this.file2, this.file3, this.file4};
        this.ensureExistsInWorkspace(resources, true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        MultiProjectBuildTest.getWorkspace().getRoot().delete(true, this.getMonitor());
    }

    public void testDeltas() {
        try {
            this.setAutoBuilding(false);
            this.addBuilder(this.project1, "org.eclipse.core.tests.resources.deltaverifierbuilder");
            this.project1.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            MultiProjectBuildTest.fail((String)"1.0", (Throwable)e);
        }
        final DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        MultiProjectBuildTest.assertTrue((String)"1.1", (builder != null ? 1 : 0) != 0);
        final IProject[] allProjects = new IProject[]{this.project1, this.project2, this.project3, this.project4};
        builder.checkDeltas(allProjects);
        final IProject[][] previousRequest = new IProject[][]{{this.project1}};
        final HashSet previouslyModified = new HashSet();
        new TestPerformer("testDeltas"){

            @Override
            public Object[] interestingOldState(Object[] args) throws Exception {
                return null;
            }

            @Override
            public Object invokeMethod(Object[] args, int count) throws Exception {
                IProject[] requested = (IProject[])args[0];
                IProject[] toModify = (IProject[])args[1];
                builder.reset();
                builder.requestDeltas(requested);
                MultiProjectBuildTest.this.dirty(toModify);
                IProject[] result = previousRequest[0];
                if (builder.wasBuilt()) {
                    previousRequest[0] = requested;
                    previouslyModified.clear();
                } else {
                    previouslyModified.addAll(Arrays.asList(toModify));
                }
                return result;
            }

            @Override
            public boolean shouldFail(Object[] args, int count) {
                return false;
            }

            @Override
            public boolean wasSuccess(Object[] args, Object result, Object[] oldState) throws Exception {
                HashSet<IProject> requested = new HashSet<IProject>(Arrays.asList((IProject[])result));
                HashSet<IProject> modified = new HashSet<IProject>(Arrays.asList((IProject[])args[1]));
                modified.addAll(previouslyModified);
                HashSet<IProject> obtained = new HashSet<IProject>();
                if (!builder.getReceivedDeltas().isEmpty()) {
                    obtained.addAll(builder.getReceivedDeltas());
                }
                ArrayList<IProject> emptyDeltas = builder.getEmptyDeltas();
                requested.add(builder.getProject());
                IProject[] iProjectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    boolean wasObtained = obtained.contains(project);
                    boolean wasRequested = requested.contains(project);
                    boolean wasModified = modified.contains(project);
                    boolean wasEmpty = emptyDeltas.contains(project);
                    if (wasObtained ? !wasRequested || !wasModified && !wasEmpty : wasRequested && wasModified) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }.performTest(new Object[][]{this.interestingProjects(), this.reverse(this.interestingProjects())});
    }

    public void testRequestMissingProject() {
        try {
            this.addBuilder(this.project1, "org.eclipse.core.tests.resources.deltaverifierbuilder");
            this.project1.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            MultiProjectBuildTest.fail((String)"1.0", (Throwable)e);
        }
        DeltaVerifierBuilder builder = DeltaVerifierBuilder.getInstance();
        MultiProjectBuildTest.assertTrue((String)"1.1", (builder != null ? 1 : 0) != 0);
        IProject[] allProjects = new IProject[]{this.project1, this.project2, this.project3, this.project4};
        try {
            this.project2.close(this.getMonitor());
            this.project3.delete(4, this.getMonitor());
        }
        catch (CoreException e1) {
            MultiProjectBuildTest.fail((String)"1.99", (Throwable)e1);
        }
        builder.checkDeltas(allProjects);
        try {
            this.file1.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e2) {
            MultiProjectBuildTest.fail((String)"2.99", (Throwable)e2);
        }
    }

    public void testPR() throws Exception {
        IProject project = MultiProjectBuildTest.getWorkspace().getRoot().getProject("P1");
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        ICommand one = desc.newCommand();
        one.setBuilderName("org.eclipse.core.tests.resources.refreshbuilder");
        ICommand two = desc.newCommand();
        two.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        desc.setBuildSpec(new ICommand[]{one, two});
        project.setDescription(desc, null);
        project.build(6, null);
        IFile file = project.getFile("Foo");
        file.create(this.getRandomContents(), true, this.getMonitor());
    }
}

