/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.filesystem.ram;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryFileStore;

public class MemoryFileSystem
extends FileSystem {
    public static final String SCHEME_MEMORY = "mem";

    public static URI toURI(IPath path) {
        try {
            return new URI(SCHEME_MEMORY, path.setDevice(null).toPortableString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) throws CoreException {
        return super.fetchFileTree(root, monitor);
    }

    public IFileStore getStore(URI uri) {
        return new MemoryFileStore(Path.fromPortableString((String)uri.getSchemeSpecificPart()));
    }

    public boolean isCaseSensitive() {
        return true;
    }
}

