/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class BucketTreeTests
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(BucketTreeTests.class);
    }

    public BucketTreeTests(String name) {
        super(name);
    }

    public void testVisitor() {
        IPath baseLocation = this.getRandomLocation();
        try {
            SimpleBucket bucket = new SimpleBucket();
            BucketTree tree = new BucketTree((Workspace)BucketTreeTests.getWorkspace(), (Bucket)bucket);
            IProject proj1 = BucketTreeTests.getWorkspace().getRoot().getProject("proj1");
            IProject proj2 = BucketTreeTests.getWorkspace().getRoot().getProject("proj2");
            IFile file1 = proj1.getFile("file1.txt");
            IFolder folder1 = proj1.getFolder("folder1");
            IFile file2 = folder1.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, proj2}, true);
            IPath[] paths = new IPath[]{Path.ROOT, proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath(), proj2.getFullPath()};
            int i = 0;
            while (i < paths.length) {
                try {
                    tree.loadBucketFor(paths[i]);
                }
                catch (CoreException e) {
                    BucketTreeTests.fail((String)("0.1." + i), (Throwable)e);
                }
                bucket.set(paths[i], "path", paths[i].toString());
                bucket.set(paths[i], "segments", Integer.toString(paths[i].segmentCount()));
                ++i;
            }
            try {
                bucket.save();
            }
            catch (CoreException e) {
                BucketTreeTests.fail((String)"0.2", (Throwable)e);
            }
            this.verify(tree, "1.1", (IPath)Path.ROOT, 0, Arrays.asList(Path.ROOT));
            this.verify(tree, "1.2", (IPath)Path.ROOT, 1, Arrays.asList(Path.ROOT, proj1.getFullPath(), proj2.getFullPath()));
            this.verify(tree, "1.3", (IPath)Path.ROOT, Integer.MAX_VALUE, Arrays.asList(Path.ROOT, proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath(), proj2.getFullPath()));
            this.verify(tree, "2.1", proj1.getFullPath(), 0, Arrays.asList(proj1.getFullPath()));
            this.verify(tree, "2.2", proj1.getFullPath(), 1, Arrays.asList(proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath()));
            this.verify(tree, "2.3", proj1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(proj1.getFullPath(), file1.getFullPath(), folder1.getFullPath(), file2.getFullPath()));
            this.verify(tree, "3.1", file1.getFullPath(), 0, Arrays.asList(file1.getFullPath()));
            this.verify(tree, "3.2", file1.getFullPath(), 1, Arrays.asList(file1.getFullPath()));
            this.verify(tree, "3.3", file1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(file1.getFullPath()));
            this.verify(tree, "4.1", folder1.getFullPath(), 0, Arrays.asList(folder1.getFullPath()));
            this.verify(tree, "4.2", folder1.getFullPath(), 1, Arrays.asList(folder1.getFullPath(), file2.getFullPath()));
            this.verify(tree, "4.3", folder1.getFullPath(), Integer.MAX_VALUE, Arrays.asList(folder1.getFullPath(), file2.getFullPath()));
            this.verify(tree, "5.1", file2.getFullPath(), 0, Arrays.asList(file2.getFullPath()));
            this.verify(tree, "5.2", file2.getFullPath(), 1, Arrays.asList(file2.getFullPath()));
            this.verify(tree, "5.3", file2.getFullPath(), Integer.MAX_VALUE, Arrays.asList(file2.getFullPath()));
            this.verify(tree, "6.1", proj2.getFullPath(), 0, Arrays.asList(proj2.getFullPath()));
            this.verify(tree, "6.2", proj2.getFullPath(), 1, Arrays.asList(proj2.getFullPath()));
            this.verify(tree, "6.3", proj2.getFullPath(), Integer.MAX_VALUE, Arrays.asList(proj2.getFullPath()));
        }
        finally {
            this.ensureDoesNotExistInFileSystem(baseLocation.toFile());
        }
    }

    public void verify(BucketTree tree, final String tag, IPath root, int depth, final Collection<IPath> expected) {
        final HashSet visited = new HashSet();
        Bucket.Visitor verifier = new Bucket.Visitor(){

            public int visit(Bucket.Entry entry) {
                SimpleBucket.SimpleEntry simple = (SimpleBucket.SimpleEntry)entry;
                IPath path = simple.getPath();
                BucketTreeTests.assertTrue((String)(String.valueOf(tag) + ".0 " + path), (boolean)expected.contains(path));
                visited.add(path);
                BucketTreeTests.assertEquals((String)(String.valueOf(tag) + ".1 " + path), (String)path.toString(), (String)simple.getProperty("path"));
                BucketTreeTests.assertEquals((String)(String.valueOf(tag) + ".2 " + path), (String)Integer.toString(path.segmentCount()), (String)simple.getProperty("segments"));
                return 0;
            }
        };
        try {
            tree.accept(verifier, root, depth);
        }
        catch (CoreException e) {
            BucketTreeTests.fail((String)(String.valueOf(tag) + ".3"), (Throwable)e);
        }
        BucketTreeTests.assertEquals((String)(String.valueOf(tag) + ".4"), (int)expected.size(), (int)visited.size());
        for (IPath path : expected) {
            BucketTreeTests.assertTrue((String)(String.valueOf(tag) + ".5 " + path), (boolean)visited.contains(path));
        }
    }

    static class SimpleBucket
    extends Bucket {
        protected String getIndexFileName() {
            return "simple_bucket.index";
        }

        protected String getVersionFileName() {
            return "simple_bucket.version";
        }

        protected Bucket.Entry createEntry(IPath path, Object value) {
            return new SimpleEntry(path, (Map)value);
        }

        protected byte getVersion() {
            return 0;
        }

        protected Object readEntryValue(DataInputStream source) throws IOException {
            int length = source.readUnsignedShort();
            HashMap<String, String> value = new HashMap<String, String>(length);
            int j = 0;
            while (j < length) {
                value.put(source.readUTF(), source.readUTF());
                ++j;
            }
            return value;
        }

        public void set(IPath path, String key, String value) {
            String pathAsString = path.toString();
            HashMap<String, String> existing = (HashMap<String, String>)this.getEntryValue(pathAsString);
            if (existing == null) {
                if (value != null) {
                    existing = new HashMap<String, String>();
                    existing.put(key, value);
                    this.setEntryValue(pathAsString, existing);
                }
                return;
            }
            if (value == null) {
                existing.remove(key);
                if (existing.isEmpty()) {
                    existing = null;
                }
            } else {
                existing.put(key, value);
            }
            this.setEntryValue(pathAsString, existing);
        }

        protected void writeEntryValue(DataOutputStream destination, Object entryValue) throws IOException {
            Map value = (Map)entryValue;
            int length = value.size();
            destination.writeShort(length);
            for (Map.Entry entry : value.entrySet()) {
                destination.writeUTF((String)entry.getKey());
                destination.writeUTF((String)entry.getValue());
            }
        }

        static class SimpleEntry
        extends Bucket.Entry {
            private Map<String, String> value;

            public SimpleEntry(IPath path, Map<String, String> value) {
                super(path);
                this.value = value;
            }

            public int getOccurrences() {
                return this.value.size();
            }

            public String getProperty(String key) {
                return this.value.get(key);
            }

            public Object getValue() {
                return this.value;
            }
        }
    }
}

