/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class CopyTest
extends LocalStoreTest {
    public CopyTest() {
    }

    public CopyTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(CopyTest.class);
    }

    public void testCopyResource() throws Throwable {
        IProject[] testProjects = CopyTest.getWorkspace().getRoot().getProjects();
        IFolder folder = testProjects[0].getFolder("folder");
        IFile file = folder.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureExistsInFileSystem((IResource)folder);
        this.ensureExistsInWorkspace((IResource)file, true);
        this.ensureExistsInFileSystem(file);
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int i = 0;
        while (i < numberOfProperties) {
            propNames[i] = new QualifiedName("test", "prop" + i);
            propValues[i] = "value" + i;
            file.setPersistentProperty(propNames[i], propValues[i]);
            file.setSessionProperty(propNames[i], (Object)propValues[i]);
            ++i;
        }
        IFile destination = testProjects[0].getFile("copy of file.txt");
        this.ensureDoesNotExistInFileSystem((IResource)destination);
        try {
            file.copy(destination.getFullPath(), true, null);
        }
        catch (CoreException e) {
            CopyTest.fail((String)"1.0", (Throwable)e);
        }
        CopyTest.assertTrue((String)"1.1", (boolean)destination.exists());
        int i2 = 0;
        while (i2 < numberOfProperties) {
            String persistentValue = destination.getPersistentProperty(propNames[i2]);
            Object sessionValue = destination.getSessionProperty(propNames[i2]);
            CopyTest.assertTrue((String)"1.2", (boolean)propValues[i2].equals(persistentValue));
            CopyTest.assertTrue((String)"1.4", (!propValues[i2].equals(sessionValue) ? 1 : 0) != 0);
            ++i2;
        }
        this.ensureDoesNotExistInWorkspace((IResource)destination);
        this.ensureDoesNotExistInFileSystem((IResource)destination);
        Path path = new Path("copy of file.txt");
        destination = folder.getFile((IPath)path);
        this.ensureDoesNotExistInFileSystem((IResource)destination);
        try {
            file.copy((IPath)path, true, null);
        }
        catch (CoreException e) {
            CopyTest.fail((String)"2.0", (Throwable)e);
        }
        CopyTest.assertTrue((String)"2.1", (boolean)destination.exists());
        int i3 = 0;
        while (i3 < numberOfProperties) {
            String persistentValue = destination.getPersistentProperty(propNames[i3]);
            Object sessionValue = destination.getSessionProperty(propNames[i3]);
            CopyTest.assertTrue((String)"2.2", (boolean)propValues[i3].equals(persistentValue));
            CopyTest.assertTrue((String)"2.4", (!propValues[i3].equals(sessionValue) ? 1 : 0) != 0);
            ++i3;
        }
        this.ensureDoesNotExistInWorkspace((IResource)destination);
        this.ensureDoesNotExistInFileSystem((IResource)destination);
        destination = folder.getFolder("subfolder");
        try {
            folder.copy(destination.getFullPath(), true, null);
            CopyTest.fail((String)"3.1");
        }
        catch (RuntimeException runtimeException) {
        }
        catch (CoreException e) {
            CopyTest.fail((String)"3.2", (Throwable)e);
        }
        testProjects[0].refreshLocal(2, null);
        IFolder subfolder = folder.getFolder("subfolder");
        this.ensureExistsInFileSystem((IResource)subfolder);
        IFile anotherFile = folder.getFile("new file");
        this.ensureExistsInFileSystem(anotherFile);
        destination = testProjects[0].getFolder("destination");
        try {
            folder.copy(destination.getFullPath(), false, null);
            CopyTest.fail((String)"4.1");
        }
        catch (CoreException e) {
            CopyTest.assertTrue((String)"4.2", (e.getStatus().getChildren().length == 2 ? 1 : 0) != 0);
        }
        CopyTest.assertTrue((String)"4.3", (boolean)destination.exists());
        CopyTest.assertTrue((String)"4.4", (boolean)((IContainer)destination).getFile((IPath)new Path(file.getName())).exists());
        CopyTest.assertTrue((String)"4.5", (!((IContainer)destination).getFolder((IPath)new Path(subfolder.getName())).exists() ? 1 : 0) != 0);
        CopyTest.assertTrue((String)"4.6", (!((IContainer)destination).getFile((IPath)new Path(anotherFile.getName())).exists() ? 1 : 0) != 0);
        IFile target = ((IContainer)destination).getFile((IPath)new Path(file.getName()));
        int i4 = 0;
        while (i4 < numberOfProperties) {
            String persistentValue = target.getPersistentProperty(propNames[i4]);
            Object sessionValue = target.getSessionProperty(propNames[i4]);
            CopyTest.assertTrue((String)"4.7", (boolean)propValues[i4].equals(persistentValue));
            CopyTest.assertTrue((String)"4.9", (!propValues[i4].equals(sessionValue) ? 1 : 0) != 0);
            ++i4;
        }
        this.ensureDoesNotExistInWorkspace((IResource)destination);
        this.ensureDoesNotExistInFileSystem((IResource)destination);
        file = testProjects[0].getFile("ghost");
        file.create(null, true, null);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        destination = testProjects[0].getFile("destination");
        try {
            file.copy(destination.getFullPath(), true, null);
            CopyTest.fail((String)"5.1");
        }
        catch (CoreException coreException) {}
    }
}

