/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class DeleteTest
extends LocalStoreTest {
    public DeleteTest() {
    }

    public DeleteTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(DeleteTest.class);
    }

    public void testDeleteOpenProject() {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file}, true);
        IPath folderPath = folder.getLocation();
        IPath filePath = file.getLocation();
        IPath projectLocation = project.getLocation();
        try {
            project.delete(false, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"1.0", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"1.1", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"1.2", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"1.3", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"1.4", (boolean)folderPath.toFile().isDirectory());
        DeleteTest.assertTrue((String)"1.5", (boolean)filePath.toFile().isFile());
        Workspace.clear((File)projectLocation.toFile());
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file}, true);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = project.getLocation();
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"2.0", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"2.1", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.2", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"2.3", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"2.4", (!projectLocation.toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.5", (!folderPath.toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.6", (!filePath.toFile().exists() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(new IResource[]{folder, file}, false);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = project.getLocation();
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"3.0", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"3.1", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"3.2", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"3.3", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"3.4", (!folderPath.toFile().isDirectory() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"3.5", (!filePath.toFile().isFile() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file}, true);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"4.0", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"6.1", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"6.2", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"6.3", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"6.4", (!folderPath.toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"6.5", (!filePath.toFile().exists() ? 1 : 0) != 0);
        Workspace.clear((File)folderPath.toFile());
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInFileSystem(new IResource[]{folder, file});
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = project.getLocation();
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"7.0", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"7.1", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"7.2", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"7.3", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"7.4", (!folderPath.toFile().isDirectory() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"7.5", (!filePath.toFile().isFile() ? 1 : 0) != 0);
    }

    public void testDeleteClosedProject() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        this.ensureExistsInWorkspace(new IResource[]{project, folder}, true);
        this.ensureExistsInWorkspace((IResource)file, false);
        IPath folderPath = folder.getLocation();
        IPath filePath = file.getLocation();
        IPath projectLocation = project.getLocation();
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            project.delete(false, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"1.1", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"1.2", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"1.3", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"1.4", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"1.5", (boolean)folderPath.toFile().exists());
        DeleteTest.assertTrue((String)"1.6", (!filePath.toFile().exists() ? 1 : 0) != 0);
        Workspace.clear((File)projectLocation.toFile());
        this.ensureExistsInWorkspace(new IResource[]{project, folder, file}, true);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"2.1", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"2.2", (!project.exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.3", (!((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project).toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"2.4", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"2.5", (!folderPath.toFile().isDirectory() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.6", (!filePath.toFile().isFile() ? 1 : 0) != 0);
        this.ensureExistsInWorkspace(new IResource[]{project, folder}, true);
        this.ensureExistsInWorkspace((IResource)file, false);
        folderPath = folder.getLocation();
        filePath = file.getLocation();
        projectLocation = project.getLocation();
        try {
            this.projects[0].close(this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            this.projects[0].delete(true, false, this.getMonitor());
        }
        catch (CoreException e) {
            DeleteTest.fail((String)"3.1", (Throwable)e);
        }
        DeleteTest.assertTrue((String)"3.2", (!project.exists() ? 1 : 0) != 0);
        IPath metaAreaLocation = ((Workspace)DeleteTest.getWorkspace()).getMetaArea().locationFor((IResource)project);
        DeleteTest.assertTrue((String)"3.3", (!metaAreaLocation.toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"3.4", (!metaAreaLocation.append(".properties").toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"3.5", (!projectLocation.append(".project").toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertNull((String)"3.6", (Object)project.getLocation());
        DeleteTest.assertTrue((String)"3.7", (!folderPath.toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"3.8", (!filePath.toFile().exists() ? 1 : 0) != 0);
    }

    public void testDeleteResource() throws Throwable {
        IFolder folder = this.projects[0].getFolder("folder");
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile fileSync = folder.getFile("fileSync");
        this.ensureExistsInWorkspace((IResource)fileSync, true);
        IFile fileUnsync = folder.getFile("fileUnsync");
        this.ensureExistsInWorkspace((IResource)fileUnsync, true);
        IFile fileCreated = folder.getFile("fileCreated");
        this.ensureExistsInFileSystem(fileCreated);
        IFolder subfolderSync = folder.getFolder("subfolderSync");
        this.ensureExistsInWorkspace((IResource)subfolderSync, true);
        IFolder deletedfolderSync = subfolderSync.getFolder("deletedfolderSync");
        this.ensureExistsInWorkspace((IResource)deletedfolderSync, true);
        IFolder subfolderUnsync = folder.getFolder("subfolderUnsync");
        this.ensureExistsInWorkspace((IResource)subfolderUnsync, true);
        IFolder subsubfolderUnsync = subfolderUnsync.getFolder("subsubfolderUnsync");
        this.ensureExistsInWorkspace((IResource)subsubfolderUnsync, true);
        IFile subsubfileSync = subsubfolderUnsync.getFile("subsubfileSync");
        this.ensureExistsInWorkspace((IResource)subsubfileSync, true);
        IFile subsubfileUnsync = subsubfolderUnsync.getFile("subsubfileUnsync");
        this.ensureExistsInWorkspace((IResource)subsubfileUnsync, true);
        this.ensureOutOfSync(fileUnsync);
        this.ensureDoesNotExistInFileSystem((IResource)deletedfolderSync);
        this.ensureOutOfSync(subsubfileUnsync);
        folder.delete(true, null);
        DeleteTest.assertTrue((String)"1.1", (!folder.getLocation().toFile().exists() ? 1 : 0) != 0);
        folder = this.projects[0].getFolder("folder");
        this.ensureExistsInWorkspace((IResource)folder, true);
        fileSync = folder.getFile("fileSync");
        this.ensureExistsInWorkspace((IResource)fileSync, true);
        fileUnsync = folder.getFile("fileUnsync");
        this.ensureExistsInWorkspace((IResource)fileUnsync, true);
        fileCreated = folder.getFile("fileCreated");
        this.ensureExistsInFileSystem(fileCreated);
        subfolderSync = folder.getFolder("subfolderSync");
        this.ensureExistsInWorkspace((IResource)subfolderSync, true);
        deletedfolderSync = subfolderSync.getFolder("deletedfolderSync");
        this.ensureExistsInWorkspace((IResource)deletedfolderSync, true);
        subfolderUnsync = folder.getFolder("subfolderUnsync");
        this.ensureExistsInWorkspace((IResource)subfolderUnsync, true);
        subsubfolderUnsync = subfolderUnsync.getFolder("subsubfolderUnsync");
        this.ensureExistsInWorkspace((IResource)subsubfolderUnsync, true);
        subsubfileSync = subsubfolderUnsync.getFile("subsubfileSync");
        this.ensureExistsInWorkspace((IResource)subsubfileSync, true);
        subsubfileUnsync = subsubfolderUnsync.getFile("subsubfileUnsync");
        this.ensureExistsInWorkspace((IResource)subsubfileUnsync, true);
        this.ensureOutOfSync(fileUnsync);
        this.ensureDoesNotExistInFileSystem((IResource)deletedfolderSync);
        this.ensureOutOfSync(subsubfileUnsync);
        try {
            folder.delete(false, null);
            DeleteTest.fail((String)"2.0");
        }
        catch (CoreException coreException) {}
        DeleteTest.assertTrue((String)"2.1", (boolean)folder.getLocation().toFile().exists());
        DeleteTest.assertTrue((String)"2.2", (!fileSync.getLocation().toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.3", (boolean)fileUnsync.getLocation().toFile().exists());
        DeleteTest.assertTrue((String)"2.4", (!subfolderSync.getLocation().toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.5", (boolean)subfolderUnsync.getLocation().toFile().exists());
        DeleteTest.assertTrue((String)"2.6", (!deletedfolderSync.getLocation().toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.7", (boolean)subsubfolderUnsync.getLocation().toFile().exists());
        DeleteTest.assertTrue((String)"2.8", (boolean)subsubfileUnsync.getLocation().toFile().exists());
        DeleteTest.assertTrue((String)"2.9", (!subsubfileSync.getLocation().toFile().exists() ? 1 : 0) != 0);
        DeleteTest.assertTrue((String)"2.10", (boolean)fileCreated.getLocation().toFile().exists());
    }
}

