/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.bug440110.Bug440110FileSystem;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class FileSystemResourceManagerTest
extends LocalStoreTest
implements ICoreConstants {
    public FileSystemResourceManagerTest() {
    }

    public FileSystemResourceManagerTest(String name) {
        super(name);
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/Folder1/", "/Folder1/File1", "/Folder1/Folder2/", "/Folder1/Folder2/File2", "/Folder1/Folder2/Folder3/"};
    }

    public static Test suite() {
        return new TestSuite(FileSystemResourceManagerTest.class);
    }

    public void testBug440110() throws URISyntaxException, CoreException {
        String projectName = this.getUniqueString();
        IWorkspace workspace = FileSystemResourceManagerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription projectDescription = workspace.newProjectDescription(projectName);
        projectDescription.setLocationURI(new URI("bug440110://" + projectName));
        project.create(projectDescription, null);
        project.open(null);
        FileSystemResourceManagerTest.assertEquals((String)"0.1", (String)"bug440110", (String)project.getLocationURI().getScheme());
        IFolder folder = project.getFolder("folder");
        folder.create(true, true, null);
        FileSystemResourceManagerTest.assertEquals((String)"0.2", (String)"bug440110", (String)folder.getLocationURI().getScheme());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(0, null);
        FileSystemResourceManagerTest.assertFalse((String)"1.0", (boolean)Bug440110FileSystem.hasFetchedFileTree());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(1, null);
        FileSystemResourceManagerTest.assertTrue((String)"2.0", (boolean)Bug440110FileSystem.hasFetchedFileTree());
        Bug440110FileSystem.clearFetchedFileTree();
        folder.refreshLocal(2, null);
        FileSystemResourceManagerTest.assertTrue((String)"3.0", (boolean)Bug440110FileSystem.hasFetchedFileTree());
    }

    public void testContainerFor() throws Throwable {
        try {
            this.getLocalManager().containerForLocation(null);
            FileSystemResourceManagerTest.fail((String)"1.1");
        }
        catch (RuntimeException runtimeException) {}
        Path path = new Path("target");
        IFolder folder = this.projects[0].getFolder((IPath)path);
        IPath location = this.projects[0].getLocation().append((IPath)path);
        IFolder testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)folder.equals((Object)testFolder));
        path = new Path("folder/target");
        folder = this.projects[0].getFolder((IPath)path);
        location = this.projects[0].getLocation().append((IPath)path);
        testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)folder.equals((Object)testFolder));
        path = new Path("folder/folder/target");
        folder = this.projects[0].getFolder((IPath)path);
        location = this.projects[0].getLocation().append((IPath)path);
        testFolder = (IFolder)this.getLocalManager().containerForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.3", (boolean)folder.equals((Object)testFolder));
        testFolder = (IFolder)this.getLocalManager().containerForLocation((IPath)new Path("../this/path/must/not/exist"));
        FileSystemResourceManagerTest.assertTrue((String)"3.1", (testFolder == null ? 1 : 0) != 0);
    }

    public void testCreateFile() throws Throwable {
        IProject project = this.projects[0];
        File file = (File)project.getFile("foo");
        String originalContent = "this string should not be equal the other";
        try {
            file.create(this.getContents(originalContent), false, null);
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"1.1", (Throwable)e);
        }
        FileSystemResourceManagerTest.assertTrue((String)"1.2", (boolean)file.exists());
        FileSystemResourceManagerTest.assertTrue((String)"1.3", (boolean)file.isLocal(0));
        FileSystemResourceManagerTest.assertEquals((String)"1.4", (long)file.getStore().fetchInfo().getLastModified(), (long)file.getResourceInfo(false, false).getLocalSyncInfo());
        try {
            FileSystemResourceManagerTest.assertTrue((String)"1.5", (boolean)this.compareContent(this.getContents(originalContent), this.getLocalManager().read((IFile)file, true, null)));
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"1.6", (Throwable)e);
        }
    }

    public void testFileFor() throws Throwable {
        try {
            this.getLocalManager().fileForLocation(null);
            FileSystemResourceManagerTest.fail((String)"1.1");
        }
        catch (RuntimeException runtimeException) {}
        Path path = new Path("file");
        IFile file = this.projects[0].getFile((IPath)path);
        IPath location = this.projects[0].getLocation().append((IPath)path);
        IFile testFile = this.getLocalManager().fileForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)file.equals((Object)testFile));
        path = new Path("folder/file");
        file = this.projects[0].getFile((IPath)path);
        location = this.projects[0].getLocation().append((IPath)path);
        testFile = this.getLocalManager().fileForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)file.equals((Object)testFile));
        path = new Path("folder/folder/file");
        file = this.projects[0].getFile((IPath)path);
        location = this.projects[0].getLocation().append((IPath)path);
        testFile = this.getLocalManager().fileForLocation(location);
        FileSystemResourceManagerTest.assertTrue((String)"2.3", (boolean)file.equals((Object)testFile));
        testFile = this.getLocalManager().fileForLocation((IPath)new Path("../this/path/must/not/exist"));
        FileSystemResourceManagerTest.assertTrue((String)"7.1", (testFile == null ? 1 : 0) != 0);
    }

    public void testIsLocal() throws Throwable {
        IProject project = this.projects[0];
        IResource[] resources = this.buildResources((IContainer)project, this.defineHierarchy());
        this.ensureExistsInWorkspace(resources, true);
        this.ensureDoesNotExistInFileSystem(resources);
        FileSystemResourceManagerTest.assertTrue((String)"1.0", (boolean)project.isLocal(2));
        IFolder folder = project.getFolder("Folder1");
        IWorkspaceRunnable operation = monitor -> {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                ((Resource)member).getResourceInfo(false, true).clear(2);
                ++n2;
            }
        };
        FileSystemResourceManagerTest.getWorkspace().run(operation, null);
        FileSystemResourceManagerTest.assertTrue((String)"2.0", (boolean)project.isLocal(1));
        FileSystemResourceManagerTest.assertTrue((String)"3.0", (boolean)folder.isLocal(0));
        FileSystemResourceManagerTest.assertTrue((String)"4.0", (!folder.isLocal(2) ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace((IResource)project);
    }

    public void testLocationFor() throws Throwable {
        IPath location = this.projects[0].getLocation();
        FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)location.equals((Object)this.getLocalManager().locationFor((IResource)this.projects[0])));
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)location.equals((Object)FileSystemResourceManagerTest.getWorkspace().getRoot().getLocation().append(this.projects[0].getName())));
    }

    public void testResourcePathFor() throws Throwable {
    }

    public void testSynchronizeProject() throws Throwable {
        IFile file = this.projects[0].getFile("file");
        this.ensureExistsInFileSystem(file);
        this.projects[0].refreshLocal(0, null);
        FileSystemResourceManagerTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        IFolder folder = this.projects[0].getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        this.ensureExistsInFileSystem((IResource)folder);
        this.ensureExistsInFileSystem((IResource)subfolder);
        this.ensureExistsInFileSystem(subfile);
        this.projects[0].refreshLocal(1, null);
        FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)file.exists());
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)folder.exists());
        FileSystemResourceManagerTest.assertTrue((String)"2.3", (!subfolder.exists() ? 1 : 0) != 0);
        FileSystemResourceManagerTest.assertTrue((String)"2.4", (!subfile.exists() ? 1 : 0) != 0);
        this.projects[0].refreshLocal(2, null);
        FileSystemResourceManagerTest.assertTrue((String)"3.1", (boolean)file.exists());
        FileSystemResourceManagerTest.assertTrue((String)"3.2", (boolean)folder.exists());
        FileSystemResourceManagerTest.assertTrue((String)"3.3", (boolean)subfolder.exists());
        FileSystemResourceManagerTest.assertTrue((String)"3.4", (boolean)subfile.exists());
        file = this.projects[0].getFile("closed");
        this.projects[0].close(null);
        this.ensureExistsInFileSystem(file);
        this.projects[0].open(null);
        FileSystemResourceManagerTest.assertTrue((String)"4.1", (!file.exists() ? 1 : 0) != 0);
        this.projects[0].refreshLocal(2, null);
        FileSystemResourceManagerTest.assertTrue((String)"4.2", (boolean)file.exists());
        FileSystemResourceManagerTest.getWorkspace().getRoot().getProject("inexistingProject").refreshLocal(2, null);
    }

    public void testWriteFile() {
        IProject project = this.projects[0];
        IFile file = project.getFile("foo");
        this.ensureExistsInWorkspace((IResource)file, true);
        String originalContent = "this string should not be equal the other";
        String anotherContent = "and this string should not... well, you know...";
        InputStream original = this.getContents(originalContent);
        try {
            this.write(file, original, true, null);
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"1.0", (Throwable)e);
        }
        original = this.getContents(originalContent);
        try {
            FileSystemResourceManagerTest.assertTrue((String)"1.1", (boolean)this.compareContent(original, this.getLocalManager().read(file, true, null)));
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"1.2", (Throwable)e);
        }
        InputStream another = this.getContents(anotherContent);
        try {
            this.write(file, another, false, null);
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"2.0", (Throwable)e);
        }
        another = this.getContents(anotherContent);
        try {
            FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)this.compareContent(another, this.getLocalManager().read(file, true, null)));
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"2.2", (Throwable)e);
        }
        original = this.getContents(originalContent);
        try {
            this.write(file, original, true, null);
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"3.0", (Throwable)e);
        }
        original = this.getContents(originalContent);
        try {
            FileSystemResourceManagerTest.assertTrue((String)"3.1", (boolean)this.compareContent(original, this.getLocalManager().read(file, true, null)));
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"3.2", (Throwable)e);
        }
        this.ensureOutOfSync(file);
        another = this.getContents(anotherContent);
        try {
            this.write(file, another, false, null);
            FileSystemResourceManagerTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
        try {
            file.setContents(another, false, false, null);
            FileSystemResourceManagerTest.fail((String)"4.3");
        }
        catch (CoreException coreException) {}
        try {
            file.setContents(another, true, false, null);
        }
        catch (CoreException e) {
            FileSystemResourceManagerTest.fail((String)"4.4", (Throwable)e);
        }
        this.ensureDoesNotExistInFileSystem((IResource)file);
        another = this.getContents(anotherContent);
        try {
            this.write(file, another, false, null);
            FileSystemResourceManagerTest.fail((String)"5.0");
        }
        catch (CoreException coreException) {}
        this.ensureDoesNotExistInWorkspace((IResource)project);
    }

    public void testWriteFolder() throws Throwable {
        IProject project = this.projects[0];
        IFolder folder = project.getFolder("foo");
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        IFile file = project.getFile("foo");
        this.ensureExistsInFileSystem(file);
        boolean ok = false;
        try {
            this.write(folder, true, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        FileSystemResourceManagerTest.assertTrue((String)"1.1", (boolean)ok);
        ok = false;
        try {
            this.write(folder, false, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        FileSystemResourceManagerTest.assertTrue((String)"1.2", (boolean)ok);
        this.ensureDoesNotExistInFileSystem((IResource)file);
        this.ensureExistsInFileSystem((IResource)folder);
        this.write(folder, true, null);
        FileSystemResourceManagerTest.assertTrue((String)"2.1", (boolean)folder.getLocation().toFile().isDirectory());
        ok = false;
        try {
            this.write(folder, false, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)ok);
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        this.write(folder, true, null);
        FileSystemResourceManagerTest.assertTrue((String)"3.1", (boolean)folder.getLocation().toFile().isDirectory());
        this.ensureDoesNotExistInFileSystem((IResource)folder);
        this.write(folder, false, null);
        FileSystemResourceManagerTest.assertTrue((String)"3.1", (boolean)folder.getLocation().toFile().isDirectory());
    }

    public void testWriteProject() throws Throwable {
        IProject project = this.projects[0];
        IFile dotProject = project.getFile(".project");
        IFileStore fileStore = ((Resource)project).getStore();
        FileSystemResourceManagerTest.getWorkspace().run(monitor -> {
            this.ensureDoesNotExistInFileSystem((IResource)project);
            FileSystemResourceManagerTest.assertTrue((String)"2.1", (!fileStore.fetchInfo().isDirectory() ? 1 : 0) != 0);
            ((Project)project).writeDescription(1);
        }, null);
        FileSystemResourceManagerTest.assertTrue((String)"2.2", (boolean)fileStore.fetchInfo().isDirectory());
        long lastModified = ((Resource)dotProject).getStore().fetchInfo().getLastModified();
        FileSystemResourceManagerTest.assertEquals((String)"2.3", (long)lastModified, (long)((Resource)project).getResourceInfo(false, false).getLocalSyncInfo());
    }

    protected void write(IFile file, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable operation = pm -> {
            int flags = force ? 1 : 0;
            IFileInfo info = ((Resource)file).getStore().fetchInfo();
            this.getLocalManager().write(file, contents, info, flags, false, null);
        };
        FileSystemResourceManagerTest.getWorkspace().run(operation, null);
    }

    protected void write(IFolder folder, boolean force, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable operation = pm -> this.getLocalManager().write(folder, force, null);
        FileSystemResourceManagerTest.getWorkspace().run(operation, null);
    }
}

