/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.Bucket;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class HistoryBucketTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(HistoryBucketTest.class);
    }

    public HistoryBucketTest(String name) {
        super(name);
    }

    public void testDuplicates() {
        IPath baseLocation = this.getRandomLocation();
        try {
            HistoryBucket index1 = new HistoryBucket();
            IPath location1 = baseLocation.append("location1");
            try {
                index1.load("foo", location1.toFile());
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"1.0", (Throwable)e);
            }
            Path path = new Path("/foo/bar");
            UniversalUniqueIdentifier uuid = new UniversalUniqueIdentifier();
            long lastModified = (long)(Math.random() * 9.223372036854776E18);
            index1.addBlob((IPath)path, uuid, lastModified);
            HistoryBucketTest.assertEquals((String)"2.0", (int)1, (int)index1.getEntryCount());
            index1.addBlob((IPath)path, uuid, lastModified);
            HistoryBucketTest.assertEquals((String)"3.0", (int)1, (int)index1.getEntryCount());
            HistoryBucket.HistoryEntry entry = index1.getEntry((IPath)path);
            HistoryBucketTest.assertNotNull((String)"3.1", (Object)entry);
            HistoryBucketTest.assertEquals((String)"3.2", (Object)path, (Object)entry.getPath());
            HistoryBucketTest.assertEquals((String)"3.3", (int)1, (int)entry.getOccurrences());
            HistoryBucketTest.assertEquals((String)"3.4", (Object)uuid, (Object)entry.getUUID(0));
            HistoryBucketTest.assertEquals((String)"3.5", (long)lastModified, (long)entry.getTimestamp(0));
        }
        finally {
            this.ensureDoesNotExistInFileSystem(baseLocation.toFile());
        }
    }

    public void testPersistence() {
        IPath baseLocation = this.getRandomLocation();
        try {
            HistoryBucket index1 = new HistoryBucket();
            IPath location = baseLocation.append("location");
            try {
                index1.load("foo", location.toFile());
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"1.0", (Throwable)e);
            }
            HistoryBucketTest.assertEquals((String)"1.1", (int)0, (int)index1.getEntryCount());
            Path path = new Path("/foo/bar");
            UniversalUniqueIdentifier uuid1 = new UniversalUniqueIdentifier();
            long lastModified1 = (long)(Math.random() * 9.223372036854776E18);
            index1.addBlob((IPath)path, uuid1, lastModified1);
            HistoryBucketTest.assertEquals((String)"2.0", (int)1, (int)index1.getEntryCount());
            try {
                index1.save();
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"2.1", (Throwable)e);
            }
            HistoryBucket index2 = new HistoryBucket();
            try {
                index2.load("foo", location.toFile(), false);
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"3.0", (Throwable)e);
            }
            HistoryBucketTest.assertEquals((String)"3.1", (int)1, (int)index1.getEntryCount());
            HistoryBucket.HistoryEntry entry = index1.getEntry((IPath)path);
            HistoryBucketTest.assertNotNull((String)"3.2", (Object)entry);
            HistoryBucketTest.assertEquals((String)"3.3", (Object)path, (Object)entry.getPath());
            HistoryBucketTest.assertEquals((String)"3.4", (int)1, (int)entry.getOccurrences());
            HistoryBucketTest.assertEquals((String)"3.5", (Object)uuid1, (Object)entry.getUUID(0));
            HistoryBucketTest.assertEquals((String)"3.6", (long)lastModified1, (long)entry.getTimestamp(0));
            UniversalUniqueIdentifier uuid2 = new UniversalUniqueIdentifier();
            long lastModified2 = (long)Math.abs(Math.random() * 9.223372036854776E18);
            index2.addBlob((IPath)path, uuid2, lastModified2);
            try {
                index2.save();
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"4.0", (Throwable)e);
            }
            try {
                index1.load("foo", location.toFile(), true);
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"4.1", (Throwable)e);
            }
            HistoryBucketTest.assertEquals((String)"4.2", (int)1, (int)index1.getEntryCount());
            entry = index1.getEntry((IPath)path);
            HistoryBucketTest.assertNotNull((String)"4.3", (Object)entry);
            HistoryBucketTest.assertEquals((String)"4.4", (Object)path, (Object)entry.getPath());
            HistoryBucketTest.assertEquals((String)"4.5", (int)2, (int)entry.getOccurrences());
            try {
                index1.accept(new Bucket.Visitor(){

                    public int visit(Bucket.Entry fileEntry) {
                        fileEntry.delete();
                        return 0;
                    }
                }, (IPath)path, 0);
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"5.0", (Throwable)e);
            }
            entry = index1.getEntry((IPath)path);
            HistoryBucketTest.assertNull((String)"5.1", (Object)entry);
            try {
                index2.load("foo", location.toFile(), true);
            }
            catch (CoreException e) {
                HistoryBucketTest.fail((String)"5.2", (Throwable)e);
            }
            entry = index2.getEntry((IPath)path);
            HistoryBucketTest.assertNull((String)"5.3", (Object)entry);
        }
        finally {
            this.ensureDoesNotExistInFileSystem(baseLocation.toFile());
        }
    }

    public void testSort() {
        HistoryBucket index = new HistoryBucket();
        Path path = new Path("/foo");
        HistoryBucketTest.assertNull((String)"1.0", (Object)index.getEntry((IPath)path));
        UniversalUniqueIdentifier uuid1 = new UniversalUniqueIdentifier();
        long timestamp1 = 10L;
        index.addBlob((IPath)path, uuid1, timestamp1);
        HistoryBucket.HistoryEntry entry = index.getEntry((IPath)path);
        HistoryBucketTest.assertNotNull((String)"2.0", (Object)entry);
        HistoryBucketTest.assertEquals((String)"2.1", (int)1, (int)entry.getOccurrences());
        HistoryBucketTest.assertEquals((String)"2.2", (Object)uuid1, (Object)entry.getUUID(0));
        HistoryBucketTest.assertEquals((String)"2.3", (long)timestamp1, (long)entry.getTimestamp(0));
        UniversalUniqueIdentifier uuid2 = new UniversalUniqueIdentifier();
        long timestamp2 = timestamp1 + 1L;
        index.addBlob((IPath)path, uuid2, timestamp2);
        entry = index.getEntry((IPath)path);
        HistoryBucketTest.assertNotNull((String)"3.0", (Object)entry);
        HistoryBucketTest.assertEquals((String)"3.1", (int)2, (int)entry.getOccurrences());
        HistoryBucketTest.assertEquals((String)"3.2", (Object)uuid2, (Object)entry.getUUID(0));
        HistoryBucketTest.assertEquals((String)"3.3", (long)timestamp2, (long)entry.getTimestamp(0));
        HistoryBucketTest.assertEquals((String)"3.4", (Object)uuid1, (Object)entry.getUUID(1));
        HistoryBucketTest.assertEquals((String)"3.5", (long)timestamp1, (long)entry.getTimestamp(1));
        UniversalUniqueIdentifier uuid3 = new UniversalUniqueIdentifier();
        long timestamp3 = timestamp1;
        index.addBlob((IPath)path, uuid3, timestamp3);
        entry = index.getEntry((IPath)path);
        HistoryBucketTest.assertNotNull((String)"4.0", (Object)entry);
        HistoryBucketTest.assertEquals((String)"4.1", (int)3, (int)entry.getOccurrences());
        HistoryBucketTest.assertEquals((String)"4.2", (Object)uuid2, (Object)entry.getUUID(0));
        HistoryBucketTest.assertEquals((String)"4.3", (long)timestamp2, (long)entry.getTimestamp(0));
        HistoryBucketTest.assertEquals((String)"4.4", (Object)uuid3, (Object)entry.getUUID(1));
        HistoryBucketTest.assertEquals((String)"4.5", (long)timestamp3, (long)entry.getTimestamp(1));
        HistoryBucketTest.assertEquals((String)"4.6", (Object)uuid1, (Object)entry.getUUID(2));
        HistoryBucketTest.assertEquals((String)"4.7", (long)timestamp1, (long)entry.getTimestamp(2));
    }
}

