/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public abstract class LocalStoreTest
extends ResourceTest {
    protected static int numberOfProjects = 3;
    protected static int numberOfProperties = 5;
    protected static final int sleepTime = 5000;
    protected String[] projectNames;
    protected IProject[] projects;

    public LocalStoreTest() {
    }

    public LocalStoreTest(String name) {
        super(name);
    }

    protected int countChildren(File root) {
        String[] children = root.list();
        if (children == null) {
            return 0;
        }
        int result = 0;
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File child = new File(root, element);
            if (child.isDirectory()) {
                result += this.countChildren(child);
            }
            ++result;
            ++n2;
        }
        return result;
    }

    public int countChildren(IFolder root) throws CoreException {
        IResource[] children;
        int total = 0;
        IResource[] iResourceArray = children = root.members();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            total = element.getType() == 1 ? ++total : (total += this.countChildren((IFolder)element));
            ++n2;
        }
        return total;
    }

    protected void createFile(IFileStore target, String content) throws CoreException {
        target.delete(0, null);
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        this.transferData(input, target.openOutputStream(0, null));
        IFileInfo info = target.fetchInfo();
        LocalStoreTest.assertTrue((info.exists() && !info.isDirectory() ? 1 : 0) != 0);
    }

    protected void createIOFile(File target, String content) throws IOException {
        target.delete();
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        this.transferData(input, new FileOutputStream(target));
        LocalStoreTest.assertTrue((target.exists() && !target.isDirectory() ? 1 : 0) != 0);
    }

    protected void createNode(IFileStore node) throws CoreException {
        char type = node.getName().charAt(0);
        if (type == 'd') {
            node.mkdir(0, null);
        } else {
            InputStream input = this.getRandomContents();
            OutputStream output = node.openOutputStream(0, null);
            this.transferData(input, output);
        }
    }

    protected void createTree(IFileStore[] tree) throws CoreException {
        IFileStore[] iFileStoreArray = tree;
        int n = tree.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore element = iFileStoreArray[n2];
            this.createNode(element);
            ++n2;
        }
    }

    protected byte[] getBigContents(int size) {
        return this.getBigString(size).getBytes();
    }

    protected String getBigString(int size) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < size) {
            sb.append(this.getRandomString());
        }
        return sb.toString();
    }

    public FileSystemResourceManager getLocalManager() {
        return ((Workspace)LocalStoreTest.getWorkspace()).getFileSystemManager();
    }

    protected IFileStore[] getTree(IFileStore root) {
        return this.getTree(root, this.getTreeElements());
    }

    protected IFileStore[] getTree(IFileStore root, String[] elements) {
        IFileStore[] tree = new IFileStore[elements.length];
        int i = 0;
        while (i < elements.length) {
            tree[i] = root.getChild(elements[i]);
            ++i;
        }
        return tree;
    }

    protected String[] getTreeElements() {
        String[] tree;
        tree = new String[]{"d-folder", String.valueOf(tree[0]) + File.separator + "d-subfolder", String.valueOf(tree[0]) + File.separator + "f-file", String.valueOf(tree[1]) + File.separator + "f-anotherFile", String.valueOf(tree[1]) + File.separator + "d-subfolder", "d-1", "d-2", "f-3", "f-4", "f-5"};
        return tree;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.projectNames = new String[numberOfProjects];
        this.projects = new IProject[numberOfProjects];
        LocalStoreTest.getWorkspace().run(monitor -> {
            int i = 0;
            while (i < this.projectNames.length) {
                this.projectNames[i] = "Project" + i;
                this.projects[i] = LocalStoreTest.getWorkspace().getRoot().getProject(this.projectNames[i]);
                this.projects[i].create(null);
                this.projects[i].open(null);
                ++i;
            }
        }, null);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void transferDataWithoutCloseStreams(InputStream input, OutputStream output) {
        try {
            int c = 0;
            while ((c = input.read()) != -1) {
                output.write(c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LocalStoreTest.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    protected boolean verifyNode(IFileStore node) {
        char type = node.getName().charAt(0);
        return type == 'd' == node.fetchInfo().isDirectory();
    }

    protected boolean verifyTree(IFileStore[] tree) {
        int i = 0;
        while (i < tree.length) {
            if (!this.verifyNode(tree[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

