/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.PrefixPool;
import org.eclipse.core.tests.harness.CoreTest;

public class PrefixPoolTest
extends CoreTest {
    public static Test suite() {
        return new TestSuite(PrefixPoolTest.class);
    }

    public PrefixPoolTest(String name) {
        super(name);
    }

    public void testIllegalCapacity() {
        boolean exceptionOK = true;
        try {
            new PrefixPool(0);
            exceptionOK = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        PrefixPoolTest.assertTrue((boolean)exceptionOK);
        try {
            new PrefixPool(-1);
            exceptionOK = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        PrefixPoolTest.assertTrue((boolean)exceptionOK);
    }

    public void testPrefixPool() {
        PrefixPool p = new PrefixPool(1);
        PrefixPoolTest.assertFalse((boolean)p.containsAsPrefix(""));
        PrefixPoolTest.assertFalse((boolean)p.containsAsPrefix("/a"));
        PrefixPoolTest.assertFalse((boolean)p.hasPrefixOf("/a"));
        boolean rv = p.insertShorter("/a/");
        PrefixPoolTest.assertFalse((boolean)rv);
        p.insertLonger("/a/b/");
        PrefixPoolTest.assertEquals((int)1, (int)p.size());
        p.insertLonger("/A/");
        PrefixPoolTest.assertEquals((int)2, (int)p.size());
        p.insertLonger("/");
        PrefixPoolTest.assertEquals((int)2, (int)p.size());
        PrefixPoolTest.assertFalse((boolean)p.hasPrefixOf("/c"));
        rv = p.insertShorter("/a/b/c/");
        PrefixPoolTest.assertFalse((boolean)rv);
        PrefixPoolTest.assertEquals((int)2, (int)p.size());
        p.insertLonger("/a/B/c/");
        PrefixPoolTest.assertEquals((int)3, (int)p.size());
        p.insertShorter("/a/B/");
        PrefixPoolTest.assertEquals((int)3, (int)p.size());
        PrefixPoolTest.assertTrue((boolean)p.hasPrefixOf("/a/B/"));
        PrefixPoolTest.assertTrue((boolean)p.hasPrefixOf("/a/b/c/d/"));
        PrefixPoolTest.assertFalse((boolean)p.hasPrefixOf("/"));
        PrefixPoolTest.assertTrue((boolean)p.containsAsPrefix("/a/B"));
        PrefixPoolTest.assertTrue((boolean)p.containsAsPrefix("/a/b/"));
        PrefixPoolTest.assertTrue((boolean)p.containsAsPrefix(""));
        PrefixPoolTest.assertFalse((boolean)p.containsAsPrefix("/a/b//"));
        PrefixPoolTest.assertFalse((boolean)p.containsAsPrefix("/A/B/"));
        PrefixPoolTest.assertEquals((int)3, (int)p.size());
        p.clear();
        PrefixPoolTest.assertEquals((int)0, (int)p.size());
        PrefixPoolTest.assertFalse((boolean)p.hasPrefixOf(""));
        PrefixPoolTest.assertFalse((boolean)p.containsAsPrefix(""));
    }
}

