/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.SafeFileInputStream;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class SafeFileInputOutputStreamTest
extends ResourceTest {
    protected File temp;

    public SafeFileInputOutputStreamTest() {
    }

    public SafeFileInputOutputStreamTest(String name) {
        super(name);
    }

    public SafeFileOutputStream createSafeStream(File target, String errorCode) {
        return this.createSafeStream(target.getAbsolutePath(), null, errorCode);
    }

    public SafeFileOutputStream createSafeStream(String targetPath, String tempFilePath, String errorCode) {
        try {
            return new SafeFileOutputStream(targetPath, tempFilePath);
        }
        catch (IOException e) {
            SafeFileInputOutputStreamTest.fail((String)errorCode, (Throwable)e);
            return null;
        }
    }

    public InputStream getContents(File target, String errorCode) {
        try {
            return new SafeFileInputStream(target);
        }
        catch (IOException e) {
            SafeFileInputOutputStreamTest.fail((String)errorCode, (Throwable)e);
            return null;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IPath location = this.getRandomLocation();
        this.temp = location.append("temp").toFile();
        this.temp.mkdirs();
        SafeFileInputOutputStreamTest.assertTrue((String)"could not create temp directory", (boolean)this.temp.isDirectory());
    }

    public static Test suite() {
        return new TestSuite(SafeFileInputOutputStreamTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        Workspace.clear((File)this.temp.getParentFile());
        super.tearDown();
    }

    public void testSafeFileInputStream() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeFileInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        Path parentLocation = new Path(target.getParentFile().getAbsolutePath());
        IPath tempLocation = parentLocation.append(String.valueOf(target.getName()) + ".backup");
        SafeFileOutputStream safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString(), "2.0");
        File tempFile = tempLocation.toFile();
        String contents = this.getRandomString();
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString(), "4.0");
        tempFile = tempLocation.toFile();
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        SafeFileInputOutputStreamTest.assertTrue((String)"5.0", (boolean)target.exists());
        SafeFileInputOutputStreamTest.assertTrue((String)"5.1", (!tempFile.exists() ? 1 : 0) != 0);
        try {
            SafeFileInputStream diskContents = new SafeFileInputStream(tempLocation.toOSString(), target.getAbsolutePath());
            SafeFileInputOutputStreamTest.assertTrue((String)"5.2", (boolean)this.compareContent((InputStream)diskContents, this.getContents(contents)));
        }
        catch (IOException e) {
            SafeFileInputOutputStreamTest.fail((String)"5.3", (Throwable)e);
        }
        Workspace.clear((File)target);
    }

    public void testSimple() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeFileInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        SafeFileOutputStream safeStream = this.createSafeStream(target, "1.0");
        String contents = this.getRandomString();
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        InputStream diskContents = this.getContents(target, "1.2");
        SafeFileInputOutputStreamTest.assertTrue((String)"1.3", (boolean)this.compareContent(diskContents, this.getContents(contents)));
        contents = this.getRandomString();
        safeStream = this.createSafeStream(target, "2.0");
        File tempFile = new File(safeStream.getTempFilePath());
        SafeFileInputOutputStreamTest.assertTrue((String)"2.0", (boolean)tempFile.exists());
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        diskContents = this.getContents(target, "3.1");
        SafeFileInputOutputStreamTest.assertTrue((String)"3.2", (boolean)this.compareContent(diskContents, this.getContents(contents)));
        SafeFileInputOutputStreamTest.assertTrue((String)"3.3", (!tempFile.exists() ? 1 : 0) != 0);
        Workspace.clear((File)target);
    }

    public void testSpecifiedTempFile() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeFileInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        Path parentLocation = new Path(target.getParentFile().getAbsolutePath());
        IPath tempLocation = parentLocation.append(String.valueOf(target.getName()) + ".backup");
        SafeFileOutputStream safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString(), "2.0");
        File tempFile = tempLocation.toFile();
        SafeFileInputOutputStreamTest.assertTrue((String)"2.1", (!tempFile.exists() ? 1 : 0) != 0);
        String contents = this.getRandomString();
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        InputStream diskContents = this.getContents(target, "3.1");
        SafeFileInputOutputStreamTest.assertTrue((String)"3.2", (boolean)this.compareContent(diskContents, this.getContents(contents)));
        SafeFileInputOutputStreamTest.assertTrue((String)"3.3", (!tempFile.exists() ? 1 : 0) != 0);
        safeStream = this.createSafeStream(target.getAbsolutePath(), tempLocation.toOSString(), "4.0");
        tempFile = tempLocation.toFile();
        SafeFileInputOutputStreamTest.assertTrue((String)"4.1", (boolean)tempFile.exists());
        contents = this.getRandomString();
        SafeFileInputOutputStreamTest.transferStreams(this.getContents(contents), (OutputStream)safeStream, target.getAbsolutePath(), null);
        diskContents = this.getContents(target, "5.1");
        SafeFileInputOutputStreamTest.assertTrue((String)"5.2", (boolean)this.compareContent(diskContents, this.getContents(contents)));
        SafeFileInputOutputStreamTest.assertTrue((String)"5.3", (!tempFile.exists() ? 1 : 0) != 0);
        Workspace.clear((File)target);
    }
}

