/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.properties;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class PropertyManagerTest
extends LocalStoreTest {
    public static Test suite() {
        return new TestSuite(PropertyManagerTest.class);
    }

    public PropertyManagerTest() {
        super(null);
    }

    public PropertyManagerTest(String name) {
        super(name);
    }

    private void createProperties(IFile target, QualifiedName[] names, String[] values) {
        int i = 0;
        while (i < names.length) {
            names[i] = new QualifiedName("org.eclipse.core.tests", "prop" + i);
            values[i] = "property value" + i;
            ++i;
        }
        i = 0;
        while (i < names.length) {
            try {
                target.setPersistentProperty(names[i], values[i]);
            }
            catch (CoreException e) {
                PropertyManagerTest.fail((String)("1." + i), (Throwable)e);
            }
            ++i;
        }
    }

    private Thread[] createThreads(IFile target, QualifiedName[] names, String[] values, CoreException[] errorPointer) {
        Thread[] threads = new Thread[3];
        int j = 0;
        while (j < 3) {
            String id = "GetSetProperty" + j;
            threads[j] = new Thread(() -> {
                block2: {
                    try {
                        this.doGetSetProperties(target, id, names, values);
                    }
                    catch (CoreException e) {
                        if (!target.exists()) break block2;
                        e.printStackTrace();
                        coreExceptionArray[0] = e;
                        return;
                    }
                }
            }, id);
            threads[j].start();
            ++j;
        }
        return threads;
    }

    protected void doGetSetProperties(IFile target, String threadID, QualifiedName[] names, String[] values) throws CoreException {
        int N = names.length;
        int j = 0;
        while (j < 10) {
            int i = 0;
            while (i < N) {
                target.getPersistentProperty(names[i]);
                ++i;
            }
            i = 0;
            while (i < N) {
                target.setPersistentProperty(names[i], values[i]);
                ++i;
            }
            i = 0;
            while (i < N) {
                target.getPersistentProperty(names[i]);
                ++i;
            }
            ++j;
        }
    }

    private void join(Thread[] threads) {
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                PropertyManagerTest.fail((String)"#join", (Throwable)e);
            }
            ++n2;
        }
    }

    public void testConcurrentAccess() {
        IFile target = this.projects[0].getFile("target");
        try {
            target.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.0", (Throwable)e);
        }
        QualifiedName[] names = new QualifiedName[50];
        String[] values = new String[50];
        this.createProperties(target, names, values);
        CoreException[] errorPointer = new CoreException[1];
        Thread[] threads = this.createThreads(target, names, values, errorPointer);
        this.join(threads);
        if (errorPointer[0] != null) {
            PropertyManagerTest.fail((String)"2.0", (Throwable)errorPointer[0]);
        }
        try {
            target.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testConcurrentDelete() {
        IFile target = this.projects[0].getFile("target");
        int i = 0;
        while (i < 8) {
            this.ensureExistsInWorkspace((IResource)this.projects[0], true);
            this.ensureExistsInWorkspace((IResource)target, true);
            QualifiedName[] names = new QualifiedName[50];
            String[] values = new String[50];
            this.createProperties(target, names, values);
            CoreException[] errorPointer = new CoreException[1];
            Thread[] threads = this.createThreads(target, names, values, errorPointer);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                PropertyManagerTest.fail((String)"1.98", (Throwable)e);
            }
            try {
                target.getProject().delete(0, this.getMonitor());
            }
            catch (CoreException e) {
                PropertyManagerTest.fail((String)("1.99." + i), (Throwable)e);
            }
            this.join(threads);
            if (errorPointer[0] != null) {
                PropertyManagerTest.fail((String)("2.0." + i), (Throwable)errorPointer[0]);
            }
            ++i;
        }
        try {
            target.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testCopy() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IProject source = this.projects[0];
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        IProject destination = this.projects[1];
        IFolder destFolder = destination.getFolder(sourceFolder.getName());
        IFile destFile = destFolder.getFile(sourceFile.getName());
        QualifiedName propName = new QualifiedName("test", "prop");
        String propValue = "this is the property value";
        this.ensureExistsInWorkspace(new IResource[]{source, sourceFolder, sourceFile}, true);
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        PropertyManagerTest.assertNotNull((String)"1.1", (Object)manager.getProperty((IResource)source, propName));
        PropertyManagerTest.assertTrue((String)"1.2", (boolean)manager.getProperty((IResource)source, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"1.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        PropertyManagerTest.assertTrue((String)"1.4", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"1.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        PropertyManagerTest.assertTrue((String)"1.6", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.copy((IResource)source, (IResource)destination, 2);
        PropertyManagerTest.assertNotNull((String)"1.7", (Object)manager.getProperty((IResource)destination, propName));
        PropertyManagerTest.assertTrue((String)"1.8", (boolean)manager.getProperty((IResource)destination, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"1.9", (Object)manager.getProperty((IResource)destFolder, propName));
        PropertyManagerTest.assertTrue((String)"1.10", (boolean)manager.getProperty((IResource)destFolder, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"1.11", (Object)manager.getProperty((IResource)destFile, propName));
        PropertyManagerTest.assertTrue((String)"1.12", (boolean)manager.getProperty((IResource)destFile, propName).equals(propValue));
        manager.deleteProperties((IResource)source, 2);
        manager.deleteProperties((IResource)destination, 2);
        PropertyManagerTest.assertNull((String)"2.0", (Object)manager.getProperty((IResource)source, propName));
        PropertyManagerTest.assertNull((String)"2.1", (Object)manager.getProperty((IResource)sourceFolder, propName));
        PropertyManagerTest.assertNull((String)"2.2", (Object)manager.getProperty((IResource)sourceFile, propName));
        PropertyManagerTest.assertNull((String)"2.3", (Object)manager.getProperty((IResource)destination, propName));
        PropertyManagerTest.assertNull((String)"2.4", (Object)manager.getProperty((IResource)destFolder, propName));
        PropertyManagerTest.assertNull((String)"2.5", (Object)manager.getProperty((IResource)destFile, propName));
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        PropertyManagerTest.assertNotNull((String)"2.6", (Object)manager.getProperty((IResource)sourceFolder, propName));
        PropertyManagerTest.assertTrue((String)"2.7", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"2.8", (Object)manager.getProperty((IResource)sourceFile, propName));
        PropertyManagerTest.assertTrue((String)"2.9", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.copy((IResource)sourceFolder, (IResource)destFolder, 2);
        PropertyManagerTest.assertNotNull((String)"2.10", (Object)manager.getProperty((IResource)destFolder, propName));
        PropertyManagerTest.assertTrue((String)"2.11", (boolean)manager.getProperty((IResource)destFolder, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"2.12", (Object)manager.getProperty((IResource)destFile, propName));
        PropertyManagerTest.assertTrue((String)"2.13", (boolean)manager.getProperty((IResource)destFile, propName).equals(propValue));
        String newPropValue = "change property value";
        manager.setProperty((IResource)source, propName, newPropValue);
        PropertyManagerTest.assertTrue((String)"2.0", (boolean)manager.getProperty((IResource)source, propName).equals(newPropValue));
        manager.copy((IResource)source, (IResource)destination, 2);
        PropertyManagerTest.assertTrue((String)"2.1", (boolean)manager.getProperty((IResource)destination, propName).equals(newPropValue));
    }

    public void testDeleteProperties() throws Throwable {
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IFile target = this.projects[0].getFile("target");
        this.ensureExistsInWorkspace((IResource)target, true);
        QualifiedName propName = new QualifiedName("eclipse", "prop");
        String propValue = "this is the property value";
        manager.setProperty((IResource)target, propName, propValue);
        PropertyManagerTest.assertTrue((String)"1.1", (boolean)manager.getProperty((IResource)target, propName).equals(propValue));
        manager.deleteProperties((IResource)target, 2);
        PropertyManagerTest.assertTrue((String)"1.3", (manager.getProperty((IResource)target, propName) == null ? 1 : 0) != 0);
        IProject source = this.projects[0];
        IFolder sourceFolder = source.getFolder("myfolder");
        IFile sourceFile = sourceFolder.getFile("myfile.txt");
        propName = new QualifiedName("test", "prop");
        propValue = "this is the property value";
        this.ensureExistsInWorkspace(new IResource[]{source, sourceFolder, sourceFile}, true);
        manager.setProperty((IResource)source, propName, propValue);
        manager.setProperty((IResource)sourceFolder, propName, propValue);
        manager.setProperty((IResource)sourceFile, propName, propValue);
        PropertyManagerTest.assertNotNull((String)"2.1", (Object)manager.getProperty((IResource)source, propName));
        PropertyManagerTest.assertTrue((String)"2.2", (boolean)manager.getProperty((IResource)source, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"2.3", (Object)manager.getProperty((IResource)sourceFolder, propName));
        PropertyManagerTest.assertTrue((String)"2.4", (boolean)manager.getProperty((IResource)sourceFolder, propName).equals(propValue));
        PropertyManagerTest.assertNotNull((String)"2.5", (Object)manager.getProperty((IResource)sourceFile, propName));
        PropertyManagerTest.assertTrue((String)"2.6", (boolean)manager.getProperty((IResource)sourceFile, propName).equals(propValue));
        manager.deleteProperties((IResource)source, 2);
        PropertyManagerTest.assertNull((String)"3.1", (Object)manager.getProperty((IResource)source, propName));
        PropertyManagerTest.assertNull((String)"3.2", (Object)manager.getProperty((IResource)sourceFolder, propName));
        PropertyManagerTest.assertNull((String)"3.3", (Object)manager.getProperty((IResource)sourceFile, propName));
    }

    public void testFileRename() {
        IWorkspaceRoot root = PropertyManagerTest.getWorkspace().getRoot();
        IProject project = root.getProject("proj");
        IFolder folder = project.getFolder("folder");
        IFile file1a = folder.getFile("file1");
        this.ensureExistsInWorkspace((IResource)file1a, true);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        try {
            file1a.setPersistentProperty(key, "value");
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.5", (Throwable)e);
        }
        try {
            file1a.move((IPath)new Path("file2"), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.6", (Throwable)e);
        }
        IFile file1b = folder.getFile("file1");
        this.ensureExistsInWorkspace((IResource)file1b, true);
        String value = null;
        try {
            value = file1b.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.8", (Throwable)e);
        }
        PropertyManagerTest.assertNull((String)"1.0", (Object)value);
        file1a = folder.getFile("file2");
        try {
            value = file1a.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"1.9", (Throwable)e);
        }
        PropertyManagerTest.assertEquals((String)"2.0", (String)"value", (String)value);
    }

    public void testFolderRename() {
        IWorkspaceRoot root = PropertyManagerTest.getWorkspace().getRoot();
        IProject project = root.getProject("proj");
        IFolder folder1a = project.getFolder("folder1");
        this.ensureExistsInWorkspace((IResource)folder1a, true);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        try {
            folder1a.setPersistentProperty(key, "value");
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.5", (Throwable)e);
        }
        try {
            folder1a.move((IPath)new Path("folder2"), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.6", (Throwable)e);
        }
        IFolder folder1b = project.getFolder("folder1");
        this.ensureExistsInWorkspace((IResource)folder1b, true);
        String value = null;
        try {
            value = folder1b.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.8", (Throwable)e);
        }
        PropertyManagerTest.assertNull((String)"1.0", (Object)value);
        folder1a = project.getFolder("folder2");
        try {
            value = folder1a.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"1.9", (Throwable)e);
        }
        PropertyManagerTest.assertEquals((String)"2.0", (String)"value", (String)value);
    }

    public void testLargeProperty() {
        IFile target = this.projects[0].getFile("target");
        try {
            target.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.0", (Throwable)e);
        }
        QualifiedName name = new QualifiedName("stressTest", "prop");
        StringBuilder valueBuf = new StringBuilder(10000);
        int i = 0;
        while (i < 10000) {
            valueBuf.append("a");
            ++i;
        }
        String value = valueBuf.toString();
        try {
            target.setPersistentProperty(name, value);
            PropertyManagerTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            target.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testProjectRename() {
        IWorkspaceRoot root = PropertyManagerTest.getWorkspace().getRoot();
        IProject project1a = root.getProject("proj1");
        this.ensureExistsInWorkspace((IResource)project1a, true);
        QualifiedName key = new QualifiedName("org.eclipse.core.tests.resources", "key");
        try {
            project1a.setPersistentProperty(key, "value");
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.5", (Throwable)e);
        }
        try {
            project1a.move((IPath)new Path("proj2"), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.6", (Throwable)e);
        }
        IProject project1b = root.getProject("proj1");
        this.ensureExistsInWorkspace((IResource)project1b, true);
        String value = null;
        try {
            value = project1b.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.8", (Throwable)e);
        }
        PropertyManagerTest.assertNull((String)"1.0", (Object)value);
        project1a = root.getProject("proj2");
        try {
            value = project1a.getPersistentProperty(key);
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"1.9", (Throwable)e);
        }
        PropertyManagerTest.assertEquals((String)"2.0", (String)"value", (String)value);
    }

    public void testProperties() throws Throwable {
        IProgressMonitor monitor = null;
        PropertyManager2 manager = new PropertyManager2((Workspace)ResourcesPlugin.getWorkspace());
        IFile target = this.projects[0].getFile("target");
        target.create(null, false, monitor);
        QualifiedName propName1 = new QualifiedName("org.eclipse.core.tests", "prop1");
        QualifiedName propName2 = new QualifiedName("org.eclipse.core.tests", "prop2");
        QualifiedName propName3 = new QualifiedName("org.eclipse.core.tests", "prop3");
        String propValue1 = "this is the property value1";
        String propValue2 = "this is the property value2";
        String propValue3 = "this is the property value3";
        Vector<StoredProperty> props = new Vector<StoredProperty>(3);
        props.addElement(new StoredProperty(propName1, propValue1));
        props.addElement(new StoredProperty(propName2, propValue2));
        props.addElement(new StoredProperty(propName3, propValue3));
        for (StoredProperty prop : props) {
            manager.setProperty((IResource)target, prop.getName(), prop.getStringValue());
            PropertyManagerTest.assertEquals((String)("1.0." + prop.getName()), (String)prop.getStringValue(), (String)manager.getProperty((IResource)target, prop.getName()));
        }
        for (StoredProperty prop : props) {
            manager.setProperty((IResource)target, prop.getName(), null);
            PropertyManagerTest.assertEquals((String)("2.0." + prop.getName()), null, (String)manager.getProperty((IResource)target, prop.getName()));
        }
        PropertyManagerTest.assertEquals((String)"3.0", (int)0, (int)manager.getProperties((IResource)target).size());
        manager.deleteProperties((IResource)target, 2);
        target.delete(false, monitor);
    }

    public void testSimpleUpdate() {
        IFile target = this.projects[0].getFile("target");
        try {
            target.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"0.0", (Throwable)e);
        }
        int N = 3;
        QualifiedName[] names = new QualifiedName[3];
        String[] values = new String[N];
        int i = 0;
        while (i < N) {
            names[i] = new QualifiedName("org.eclipse.core.tests", "prop" + i);
            values[i] = "property value" + i;
            ++i;
        }
        i = 0;
        while (i < N) {
            try {
                target.setPersistentProperty(names[i], values[i]);
            }
            catch (CoreException e) {
                PropertyManagerTest.fail((String)("1." + i), (Throwable)e);
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            try {
                PropertyManagerTest.assertTrue((String)"2.0", (boolean)target.getPersistentProperty(names[i]).equals(values[i]));
            }
            catch (CoreException e) {
                PropertyManagerTest.fail((String)("3." + i), (Throwable)e);
            }
            ++i;
        }
        int j = 0;
        while (j < 20) {
            int i2 = 0;
            while (i2 < N) {
                try {
                    values[i2] = String.valueOf(values[i2]) + " - changed";
                    target.setPersistentProperty(names[i2], values[i2]);
                }
                catch (CoreException e) {
                    PropertyManagerTest.fail((String)("4." + i2), (Throwable)e);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < N) {
                try {
                    PropertyManagerTest.assertTrue((String)"5.0", (boolean)target.getPersistentProperty(names[i2]).equals(values[i2]));
                }
                catch (CoreException e) {
                    PropertyManagerTest.fail((String)("6." + i2), (Throwable)e);
                }
                ++i2;
            }
            ++j;
        }
        try {
            target.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            PropertyManagerTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public class StoredProperty {
        protected QualifiedName name = null;
        protected String value = null;

        public StoredProperty(QualifiedName name, String value) {
            this.name = name;
            this.value = value;
        }

        public QualifiedName getName() {
            return this.name;
        }

        public String getStringValue() {
            return this.value;
        }
    }
}

