/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ModelObjectWriter;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspaceDescriptionReader;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.tests.resources.ResourceTest;
import org.xml.sax.InputSource;

public class ModelObjectReaderWriterTest
extends ResourceTest {
    static final IPath LONG_LOCATION = new Path("/eclipse/dev/i0218/eclipse/pffds/fds//fds///fdsfsdfsd///fdsfdsf/fsdfsdfsd/lugi/dsds/fsd//f/ffdsfdsf/fsdfdsfsd/fds//fdsfdsfdsf/fdsfdsfds/fdsfdsfdsf/fdsfdsfdsds/ns/org.eclipse.help.ui_2.1.0/contexts.xml").setDevice(ModelObjectReaderWriterTest.isWindows() ? "D:" : null);
    static final URI LONG_LOCATION_URI = LONG_LOCATION.toFile().toURI();
    private static final String PATH_STRING = new Path("/abc/def").setDevice(ModelObjectReaderWriterTest.isWindows() ? "D:" : null).toString();

    public static Test suite() {
        return new TestSuite(ModelObjectReaderWriterTest.class);
    }

    public ModelObjectReaderWriterTest() {
    }

    public ModelObjectReaderWriterTest(String name) {
        super(name);
    }

    private HashMap<String, ProjectDescription> buildBaselineDescriptors() {
        HashMap<String, ProjectDescription> result = new HashMap<String, ProjectDescription>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ProjectDescription desc = new ProjectDescription();
        desc.setName("abc.project");
        ICommand[] commands = new ICommand[]{desc.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        desc.setBuildSpec(commands);
        String[] natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        HashMap<IPath, LinkDescription> linkMap = new HashMap<IPath, LinkDescription>();
        LinkDescription link = this.createLinkDescription("newLink", 2, "d:/abc/def");
        linkMap.put(link.getProjectRelativePath(), link);
        desc.setLinkDescriptions(linkMap);
        result.put(desc.getName(), desc);
        commands = null;
        natures = null;
        link = null;
        linkMap = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("def.project");
        commands = new ICommand[]{desc.newCommand()};
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        linkMap = new HashMap();
        link = this.createLinkDescription("newLink", 2, "d:/abc/def");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link2", 2, "d:/abc");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link3", 2, "d:/abc/def/ghi");
        linkMap.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("link4", 1, "d:/abc/def/afile.txt");
        linkMap.put(link.getProjectRelativePath(), link);
        desc.setLinkDescriptions(linkMap);
        result.put(desc.getName(), desc);
        commands = null;
        natures = null;
        link = null;
        linkMap = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("org.apache.lucene.project");
        Project[] refProjects = new Project[]{root.getProject("org.eclipse.core.boot"), root.getProject("org.eclipse.core.runtime")};
        desc.setReferencedProjects((IProject[])refProjects);
        commands = new ICommand[3];
        commands[0] = desc.newCommand();
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        commands[1] = desc.newCommand();
        commands[1].setBuilderName("org.eclipse.pde.ManifestBuilder");
        commands[2] = desc.newCommand();
        commands[2].setBuilderName("org.eclipse.pde.SchemaBuilder");
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"};
        desc.setNatureIds(natures);
        result.put(desc.getName(), desc);
        refProjects = null;
        commands = null;
        natures = null;
        desc = null;
        desc = new ProjectDescription();
        desc.setName("org.eclipse.ant.core.project");
        refProjects = new Project[]{root.getProject("org.apache.ant"), root.getProject("org.apache.xerces"), root.getProject("org.eclipse.core.boot"), root.getProject("org.eclipse.core.runtime")};
        desc.setReferencedProjects((IProject[])refProjects);
        commands = new ICommand[2];
        commands[0] = desc.newCommand();
        commands[0].setBuilderName("org.eclipse.jdt.core.javabuilder");
        commands[1] = desc.newCommand();
        commands[1].setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        HashMap<String, String> argMap = new HashMap<String, String>();
        argMap.put("!{tool_show_log}", "true");
        argMap.put("!{tool_refresh}", "${none}");
        argMap.put("!{tool_name}", "org.eclipse.ant.core extra builder");
        argMap.put("!{tool_dir}", "");
        argMap.put("!{tool_args}", "-DbuildType=${build_type}");
        argMap.put("!{tool_loc}", "${workspace_loc:/org.eclipse.ant.core/scripts/buildExtraJAR.xml}");
        argMap.put("!{tool_type}", "org.eclipse.ui.externaltools.type.ant");
        commands[1].setArguments(argMap);
        desc.setBuildSpec(commands);
        natures = new String[]{"org.eclipse.jdt.core.javanature"};
        desc.setNatureIds(natures);
        result.put(desc.getName(), desc);
        refProjects = null;
        commands = null;
        natures = null;
        desc = null;
        return result;
    }

    private void compareBuildSpecs(int errorTag, ICommand[] commands, ICommand[] commands2) {
        ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".2.0"), (int)commands.length, (int)commands2.length);
        int i = 0;
        while (i < commands.length) {
            ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".2." + (i + 1) + "0"), (boolean)commands[i].getBuilderName().equals(commands2[i].getBuilderName()));
            Map args = commands[i].getArguments();
            Map args2 = commands2[i].getArguments();
            ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".2." + (i + 1) + "0"), (int)args.size(), (int)args2.size());
            int x = 1;
            for (Map.Entry entry : args.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                String value2 = (String)args2.get(key);
                if (value == null) {
                    ModelObjectReaderWriterTest.assertNull((String)(String.valueOf(errorTag) + ".2." + (i + 1) + x), (Object)value2);
                } else {
                    ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".3." + (i + 1) + x), (boolean)((String)args.get(key)).equals(args2.get(key)));
                }
                ++x;
            }
            ++i;
        }
    }

    private void compareLinks(int errorTag, HashMap<IPath, LinkDescription> links, HashMap<IPath, LinkDescription> links2) {
        if (links == null) {
            ModelObjectReaderWriterTest.assertNull((String)(String.valueOf(errorTag) + ".4.0"), links2);
            return;
        }
        ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".4.01"), (int)links.size(), (int)links2.size());
        int x = 1;
        for (Map.Entry<IPath, LinkDescription> entry : links.entrySet()) {
            IPath key = entry.getKey();
            LinkDescription value = entry.getValue();
            LinkDescription value2 = links2.get(key);
            ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".4." + x), (boolean)value.getProjectRelativePath().equals((Object)value2.getProjectRelativePath()));
            ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".5." + x), (int)value.getType(), (int)value2.getType());
            ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".6." + x), (Object)value.getLocationURI(), (Object)value2.getLocationURI());
            ++x;
        }
    }

    private void compareNatures(int errorTag, String[] natures, String[] natures2) {
        ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".3.0"), (int)natures.length, (int)natures2.length);
        int i = 0;
        while (i < natures.length) {
            ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".3." + (i + 1)), (boolean)natures[i].equals(natures2[i]));
            ++i;
        }
    }

    private void compareProjectDescriptions(int errorTag, ProjectDescription description, ProjectDescription description2) {
        ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".0"), (boolean)description.getName().equals(description2.getName()));
        String comment = description.getComment();
        if (comment == null) {
            ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".1"), (int)0, (int)description2.getComment().length());
        } else {
            ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".2"), (boolean)description.getComment().equals(description2.getComment()));
        }
        IProject[] projects = description.getReferencedProjects();
        IProject[] projects2 = description2.getReferencedProjects();
        this.compareProjects(errorTag, projects, projects2);
        ICommand[] commands = description.getBuildSpec();
        ICommand[] commands2 = description2.getBuildSpec();
        this.compareBuildSpecs(errorTag, commands, commands2);
        String[] natures = description.getNatureIds();
        String[] natures2 = description2.getNatureIds();
        this.compareNatures(errorTag, natures, natures2);
        HashMap links = description.getLinks();
        HashMap links2 = description2.getLinks();
        this.compareLinks(errorTag, links, links2);
    }

    private void compareProjects(int errorTag, IProject[] projects, IProject[] projects2) {
        ModelObjectReaderWriterTest.assertEquals((String)(String.valueOf(errorTag) + ".1.0"), (int)projects.length, (int)projects2.length);
        int i = 0;
        while (i < projects.length) {
            ModelObjectReaderWriterTest.assertTrue((String)(String.valueOf(errorTag) + ".1." + (i + 1)), (boolean)projects[i].getName().equals(projects2[i].getName()));
            ++i;
        }
    }

    protected boolean contains(Object key, Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (key.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private LinkDescription createLinkDescription(IPath path, int type, URI location) {
        LinkDescription result = new LinkDescription();
        result.setPath(path);
        result.setType(type);
        result.setLocationURI(location);
        return result;
    }

    private LinkDescription createLinkDescription(String path, int type, String location) {
        return this.createLinkDescription((IPath)new Path(path), type, this.uriFromPortableString(location));
    }

    protected String getInvalidWorkspaceDescription() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workspaceDescription>\n<name>Foo</name>\n<autobuild>Foo</autobuild>\n<snapshotInterval>300Foo000</snapshotInterval>\n<fileStateLongevity>Foo480000</fileStateLongevity>\n<maxFileStateSize>104856Foo</maxFileStateSize>\n<maxFileStates>5Foo0</maxFileStates>\n</workspaceDescription>\n";
    }

    private String getLongDescription() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>org.eclipse.help.ui</name><comment></comment><charset>UTF-8</charset>\t<projects>\t<project>org.eclipse.core.boot</project>\t<project>org.eclipse.core.resources</project>\t<project>org.eclipse.core.runtime</project>\t<project>org.eclipse.help</project>\t<project>org.eclipse.help.appserver</project>\t<project>org.eclipse.search</project>\t<project>org.eclipse.ui</project>\t</projects>\t<buildSpec>\t<buildCommand>\t<name>org.eclipse.jdt.core.javabuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.ManifestBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.SchemaBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t</buildSpec>\t<natures>\t<nature>org.eclipse.jdt.core.javanature</nature>\t<nature>org.eclipse.pde.PluginNature</nature>\t</natures>\t<linkedResources>\t<link>\t<name>contexts.xml</name>\t<type>1</type>\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>doc</name>" + "\t<type>2</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>icons</name>" + "\t<type>2</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>preferences.ini</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>.options</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>plugin.properties</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>plugin.xml</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>about.html</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "\t<link>" + "\t<name>helpworkbench.jar</name>" + "\t<type>1</type>" + "\t<location>" + LONG_LOCATION + "</location>" + "\t</link>" + "</linkedResources>" + "</projectDescription>";
    }

    private String getLongDescriptionURI() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name>org.eclipse.help.ui</name><comment></comment><charset>UTF-8</charset>\t<projects>\t<project>org.eclipse.core.boot</project>\t<project>org.eclipse.core.resources</project>\t<project>org.eclipse.core.runtime</project>\t<project>org.eclipse.help</project>\t<project>org.eclipse.help.appserver</project>\t<project>org.eclipse.search</project>\t<project>org.eclipse.ui</project>\t</projects>\t<buildSpec>\t<buildCommand>\t<name>org.eclipse.jdt.core.javabuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.ManifestBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t<buildCommand>\t<name>org.eclipse.pde.SchemaBuilder</name>\t<arguments>\t</arguments>\t</buildCommand>\t</buildSpec>\t<natures>\t<nature>org.eclipse.jdt.core.javanature</nature>\t<nature>org.eclipse.pde.PluginNature</nature>\t</natures>\t<linkedResources>\t<link>\t<name>contexts.xml</name>\t<type>1</type>\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>doc</name>" + "\t<type>2</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>icons</name>" + "\t<type>2</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>preferences.ini</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>.options</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>plugin.properties</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>plugin.xml</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>about.html</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "\t<link>" + "\t<name>helpworkbench.jar</name>" + "\t<type>1</type>" + "\t<locationURI>" + LONG_LOCATION_URI + "</locationURI>" + "\t</link>" + "</linkedResources>" + "</projectDescription>";
    }

    private ProjectDescription readDescription(IFileStore store) throws CoreException {
        ProjectDescription projectDescription;
        InputStream input = null;
        try {
            input = store.openInputStream(0, this.getMonitor());
            InputSource in = new InputSource(input);
            projectDescription = new ProjectDescriptionReader().read(in);
        }
        catch (Throwable throwable) {
            this.assertClose(input);
            throw throwable;
        }
        this.assertClose(input);
        return projectDescription;
    }

    public void testConsistentWrite() throws Throwable {
        String locationA = this.getTempDir().append("testPath1").toPortableString();
        String locationB = this.getTempDir().append("testPath1").toPortableString();
        String newline = System.getProperty("line.separator");
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<projectDescription>" + newline + "\t<name>MyProjectDescription</name>" + newline + "\t<comment></comment>" + newline + "\t<projects>" + newline + "\t</projects>" + newline + "\t<buildSpec>" + newline + "\t\t<buildCommand>" + newline + "\t\t\t<name>MyCommand</name>" + newline + "\t\t\t<arguments>" + newline + "\t\t\t\t<dictionary>" + newline + "\t\t\t\t\t<key>aA</key>" + newline + "\t\t\t\t\t<value>2 x ARGH!</value>" + newline + "\t\t\t\t</dictionary>" + newline + "\t\t\t\t<dictionary>" + newline + "\t\t\t\t\t<key>b</key>" + newline + "\t\t\t\t\t<value>ARGH!</value>" + newline + "\t\t\t\t</dictionary>" + newline + "\t\t\t</arguments>" + newline + "\t\t</buildCommand>" + newline + "\t</buildSpec>" + newline + "\t<natures>" + newline + "\t</natures>" + newline + "\t<linkedResources>" + newline + "\t\t<link>" + newline + "\t\t\t<name>pathA</name>" + newline + "\t\t\t<type>2</type>" + newline + "\t\t\t<location>" + locationA + "</location>" + newline + "\t\t</link>" + newline + "\t\t<link>" + newline + "\t\t\t<name>pathB</name>" + newline + "\t\t\t<type>2</type>" + newline + "\t\t\t<location>" + locationB + "</location>" + newline + "\t\t</link>" + newline + "\t</linkedResources>" + newline + "</projectDescription>" + newline;
        IFileStore tempStore = this.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(2);
        args.put("b", "ARGH!");
        args.put("aA", "2 x ARGH!");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        description.setBuildSpec(commands);
        HashMap<IPath, LinkDescription> linkDescriptions = new HashMap<IPath, LinkDescription>(2);
        LinkDescription link = this.createLinkDescription("pathB", 2, locationB);
        linkDescriptions.put(link.getProjectRelativePath(), link);
        link = this.createLinkDescription("pathA", 2, locationA);
        linkDescriptions.put(link.getProjectRelativePath(), link);
        description.setLinkDescriptions(linkDescriptions);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new ModelObjectWriter().write((Object)description, (OutputStream)buffer, System.getProperty("line.separator"));
        String result = buffer.toString();
        ModelObjectReaderWriterTest.assertEquals((String)"1.0", (String)expected, (String)result);
    }

    public void testInvalidProjectDescription1() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<homeDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t<nature>org.eclipse.jdt.core.javanature</nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>2</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n" + "\t\t</link>\n" + "\t</linkedResources>\n" + "</homeDescription>";
        IPath root = ModelObjectReaderWriterTest.getWorkspace().getRoot().getLocation();
        IPath location = root.append("ModelObjectReaderWriterTest.txt");
        ProjectDescriptionReader reader = new ProjectDescriptionReader();
        this.ensureDoesNotExistInFileSystem(location.toFile());
        ByteArrayInputStream stream = new ByteArrayInputStream(invalidProjectDescription.getBytes());
        this.createFileInFileSystem(location, (InputStream)stream);
        try {
            ProjectDescription projDesc = reader.read(location);
            ModelObjectReaderWriterTest.assertNull((String)"1.0", (Object)projDesc);
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testInvalidProjectDescription2() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<bogusname>abc</bogusname>\n</projectDescription>";
        IFileStore store = this.getTempStore();
        ByteArrayInputStream stream = new ByteArrayInputStream(invalidProjectDescription.getBytes());
        this.createFileInFileSystem(store, (InputStream)stream);
        ProjectDescription projDesc = this.readDescription(store);
        ModelObjectReaderWriterTest.assertNotNull((String)"2.0", (Object)projDesc);
        ModelObjectReaderWriterTest.assertNull((String)"2.1", (Object)projDesc.getName());
        ModelObjectReaderWriterTest.assertEquals((String)"2.2", (int)0, (int)projDesc.getComment().length());
        ModelObjectReaderWriterTest.assertNull((String)"2.3", (Object)projDesc.getLocationURI());
        this.assertEquals("2.4", new IProject[0], projDesc.getReferencedProjects());
        this.assertEquals("2.5", new String[0], projDesc.getNatureIds());
        this.assertEquals("2.6", new ICommand[0], projDesc.getBuildSpec());
        ModelObjectReaderWriterTest.assertNull((String)"2.7", (Object)projDesc.getLinks());
    }

    public void testInvalidProjectDescription3() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<badBuildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n\t\t\t</arguments>\n\t\t</badBuildCommand>\n\t</buildSpec>\n</projectDescription>";
        IFileStore store = this.getTempStore();
        ByteArrayInputStream stream = new ByteArrayInputStream(invalidProjectDescription.getBytes());
        this.createFileInFileSystem(store, (InputStream)stream);
        ProjectDescription projDesc = this.readDescription(store);
        ModelObjectReaderWriterTest.assertNotNull((String)"3.0", (Object)projDesc);
        ModelObjectReaderWriterTest.assertTrue((String)"3.1", (boolean)projDesc.getName().equals("abc"));
        ModelObjectReaderWriterTest.assertEquals((String)"3.2", (int)0, (int)projDesc.getComment().length());
        ModelObjectReaderWriterTest.assertNull((String)"3.3", (Object)projDesc.getLocationURI());
        this.assertEquals("3.4", new IProject[0], projDesc.getReferencedProjects());
        this.assertEquals("3.5", new String[0], projDesc.getNatureIds());
        this.assertEquals("3.6", new ICommand[0], projDesc.getBuildSpec());
        ModelObjectReaderWriterTest.assertNull((String)"3.7", (Object)projDesc.getLinks());
    }

    public void testInvalidProjectDescription4() throws Throwable {
        String invalidProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t</buildSpec>\n\t<natures>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>foobar</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n" + "\t\t</link>\n" + "\t</linkedResources>\n" + "</projectDescription>";
        IFileStore store = this.getTempStore();
        ByteArrayInputStream stream = new ByteArrayInputStream(invalidProjectDescription.getBytes());
        this.createFileInFileSystem(store, (InputStream)stream);
        ProjectDescription projDesc = this.readDescription(store);
        ModelObjectReaderWriterTest.assertNotNull((String)"3.0", (Object)projDesc);
        ModelObjectReaderWriterTest.assertTrue((String)"3.1", (boolean)projDesc.getName().equals("abc"));
        ModelObjectReaderWriterTest.assertEquals((String)"3.2", (int)0, (int)projDesc.getComment().length());
        ModelObjectReaderWriterTest.assertNull((String)"3.3", (Object)projDesc.getLocationURI());
        this.assertEquals("3.4", new IProject[0], projDesc.getReferencedProjects());
        this.assertEquals("3.5", new String[0], projDesc.getNatureIds());
        this.assertEquals("3.6", new ICommand[0], projDesc.getBuildSpec());
        LinkDescription link = (LinkDescription)projDesc.getLinks().values().iterator().next();
        ModelObjectReaderWriterTest.assertEquals((String)"3.7", (Object)new Path("newLink"), (Object)link.getProjectRelativePath());
        ModelObjectReaderWriterTest.assertEquals((String)"3.8", (String)PATH_STRING, (String)URIUtil.toPath((URI)link.getLocationURI()).toString());
    }

    public void testInvalidWorkspaceDescription() {
        WorkspaceDescriptionReader reader = new WorkspaceDescriptionReader();
        IPath root = ModelObjectReaderWriterTest.getWorkspace().getRoot().getLocation();
        IPath location = root.append("ModelObjectWriterTest2.pbs");
        try {
            FileWriter writer = new FileWriter(location.toFile());
            writer.write(this.getInvalidWorkspaceDescription());
            writer.close();
        }
        catch (IOException e) {
            ModelObjectReaderWriterTest.fail((String)"1.91", (Throwable)e);
        }
        try {
            Preferences prefs = ResourcesPlugin.getPlugin().getPluginPreferences();
            FileInputStream input = null;
            try {
                input = new FileInputStream(location.toFile());
            }
            catch (FileNotFoundException e) {
                ModelObjectReaderWriterTest.fail((String)"1.99", (Throwable)e);
            }
            WorkspaceDescription desc2 = (WorkspaceDescription)reader.read((InputStream)input);
            ModelObjectReaderWriterTest.assertEquals((String)"1.2", (boolean)prefs.getDefaultBoolean("description.autobuilding"), (boolean)desc2.isAutoBuilding());
            ModelObjectReaderWriterTest.assertEquals((String)"1.3", (long)prefs.getDefaultLong("delta.expiration"), (long)desc2.getDeltaExpiration());
            ModelObjectReaderWriterTest.assertEquals((String)"1.4", (boolean)prefs.getDefaultBoolean("description.applyfilestatepolicy"), (boolean)desc2.isApplyFileStatePolicy());
            ModelObjectReaderWriterTest.assertEquals((String)"1.5", (long)prefs.getDefaultLong("description.filestatelongevity"), (long)desc2.getFileStateLongevity());
            ModelObjectReaderWriterTest.assertEquals((String)"1.6", (int)prefs.getDefaultInt("description.maxfilestates"), (int)desc2.getMaxFileStates());
            ModelObjectReaderWriterTest.assertEquals((String)"1.7", (long)prefs.getDefaultLong("description.maxfilestatesize"), (long)desc2.getMaxFileStateSize());
            ModelObjectReaderWriterTest.assertEquals((String)"1.8", (int)prefs.getDefaultInt("snapshots.operations"), (int)desc2.getOperationsPerSnapshot());
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testLongProjectDescription() throws Throwable {
        String longProjectDescription = this.getLongDescription();
        IPath location = this.getRandomLocation();
        try {
            ProjectDescriptionReader reader = new ProjectDescriptionReader();
            this.ensureDoesNotExistInFileSystem(location.toFile());
            ByteArrayInputStream stream = new ByteArrayInputStream(longProjectDescription.getBytes());
            this.createFileInFileSystem(location, (InputStream)stream);
            ProjectDescription projDesc = reader.read(location);
            this.ensureDoesNotExistInFileSystem(location.toFile());
            for (LinkDescription link : projDesc.getLinks().values()) {
                ModelObjectReaderWriterTest.assertEquals((String)("1.0." + link.getProjectRelativePath()), (Object)LONG_LOCATION_URI, (Object)link.getLocationURI());
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testLongProjectDescriptionURI() throws Throwable {
        String longProjectDescription = this.getLongDescriptionURI();
        IPath location = this.getRandomLocation();
        try {
            ProjectDescriptionReader reader = new ProjectDescriptionReader();
            this.ensureDoesNotExistInFileSystem(location.toFile());
            ByteArrayInputStream stream = new ByteArrayInputStream(longProjectDescription.getBytes());
            this.createFileInFileSystem(location, (InputStream)stream);
            ProjectDescription projDesc = reader.read(location);
            this.ensureDoesNotExistInFileSystem(location.toFile());
            for (LinkDescription link : projDesc.getLinks().values()) {
                ModelObjectReaderWriterTest.assertEquals((String)("1.0." + link.getProjectRelativePath()), (Object)LONG_LOCATION_URI, (Object)link.getLocationURI());
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testMultiLineCharFields() throws Throwable {
        String multiLineProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>\n      abc\n   </name>\n\t<charset>\n\t\tISO-8859-1\n\t</charset>\n\t<comment>This is the comment.</comment>\n\t<projects>\n\t   <project>\n         org.eclipse.core.boot\n      </project>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>\n              org.eclipse.jdt.core.javabuilder\n           </name>\n\t\t\t<arguments>\n              <key>thisIsTheKey</key>\n              <value>thisIsTheValue</value>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t   <nature>\n         org.eclipse.jdt.core.javanature\n      </nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>\n              2\n           </type>\n\t\t\t<location>" + PATH_STRING + "</location>\n" + "\t\t</link>\n" + "\t</linkedResources>\n" + "</projectDescription>";
        String singleLineProjectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>abc</name>\n\t<charset>ISO-8859-1</charset>\n\t<comment>This is the comment.</comment>\n\t<projects>\n\t   <project>org.eclipse.core.boot</project>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n\t\t\t<arguments>\n              <key>thisIsTheKey</key>\n              <value>thisIsTheValue</value>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t   <nature>org.eclipse.jdt.core.javanature</nature>\n\t</natures>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>newLink</name>\n\t\t\t<type>2</type>\n\t\t\t<location>" + PATH_STRING + "</location>\n" + "\t\t</link>\n" + "\t</linkedResources>\n" + "</projectDescription>";
        IPath root = ModelObjectReaderWriterTest.getWorkspace().getRoot().getLocation();
        IPath multiLocation = root.append("multiLineTest.txt");
        IPath singleLocation = root.append("singleLineTest.txt");
        ProjectDescriptionReader reader = new ProjectDescriptionReader();
        this.ensureDoesNotExistInFileSystem(multiLocation.toFile());
        this.ensureDoesNotExistInFileSystem(singleLocation.toFile());
        ByteArrayInputStream multiStream = new ByteArrayInputStream(multiLineProjectDescription.getBytes());
        ByteArrayInputStream singleStream = new ByteArrayInputStream(singleLineProjectDescription.getBytes());
        try {
            this.createFileInFileSystem(multiLocation, (InputStream)multiStream);
            this.createFileInFileSystem(singleLocation, (InputStream)singleStream);
            ProjectDescription multiDesc = reader.read(multiLocation);
            ProjectDescription singleDesc = reader.read(singleLocation);
            this.compareProjectDescriptions(1, multiDesc, singleDesc);
        }
        finally {
            Workspace.clear((File)multiLocation.toFile());
            Workspace.clear((File)singleLocation.toFile());
        }
    }

    public void testMultipleProjectDescriptions() throws Throwable {
        URL whereToLook = Platform.getBundle((String)"org.eclipse.core.tests.resources").getEntry("MultipleProjectTestFiles/");
        String[] members = new String[]{"abc.project", "def.project", "org.apache.lucene.project", "org.eclipse.ant.core.project"};
        HashMap<String, ProjectDescription> baselines = this.buildBaselineDescriptors();
        ProjectDescriptionReader reader = new ProjectDescriptionReader();
        int i = 0;
        while (i < members.length) {
            URL currentURL = null;
            currentURL = new URL(whereToLook, members[i]);
            InputStream is = null;
            try {
                is = currentURL.openStream();
            }
            catch (IOException iOException) {
                ModelObjectReaderWriterTest.fail((String)"0.5");
            }
            InputSource in = new InputSource(is);
            ProjectDescription description = reader.read(in);
            this.compareProjectDescriptions(i + 1, description, baselines.get(members[i]));
            ++i;
        }
    }

    public void testProjectDescription() throws Throwable {
        IFileStore tempStore = this.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(3);
        args.put("ArgOne", "ARGH!");
        args.put("ArgTwo", "2 x ARGH!");
        args.put("NullArg", null);
        args.put("EmptyArg", "");
        ICommand[] commands = new ICommand[2];
        commands[0] = description.newCommand();
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        commands[1] = description.newCommand();
        commands[1].setBuilderName("MyOtherCommand");
        commands[1].setArguments(args);
        description.setBuildSpec(commands);
        this.writeDescription(tempStore, description);
        ProjectDescription description2 = this.readDescription(tempStore);
        ModelObjectReaderWriterTest.assertTrue((String)"1.1", (boolean)description.getName().equals(description2.getName()));
        ModelObjectReaderWriterTest.assertEquals((String)"1.2", (Object)location, (Object)description.getLocationURI());
        ICommand[] commands2 = description2.getBuildSpec();
        ModelObjectReaderWriterTest.assertEquals((String)"2.00", (int)2, (int)commands2.length);
        ModelObjectReaderWriterTest.assertEquals((String)"2.01", (String)"MyCommand", (String)commands2[0].getBuilderName());
        ModelObjectReaderWriterTest.assertEquals((String)"2.02", (String)"ARGH!", (String)((String)commands2[0].getArguments().get("ArgOne")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.03", (String)"2 x ARGH!", (String)((String)commands2[0].getArguments().get("ArgTwo")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.04", (String)"", (String)((String)commands2[0].getArguments().get("NullArg")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.05", (String)"", (String)((String)commands2[0].getArguments().get("EmptyArg")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.06", (String)"MyOtherCommand", (String)commands2[1].getBuilderName());
        ModelObjectReaderWriterTest.assertEquals((String)"2.07", (String)"ARGH!", (String)((String)commands2[1].getArguments().get("ArgOne")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.08", (String)"2 x ARGH!", (String)((String)commands2[1].getArguments().get("ArgTwo")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.09", (String)"", (String)((String)commands2[0].getArguments().get("NullArg")));
        ModelObjectReaderWriterTest.assertEquals((String)"2.10", (String)"", (String)((String)commands2[0].getArguments().get("EmptyArg")));
    }

    public void testProjectDescription2() throws Throwable {
        ProjectDescription description2;
        ModelObjectWriter writer = new ModelObjectWriter();
        ProjectDescriptionReader reader = new ProjectDescriptionReader();
        IFileStore tempStore = this.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        HashMap<String, String> args = new HashMap<String, String>(3);
        args.put("ArgOne", "ARGH!");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(args);
        description.setBuildSpec(commands);
        String comment = "Now is the time for all good men to come to the aid of the party.  Now is the time for all good men to come to the aid of the party.  Now is the time for all good men to come to the aid of the party.";
        description.setComment(comment);
        IProject[] refProjects = new IProject[]{ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.runtime"), ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.boot"), ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.core.resources")};
        description.setReferencedProjects(refProjects);
        OutputStream output = tempStore.openOutputStream(0, this.getMonitor());
        writer.write((Object)description, output, System.getProperty("line.separator"));
        output.close();
        try (InputStream input = tempStore.openInputStream(0, this.getMonitor());){
            InputSource in = new InputSource(input);
            description2 = reader.read(in);
        }
        ModelObjectReaderWriterTest.assertTrue((String)"1.1", (boolean)description.getName().equals(description2.getName()));
        ModelObjectReaderWriterTest.assertTrue((String)"1.2", (boolean)location.equals(description.getLocationURI()));
        ICommand[] commands2 = description2.getBuildSpec();
        ModelObjectReaderWriterTest.assertEquals((String)"2.00", (int)1, (int)commands2.length);
        ModelObjectReaderWriterTest.assertEquals((String)"2.01", (String)"MyCommand", (String)commands2[0].getBuilderName());
        ModelObjectReaderWriterTest.assertEquals((String)"2.02", (String)"ARGH!", (String)((String)commands2[0].getArguments().get("ArgOne")));
        ModelObjectReaderWriterTest.assertTrue((String)"3.0", (boolean)description.getComment().equals(description2.getComment()));
        IProject[] ref = description.getReferencedProjects();
        IProject[] ref2 = description2.getReferencedProjects();
        ModelObjectReaderWriterTest.assertEquals((String)"4.0", (int)3, (int)ref2.length);
        ModelObjectReaderWriterTest.assertTrue((String)"4.1", (boolean)ref[0].getName().equals(ref2[0].getName()));
        ModelObjectReaderWriterTest.assertTrue((String)"4.2", (boolean)ref[1].getName().equals(ref2[1].getName()));
        ModelObjectReaderWriterTest.assertTrue((String)"4.3", (boolean)ref[2].getName().equals(ref2[2].getName()));
    }

    public void testProjectDescription3() throws Throwable {
        IFileStore tempStore = this.getTempStore();
        URI location = tempStore.toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        ICommand[] commands = new ICommand[]{description.newCommand()};
        commands[0].setBuilderName("MyCommand");
        commands[0].setArguments(null);
        description.setBuildSpec(commands);
        this.writeDescription(tempStore, description);
        ProjectDescription description2 = this.readDescription(tempStore);
        ModelObjectReaderWriterTest.assertTrue((String)"1.0", (boolean)description.getName().equals(description2.getName()));
        ModelObjectReaderWriterTest.assertEquals((String)"2.0", (Object)location, (Object)description.getLocationURI());
        ICommand[] commands2 = description2.getBuildSpec();
        ModelObjectReaderWriterTest.assertEquals((String)"3.0", (int)1, (int)commands2.length);
        ModelObjectReaderWriterTest.assertEquals((String)"4.0", (String)"MyCommand", (String)commands2[0].getBuilderName());
        ModelObjectReaderWriterTest.assertEquals((String)"5.0", (int)0, (int)commands2[0].getArguments().size());
    }

    public void testProjectDescriptionWithSpaces() throws Throwable {
        IFileStore store = this.getTempStore();
        Path path = new Path("link");
        URI location = store.toURI();
        URI locationWithSpaces = store.getChild("With some spaces").toURI();
        ProjectDescription description = new ProjectDescription();
        description.setLocationURI(location);
        description.setName("MyProjectDescription");
        description.setLinkLocation((IPath)path, this.createLinkDescription((IPath)path, 2, locationWithSpaces));
        this.writeDescription(store, description);
        ProjectDescription description2 = this.readDescription(store);
        ModelObjectReaderWriterTest.assertTrue((String)"1.1", (boolean)description.getName().equals(description2.getName()));
        ModelObjectReaderWriterTest.assertEquals((String)"1.2", (Object)location, (Object)description.getLocationURI());
        ModelObjectReaderWriterTest.assertEquals((String)"1.3", (Object)locationWithSpaces, (Object)description2.getLinkLocationURI((IPath)path));
    }

    public void testWorkspaceDescription() throws Throwable {
        ModelObjectWriter writer = new ModelObjectWriter();
        WorkspaceDescriptionReader reader = new WorkspaceDescriptionReader();
        IPath root = ModelObjectReaderWriterTest.getWorkspace().getRoot().getLocation();
        IPath location = root.append("ModelObjectWriterTest.pbs");
        WorkspaceDescription desc = new WorkspaceDescription("MyWorkspace");
        desc.setName("aName");
        desc.setAutoBuilding(false);
        desc.setApplyFileStatePolicy(false);
        desc.setFileStateLongevity(654321L);
        desc.setMaxFileStates(1000);
        desc.setMaxFileStateSize(123456789L);
        SafeFileOutputStream output = new SafeFileOutputStream(location.toFile());
        writer.write((Object)desc, (OutputStream)output, System.getProperty("line.separator"));
        output.close();
        try {
            FileInputStream input = new FileInputStream(location.toFile());
            WorkspaceDescription desc2 = (WorkspaceDescription)reader.read((InputStream)input);
            ModelObjectReaderWriterTest.assertTrue((String)"1.1", (boolean)desc.getName().equals(desc2.getName()));
            ModelObjectReaderWriterTest.assertTrue((String)"1.2", (desc.isAutoBuilding() == desc2.isAutoBuilding() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.3", (desc.getDeltaExpiration() == desc2.getDeltaExpiration() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.4", (desc.isApplyFileStatePolicy() == desc2.isApplyFileStatePolicy() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.5", (desc.getFileStateLongevity() == desc2.getFileStateLongevity() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.6", (desc.getMaxFileStates() == desc2.getMaxFileStates() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.7", (desc.getMaxFileStateSize() == desc2.getMaxFileStateSize() ? 1 : 0) != 0);
            ModelObjectReaderWriterTest.assertTrue((String)"1.8", (desc.getOperationsPerSnapshot() == desc2.getOperationsPerSnapshot() ? 1 : 0) != 0);
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    protected URI uriFromPortableString(String pathString) {
        return Path.fromPortableString((String)pathString).toFile().toURI();
    }

    private void writeDescription(IFileStore store, ProjectDescription description) throws IOException, CoreException {
        OutputStream output = null;
        try {
            output = store.openOutputStream(0, this.getMonitor());
            new ModelObjectWriter().write((Object)description, output, System.getProperty("line.separator"));
        }
        catch (Throwable throwable) {
            this.assertClose(output);
            throw throwable;
        }
        this.assertClose(output);
    }

    public void testProjectDescriptionWithFiltersAndNullProject() {
        String projectDescription = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>rome_dfw</name>\n\t\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<linkedResources>\n\t\t<link>\n\t\t\t<name>OcdTargetPlugin</name>\n\t\t\t<type>2</type>\n\t\t\t<location>M:/lcruaud.dfw-main-validation/HSI_api/OcdTargetPlugin</location>\n\t\t</link>\n\t</linkedResources>\n\t<filteredResources>\n\t\t<filter>\n\t\t\t<id>1264174785480</id>\n\t\t\t<name></name>\n\t\t\t<type>22</type>\n\t\t\t<matcher>\n\t\t\t\t<id>org.eclipse.ui.ide.patternFilterMatcher</id>\n\t\t\t\t<arguments>*:*</arguments>\n\t\t\t</matcher>\n\t\t</filter>\n\t</filteredResources>\n</projectDescription>\n";
        IPath root = ModelObjectReaderWriterTest.getWorkspace().getRoot().getLocation();
        IPath location = root.append("ModelObjectReaderWriterTest.txt");
        ProjectDescriptionReader reader = new ProjectDescriptionReader();
        this.ensureDoesNotExistInFileSystem(location.toFile());
        ByteArrayInputStream stream = new ByteArrayInputStream(projectDescription.getBytes());
        this.createFileInFileSystem(location, (InputStream)stream);
        try {
            try {
                ProjectDescription projDesc = reader.read(location);
                ModelObjectReaderWriterTest.assertNotNull((String)"1.0", (Object)projDesc);
            }
            catch (IOException e) {
                ModelObjectReaderWriterTest.fail((String)"1.1", (Throwable)e);
                Workspace.clear((File)location.toFile());
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }
}

