/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.utils.Cache;

public class CacheTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(CacheTest.class);
    }

    public void testBasic() {
        Cache cache = new Cache(1);
        cache.addEntry((Object)"foo", (Object)"foo");
        Cache.Entry foo = cache.getEntry((Object)"foo", false);
        CacheTest.assertNotNull((String)"1.0", (Object)foo);
        CacheTest.assertTrue((String)"2.1", (boolean)foo.isTail());
        CacheTest.assertTrue((String)"2.2", (boolean)foo.isHead());
        CacheTest.assertEquals((String)"2.4", (Object)foo, (Object)cache.getTail());
        CacheTest.assertEquals((String)"2.5", (Object)foo, (Object)cache.getHead());
    }

    public void testBasic2() {
        Cache cache = new Cache(2);
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        Cache.Entry foo = cache.getEntry((Object)"foo", false);
        Cache.Entry bar = cache.getEntry((Object)"bar", false);
        CacheTest.assertNotNull((String)"1.0", (Object)foo);
        CacheTest.assertNotNull((String)"1.1", (Object)bar);
        CacheTest.assertTrue((String)"2.0", (boolean)bar.isHead());
        CacheTest.assertTrue((String)"2.1", (boolean)foo.isTail());
        CacheTest.assertEquals((String)"2.4", (Object)bar, (Object)cache.getHead());
        CacheTest.assertEquals((String)"2.5", (Object)foo, (Object)cache.getTail());
        CacheTest.assertTrue((String)"2.8", (!bar.isTail() ? 1 : 0) != 0);
        CacheTest.assertTrue((String)"2.9", (!foo.isHead() ? 1 : 0) != 0);
        CacheTest.assertEquals((String)"3.0", (Object)foo, (Object)bar.getNext());
        CacheTest.assertEquals((String)"3.1", (Object)bar, (Object)foo.getPrevious());
    }

    public void testUpdate() {
        Cache cache = new Cache(2);
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        Cache.Entry foo = cache.getEntry((Object)"foo", true);
        Cache.Entry bar = cache.getEntry((Object)"bar", false);
        CacheTest.assertNotNull((String)"1.0", (Object)foo);
        CacheTest.assertNotNull((String)"1.1", (Object)bar);
        CacheTest.assertTrue((String)"2.0", (boolean)foo.isHead());
        CacheTest.assertTrue((String)"2.1", (boolean)bar.isTail());
        CacheTest.assertEquals((String)"2.4", (Object)foo, (Object)cache.getHead());
        CacheTest.assertEquals((String)"2.5", (Object)bar, (Object)cache.getTail());
        CacheTest.assertTrue((String)"2.8", (!foo.isTail() ? 1 : 0) != 0);
        CacheTest.assertTrue((String)"2.9", (!bar.isHead() ? 1 : 0) != 0);
        CacheTest.assertEquals((String)"3.0", (Object)foo, (Object)bar.getPrevious());
        CacheTest.assertEquals((String)"3.1", (Object)bar, (Object)foo.getNext());
        bar = cache.getEntry((Object)"bar", true);
        CacheTest.assertNotNull((String)"4.1", (Object)bar);
        CacheTest.assertTrue((String)"5.0", (boolean)bar.isHead());
        CacheTest.assertTrue((String)"5.1", (boolean)foo.isTail());
        CacheTest.assertEquals((String)"5.4", (Object)bar, (Object)cache.getHead());
        CacheTest.assertEquals((String)"5.5", (Object)foo, (Object)cache.getTail());
        CacheTest.assertTrue((String)"5.8", (!bar.isTail() ? 1 : 0) != 0);
        CacheTest.assertTrue((String)"5.9", (!foo.isHead() ? 1 : 0) != 0);
        CacheTest.assertEquals((String)"6.0", (Object)foo, (Object)bar.getNext());
        CacheTest.assertEquals((String)"6.1", (Object)bar, (Object)foo.getPrevious());
    }

    public void testDiscardAll() {
        Cache cache = new Cache(2);
        CacheTest.assertNull((String)"1.0", (Object)cache.getHead());
        CacheTest.assertNull((String)"1.1", (Object)cache.getTail());
        CacheTest.assertEquals((String)"1.2", (long)0L, (long)cache.size());
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        cache.discardAll();
        CacheTest.assertNull((String)"2.0", (Object)cache.getHead());
        CacheTest.assertNull((String)"2.1", (Object)cache.getTail());
        CacheTest.assertEquals((String)"2.2", (long)0L, (long)cache.size());
    }

    public void testDiscardHead() {
        Cache cache = new Cache(2);
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        Cache.Entry foo = cache.getEntry((Object)"foo", true);
        Cache.Entry bar = cache.getEntry((Object)"bar", true);
        bar.discard();
        CacheTest.assertNull((String)"1.0", (Object)cache.getEntry((Object)"bar"));
        CacheTest.assertTrue((String)"2.0", (boolean)foo.isHead());
        CacheTest.assertTrue((String)"2.1", (boolean)foo.isTail());
        CacheTest.assertEquals((String)"2.4", (Object)foo, (Object)cache.getHead());
        CacheTest.assertEquals((String)"2.5", (Object)foo, (Object)cache.getTail());
        foo.discard();
        CacheTest.assertNull((String)"3.0", (Object)cache.getEntry((Object)"foo"));
        CacheTest.assertNull((String)"3.1", (Object)cache.getHead());
        CacheTest.assertNull((String)"3.2", (Object)cache.getTail());
    }

    public void testCacheLimit() {
        Cache cache = new Cache(1, 3, 0.33);
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        cache.addEntry((Object)"zoo", (Object)"zoo");
        cache.addEntry((Object)"fred", (Object)"fred");
        cache.addEntry((Object)"zar", (Object)"zar");
        CacheTest.assertEquals((String)"3.0", (long)3L, (long)cache.size());
        CacheTest.assertNull((String)"3.1", (Object)cache.getEntry((Object)"foo"));
        CacheTest.assertNull((String)"3.2", (Object)cache.getEntry((Object)"bar"));
        CacheTest.assertNotNull((String)"3.3", (Object)cache.getEntry((Object)"zoo", false));
        CacheTest.assertNotNull((String)"3.4", (Object)cache.getEntry((Object)"fred", false));
        CacheTest.assertNotNull((String)"3.5", (Object)cache.getEntry((Object)"zar", false));
        cache.getEntry((Object)"fred");
        cache.addEntry((Object)"foo", (Object)"foo");
        cache.addEntry((Object)"bar", (Object)"bar");
        CacheTest.assertEquals((String)"4.0", (long)3L, (long)cache.size());
        CacheTest.assertNotNull((String)"4.1", (Object)cache.getEntry((Object)"foo", false));
        CacheTest.assertNotNull((String)"4.2", (Object)cache.getEntry((Object)"bar", false));
        CacheTest.assertNull((String)"4.3", (Object)cache.getEntry((Object)"zoo", false));
        CacheTest.assertNotNull((String)"4.4", (Object)cache.getEntry((Object)"fred", false));
        CacheTest.assertNull((String)"4.5", (Object)cache.getEntry((Object)"zar", false));
    }
}

