/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ContentDescriptionManagerTest;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CharsetTest
extends ResourceTest {
    static final String SAMPLE_SPECIFIC_XML = "<?xml version=\"1.0\"?><org.eclipse.core.tests.resources.anotherXML/>";
    private static final String SAMPLE_XML_DEFAULT_ENCODING = "<?xml version=\"1.0\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_XML_ISO_8859_1_ENCODING = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_XML_US_ASCII_ENCODING = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><org.eclipse.core.resources.tests.root/>";
    static final String SAMPLE_DERIVED_ENCODING_TO_FALSE_REGULAR_PREFS = "#Mon Nov 15 17:54:11 CET 2010\nseparateDerivedEncodings=false\neclipse.preferences.version=1";
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_FALSE_REGULAR_PREFS = new String[]{"separateDerivedEncodings=false", "encoding//b1/a.txt=UTF-8", "eclipse.preferences.version=1"};
    static final String SAMPLE_DERIVED_ENCODING_TO_TRUE_REGULAR_PREFS = "#Mon Nov 15 17:54:11 CET 2010\nseparateDerivedEncodings=true\nencoding//b1/a.txt=UTF-8\neclipse.preferences.version=1";
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_TRUE_REGULAR_PREFS = new String[]{"separateDerivedEncodings=true", "eclipse.preferences.version=1"};
    static final String[] SAMPLE_DERIVED_ENCODING_AFTER_TRUE_DERIVED_PREFS = new String[]{"encoding//b1/a.txt=UTF-8", "eclipse.preferences.version=1"};
    private String savedWorkspaceCharset;

    public static Test suite() {
        return new TestSuite(CharsetTest.class);
    }

    public CharsetTest(String name) {
        super(name);
    }

    public void _testBug67606() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFile file = project.getFile("file.txt");
            this.ensureExistsInWorkspace((IResource)file, true);
            project.setDefaultCharset("FOO", this.getMonitor());
            workspace.run(monitor -> {
                CharsetTest.assertEquals((String)"0.9", (String)"FOO", (String)file.getCharset());
                file.setCharset("BAR", this.getMonitor());
                CharsetTest.assertEquals((String)"1.0", (String)"BAR", (String)file.getCharset());
                file.move(project.getFullPath().append("file2.txt"), 0, monitor);
                IFile file2 = project.getFile("file2.txt");
                this.assertExistsInWorkspace((IResource)file2, false);
                CharsetTest.assertEquals((String)"2.0", (String)"BAR", (String)file.getCharset());
            }, null);
        }
        finally {
            this.ensureDoesNotExistInWorkspace((IResource)project);
        }
    }

    private void assertCharsetIs(String tag, String encoding, IResource[] resources, boolean checkImplicit) throws CoreException {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String resourceCharset = resource instanceof IFile ? ((IFile)resource).getCharset(checkImplicit) : ((IContainer)resource).getDefaultCharset(checkImplicit);
            CharsetTest.assertEquals((String)(String.valueOf(tag) + " " + resource.getFullPath()), (String)encoding, (String)resourceCharset);
            ++n2;
        }
    }

    private void clearAllEncodings(IResource root) throws CoreException {
        if (root == null || !root.exists()) {
            return;
        }
        IResourceVisitor visitor = resource -> {
            if (!resource.exists()) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    ((IFile)resource).setCharset(null, this.getMonitor());
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    ((IContainer)resource).setDefaultCharset(null, this.getMonitor());
                }
            }
            return true;
        };
        root.accept(visitor);
    }

    private IFile getResourcesPreferenceFile(IProject project, boolean forDerivedResources) {
        if (forDerivedResources) {
            return project.getFolder(".settings").getFile("org.eclipse.core.resources.derived.prefs");
        }
        return project.getFolder(".settings").getFile("org.eclipse.core.resources.prefs");
    }

    private Reader getTextContents(String text) {
        return new StringReader(text);
    }

    private boolean isDerivedEncodingStoredSeparately(IProject project) {
        Preferences node;
        block5: {
            String projectName;
            block4: {
                node = Platform.getPreferencesService().getRootNode().node("project");
                projectName = project.getName();
                try {
                    if (node.nodeExists(projectName)) break block4;
                    return false;
                }
                catch (BackingStoreException backingStoreException) {
                    return false;
                }
            }
            node = node.node(projectName);
            if (node.nodeExists("org.eclipse.core.resources")) break block5;
            return false;
        }
        node = node.node("org.eclipse.core.resources");
        return node.getBoolean("separateDerivedEncodings", false);
    }

    private void setDerivedEncodingStoredSeparately(String tag, IProject project, boolean value) {
        IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.core.resources");
        if (!value) {
            prefs.remove("separateDerivedEncodings");
        } else {
            prefs.putBoolean("separateDerivedEncodings", true);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            CharsetTest.fail((String)tag, (Throwable)e);
        }
    }

    private static IEclipsePreferences getResourcesPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.savedWorkspaceCharset = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
    }

    @Override
    protected void tearDown() throws Exception {
        ResourcesPlugin.getPlugin().getPluginPreferences().setValue("encoding", this.savedWorkspaceCharset);
        CharsetTest.getResourcesPreferences().remove("refresh.lightweight.enabled");
        super.tearDown();
    }

    public void testBug59899() {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getUniqueString());
        try {
            IFile file = project.getFile("file.txt");
            IFolder folder = project.getFolder("folder");
            this.ensureExistsInWorkspace(new IResource[]{file, folder}, true);
            try {
                file.setCharset("FOO", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                folder.setDefaultCharset("BAR", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"2.0", (Throwable)e);
            }
            try {
                project.setDefaultCharset("PROJECT_CHARSET", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.0", (Throwable)e);
            }
            try {
                CharsetTest.getWorkspace().getRoot().setDefaultCharset("ROOT_CHARSET", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"4.0", (Throwable)e);
            }
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testBug62732() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType anotherXML = contentTypeManager.getContentType("org.eclipse.core.tests.resources.anotherXML");
        CharsetTest.assertNotNull((String)"0.5", (Object)anotherXML);
        this.ensureExistsInWorkspace((IResource)project, true);
        IFile file = project.getFile("file.xml");
        this.ensureExistsInWorkspace(file, new ByteArrayInputStream(SAMPLE_SPECIFIC_XML.getBytes(StandardCharsets.UTF_8)));
        IContentDescription description = file.getContentDescription();
        CharsetTest.assertNotNull((String)"1.0", (Object)description);
        CharsetTest.assertEquals((String)"1.1", (Object)anotherXML, (Object)description.getContentType());
        description = file.getContentDescription();
        CharsetTest.assertNotNull((String)"2.0", (Object)description);
        CharsetTest.assertEquals((String)"2.1", (Object)anotherXML, (Object)description.getContentType());
    }

    public void testBug64503() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType text = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IFile file = project.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)file, true);
        IContentDescription description = file.getContentDescription();
        CharsetTest.assertNotNull((String)"1.0", (Object)description);
        CharsetTest.assertEquals((String)"1.1", (Object)text, (Object)description.getContentType());
        this.ensureDoesNotExistInWorkspace((IResource)file);
        try {
            description = file.getContentDescription();
            CharsetTest.fail((String)"1.2 - should have failed");
        }
        catch (CoreException e) {
            CharsetTest.assertEquals((String)"1.3", (int)368, (int)e.getStatus().getCode());
        }
    }

    public void testBug94279() throws CoreException {
        IWorkspaceRoot root = CharsetTest.getWorkspace().getRoot();
        String originalUserCharset = root.getDefaultCharset(false);
        try {
            root.setDefaultCharset(null);
            CharsetTest.assertNull((String)"1.0", (Object)root.getDefaultCharset(false));
        }
        finally {
            if (originalUserCharset != null) {
                root.setDefaultCharset(originalUserCharset);
            }
        }
    }

    public void testBug333056() throws CoreException {
        IProject project = null;
        try {
            IWorkspace workspace = CharsetTest.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            this.ensureExistsInWorkspace((IResource)project, true);
            project.setDefaultCharset("BAR", this.getMonitor());
            IFolder folder = project.getFolder(this.getUniqueString());
            IFile file = folder.getFile(this.getUniqueString());
            CharsetTest.assertEquals((String)"1.0", (String)"BAR", (String)file.getCharset(true));
            this.ensureExistsInWorkspace((IResource)folder, true);
            CharsetTest.assertEquals((String)"2.0", (String)"BAR", (String)file.getCharset(true));
            folder.setDerived(true, this.getMonitor());
            CharsetTest.assertEquals((String)"3.0", (String)"BAR", (String)file.getCharset(true));
            this.setDerivedEncodingStoredSeparately("4.0", project, true);
            CharsetTest.assertEquals((String)"5.0", (String)"BAR", (String)file.getCharset(true));
        }
        catch (Throwable throwable) {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"6.0", (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.clearAllEncodings((IResource)project);
        }
        catch (CoreException e) {
            CharsetTest.fail((String)"6.0", (Throwable)e);
        }
    }

    public void testBug186984() throws Exception {
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", false);
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getUniqueString());
        IFile file = project.getFile("file.xml");
        String ascii = "<?xml version=\"1.0\" encoding=\"ascii\"?>";
        String utf = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        try {
            file.getCharset(true);
        }
        catch (CoreException coreException) {
            CharsetTest.fail((String)"1.0");
        }
        this.ensureExistsInWorkspace((IResource)file, true);
        try {
            if (!file.getLocation().toFile().delete()) {
                CharsetTest.fail((String)"2.0");
            }
            file.getCharset(true);
        }
        catch (CoreException coreException) {
            CharsetTest.fail((String)"2.1");
        }
        this.ensureExistsInFileSystem(file);
        this.ensureOutOfSync(file);
        try {
            file.getCharset(true);
        }
        catch (CoreException coreException) {
            CharsetTest.fail((String)"3.0");
        }
        file.setContents((InputStream)new ByteArrayInputStream(ascii.getBytes("ascii")), 1, this.getMonitor());
        CharsetTest.assertTrue((String)"4.0", (boolean)file.getCharset().equals("ascii"));
        CharsetTest.assertTrue((String)"4.1", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        this.touchInFilesystem((IResource)file);
        CharsetTest.assertTrue((String)"4.2", (boolean)file.getCharset().equals("ascii"));
        try {
            file.getContentDescription().getCharset().equals("ascii");
            CharsetTest.assertTrue((String)"4.3", (boolean)false);
        }
        catch (CoreException e) {
            CharsetTest.assertEquals((String)"4.4", (int)274, (int)e.getStatus().getCode());
        }
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", true);
        CharsetTest.assertTrue((String)"4.5", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        CharsetTest.assertTrue((String)"4.6", (boolean)file.getCharset().equals("ascii"));
        FileWriter writer = new FileWriter(file.getLocation().toFile());
        writer.write(utf);
        writer.close();
        this.touchInFilesystem((IResource)file);
        CharsetTest.assertTrue((String)"5.4", (boolean)file.getCharset().equals("ascii"));
        CharsetTest.assertTrue((String)"5.5", (boolean)file.getContentDescription().getCharset().equals("UTF-8"));
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        CharsetTest.assertTrue((String)"5.6", (boolean)file.getCharset().equals("UTF-8"));
        writer = new FileWriter(file.getLocation().toFile());
        writer.write(ascii);
        writer.close();
        this.touchInFilesystem((IResource)file);
        CharsetTest.assertTrue((String)"6.7", (boolean)file.getCharset().equals("UTF-8"));
        CharsetTest.assertTrue((String)"6.8", (boolean)file.getContentDescription().getCharset().equals("ascii"));
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        CharsetTest.assertTrue((String)"6.9", (boolean)file.getCharset().equals("ascii"));
    }

    public void testBug207510() {
        IWorkspace workspace = CharsetTest.getWorkspace();
        CharsetVerifier verifier = new CharsetVerifier(2);
        CharsetVerifier backgroundVerifier = new CharsetVerifier(1);
        IProject project1 = workspace.getRoot().getProject("project1");
        try {
            workspace.addResourceChangeListener((IResourceChangeListener)verifier, 1);
            workspace.addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
            IFolder a1 = project1.getFolder("a1");
            IFolder b1 = project1.getFolder("b1");
            IFile a = a1.getFile("a.txt");
            this.ensureExistsInWorkspace(new IResource[]{project1, a1, b1, a}, true);
            try {
                verifier.reset();
                verifier.addExpectedChange((IResource)b1, 4, 0x400000);
                b1.setDerived(true, this.getMonitor());
                verifier.waitForEvent(10000L);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"0.1", (Throwable)e);
            }
            IFile regularPrefs = this.getResourcesPreferenceFile(project1, false);
            IFile derivedPrefs = this.getResourcesPreferenceFile(project1, true);
            this.assertDoesNotExistInWorkspace("0.2", (IResource)regularPrefs);
            this.assertDoesNotExistInWorkspace("0.3", (IResource)derivedPrefs);
            verifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs.getParent(), 1, 0);
            verifier.addExpectedChange((IResource)regularPrefs, 1, 0);
            this.setDerivedEncodingStoredSeparately("1.0", project1, true);
            CharsetTest.assertTrue((String)"1.1", (boolean)verifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("1.2 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            this.assertExistsInWorkspace("1.3", (IResource)regularPrefs);
            this.assertDoesNotExistInWorkspace("1.4", (IResource)derivedPrefs);
            CharsetTest.assertTrue((String)"1.5", (boolean)this.isDerivedEncodingStoredSeparately(project1));
            verifier.reset();
            verifier.addExpectedChange((IResource)a, 4, 0x100000);
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            try {
                a.setCharset("UTF-8", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"2.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"2.1", (boolean)verifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("2.2 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            this.assertExistsInWorkspace("2.3", (IResource)regularPrefs);
            this.assertDoesNotExistInWorkspace("2.4", (IResource)derivedPrefs);
            try {
                a.setDerived(true, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.0", (Throwable)e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                CharsetTest.fail((String)"3.0.1", (Throwable)e);
            }
            this.assertExistsInWorkspace("3.1", (IResource)regularPrefs);
            this.assertExistsInWorkspace("3.2", (IResource)derivedPrefs);
            CharsetTest.assertTrue((String)"3.3", (boolean)derivedPrefs.isDerived());
            try {
                a.setDerived(false, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"4.0", (Throwable)e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                CharsetTest.fail((String)"4.0.1", (Throwable)e);
            }
            this.assertExistsInWorkspace("4.1", (IResource)regularPrefs);
            this.assertDoesNotExistInWorkspace("4.2", (IResource)derivedPrefs);
            IFile source = project1.getFolder("a1").getFile("a.txt");
            IFile destination = project1.getFolder("b1").getFile("a.txt");
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 1, 0);
            try {
                a.move(destination.getFullPath(), true, this.getMonitor());
                a = destination;
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"5.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"5.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("5.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            this.assertExistsInWorkspace("5.3", (IResource)regularPrefs);
            this.assertExistsInWorkspace("5.4", (IResource)derivedPrefs);
            this.assertDoesNotExistInWorkspace("5.5", (IResource)source);
            this.assertExistsInWorkspace("5.6", (IResource)destination);
            CharsetTest.assertTrue((String)"5.7", (boolean)derivedPrefs.isDerived());
            try {
                this.assertCharsetIs("5.8", "UTF-8", new IResource[]{a}, true);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"5.8.1", (Throwable)e);
            }
            verifier.reset();
            backgroundVerifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 2, 0);
            this.setDerivedEncodingStoredSeparately("6.0", project1, false);
            CharsetTest.assertTrue((String)"6.1.1", (boolean)verifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)"6.1.2", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("6.2.1 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            CharsetTest.assertTrue((String)("6.2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            this.assertExistsInWorkspace("6.3", (IResource)regularPrefs);
            this.assertDoesNotExistInWorkspace("6.4", (IResource)derivedPrefs);
            verifier.reset();
            backgroundVerifier.reset();
            verifier.addExpectedChange((IResource)regularPrefs, 4, 256);
            backgroundVerifier.addExpectedChange((IResource)derivedPrefs, 1, 0);
            this.setDerivedEncodingStoredSeparately("7.0", project1, true);
            CharsetTest.assertTrue((String)"7.1.1", (boolean)verifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)"7.1.2", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("7.2.1 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            CharsetTest.assertTrue((String)("7.2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            this.assertExistsInWorkspace("7.3", (IResource)regularPrefs);
            this.assertExistsInWorkspace("7.4", (IResource)derivedPrefs);
            CharsetTest.assertTrue((String)"7.5", (boolean)this.isDerivedEncodingStoredSeparately(project1));
            CharsetTest.assertTrue((String)"7.6", (boolean)derivedPrefs.isDerived());
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)verifier);
            workspace.removeResourceChangeListener((IResourceChangeListener)backgroundVerifier);
            try {
                this.clearAllEncodings((IResource)project1);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testBug261994() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IFile file = project1.getFile("file1.xml");
        this.ensureExistsInWorkspace(file, new ByteArrayInputStream(SAMPLE_XML_ISO_8859_1_ENCODING.getBytes(StandardCharsets.ISO_8859_1)));
        ContentDescriptionManagerTest.waitForCacheFlush();
        CharsetTest.assertEquals((String)"1.0", (String)"ISO-8859-1", (String)file.getCharset());
        this.ensureDoesNotExistInWorkspace((IResource)file);
        this.ensureExistsInWorkspace(file, new ByteArrayInputStream(SAMPLE_XML_DEFAULT_ENCODING.getBytes(StandardCharsets.UTF_8)));
        CharsetTest.assertEquals((String)"2.0", (String)"UTF-8", (String)file.getCharset());
    }

    public void testChangesDifferentProject() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IProject project2 = workspace.getRoot().getProject("Project2");
        try {
            IFolder folder = project1.getFolder("folder1");
            IFile file1 = project1.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, project2}, true);
            project1.setDefaultCharset("FOO", this.getMonitor());
            project2.setDefaultCharset("ZOO", this.getMonitor());
            folder.setDefaultCharset("BAR", this.getMonitor());
            folder.move(project2.getFullPath().append("folder"), false, false, null);
            folder = project2.getFolder("folder");
            CharsetTest.assertEquals((String)"1.0", (String)"BAR", (String)folder.getDefaultCharset());
            CharsetTest.assertEquals((String)"1.1", (String)"BAR", (String)folder.getFile("file2.txt").getCharset());
            CharsetTest.assertEquals((String)"2.0", (String)project1.getDefaultCharset(), (String)file1.getCharset());
            file1.move(project2.getFullPath().append("file1.txt"), false, false, null);
            file1 = project2.getFile("file1.txt");
            CharsetTest.assertEquals((String)"2.1", (String)project2.getDefaultCharset(), (String)file1.getCharset());
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project1);
                this.clearAllEncodings((IResource)project2);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testChangesSameProject() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder1");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            project.setDefaultCharset("FOO", this.getMonitor());
            file1.setCharset("FRED", this.getMonitor());
            folder.setDefaultCharset("BAR", this.getMonitor());
            folder.move(project.getFullPath().append("folder2"), false, false, null);
            folder = project.getFolder("folder2");
            CharsetTest.assertEquals((String)"1.0", (String)"BAR", (String)folder.getDefaultCharset());
            CharsetTest.assertEquals((String)"1.1", (String)"BAR", (String)folder.getFile("file2.txt").getCharset());
            file2 = folder.getFile("file2.txt");
            file2.move(project.getFullPath().append("file2.txt"), false, false, null);
            file2 = project.getFile("file2.txt");
            CharsetTest.assertEquals((String)"2.0", (String)project.getDefaultCharset(), (String)file2.getCharset());
            file1.delete(false, false, null);
            this.ensureExistsInWorkspace(new IResource[]{file1}, true);
            CharsetTest.assertEquals((String)"3.0", (String)project.getDefaultCharset(), (String)file1.getCharset());
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testClosingAndReopeningProject() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            project.setDefaultCharset("FOO", this.getMonitor());
            file1.setCharset("FRED", this.getMonitor());
            folder.setDefaultCharset("BAR", this.getMonitor());
            project.close(null);
            IProject projectB = workspace.getRoot().getProject(project.getName());
            projectB.open(null);
            this.assertExistsInWorkspace("0.9", (IResource)this.getResourcesPreferenceFile(projectB, false));
            CharsetTest.assertEquals((String)"1.0", (String)"FOO", (String)projectB.getDefaultCharset());
            CharsetTest.assertEquals((String)"3.0", (String)"FRED", (String)projectB.getFile("file1.txt").getCharset());
            CharsetTest.assertEquals((String)"2.0", (String)"BAR", (String)projectB.getFolder("folder").getDefaultCharset());
            CharsetTest.assertEquals((String)"2.1", (String)"BAR", (String)projectB.getFolder("folder").getFile("file2.txt").getCharset());
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testContentBasedCharset() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            this.ensureExistsInWorkspace((IResource)project, true);
            project.setDefaultCharset("FOO", this.getMonitor());
            IFile file = project.getFile("file.xml");
            CharsetTest.assertEquals((String)"0.9", (String)"FOO", (String)project.getDefaultCharset());
            this.ensureExistsInWorkspace(file, new ByteArrayInputStream(SAMPLE_XML_US_ASCII_ENCODING.getBytes(StandardCharsets.UTF_8)));
            CharsetTest.assertEquals((String)"1.0", (String)"US-ASCII", (String)file.getCharset());
            file.setContents((InputStream)new ByteArrayInputStream(SAMPLE_XML_ISO_8859_1_ENCODING.getBytes(StandardCharsets.ISO_8859_1)), false, false, null);
            CharsetTest.assertEquals((String)"2.0", (String)"ISO-8859-1", (String)file.getCharset());
            file.setContents((InputStream)new ByteArrayInputStream(SAMPLE_XML_DEFAULT_ENCODING.getBytes(StandardCharsets.UTF_8)), false, false, null);
            CharsetTest.assertEquals((String)"3.0", (String)"UTF-8", (String)file.getCharset());
            String UTF8_BOM = new String(IContentDescription.BOM_UTF_8, StandardCharsets.ISO_8859_1);
            file.setContents((InputStream)new ByteArrayInputStream((String.valueOf(UTF8_BOM) + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1)), false, false, null);
            CharsetTest.assertEquals((String)"4.0", (String)"UTF-8", (String)file.getCharset());
            String UTF16_LE_BOM = new String(IContentDescription.BOM_UTF_16LE, StandardCharsets.ISO_8859_1);
            file.setContents((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_LE_BOM) + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1)), false, false, null);
            CharsetTest.assertEquals((String)"5.0", (String)"UTF-16", (String)file.getCharset());
            String UTF16_BE_BOM = new String(IContentDescription.BOM_UTF_16BE, StandardCharsets.ISO_8859_1);
            file.setContents((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_BE_BOM) + SAMPLE_XML_DEFAULT_ENCODING).getBytes(StandardCharsets.ISO_8859_1)), false, false, null);
            CharsetTest.assertEquals((String)"6.0", (String)"UTF-16", (String)file.getCharset());
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testDefaults() throws CoreException {
        IProject project = null;
        String originalCharset = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        try {
            IWorkspace workspace = CharsetTest.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            IFolder folder1 = project.getFolder("folder1");
            IFolder folder2 = folder1.getFolder("folder2");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder1.getFile("file2.txt");
            IFile file3 = folder2.getFile("file3.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, file3}, true);
            this.assertCharsetIs("1.0", ResourcesPlugin.getEncoding(), new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("1.1", null, new IResource[]{project, file1, folder1, file2, folder2, file3}, false);
            workspace.getRoot().setDefaultCharset("FOO", this.getMonitor());
            this.assertCharsetIs("2.0", "FOO", new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("2.1", null, new IResource[]{project, file1, folder1, file2, folder2, file3}, false);
            project.setDefaultCharset("BAR", this.getMonitor());
            this.assertCharsetIs("3.0", "BAR", new IResource[]{project, file1, folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("3.1", null, new IResource[]{file1, folder1, file2, folder2, file3}, false);
            this.assertCharsetIs("3.2", "FOO", new IResource[]{workspace.getRoot()}, true);
            folder1.setDefaultCharset("FRED", this.getMonitor());
            this.assertCharsetIs("4.0", "FRED", new IResource[]{folder1, file2, folder2, file3}, true);
            this.assertCharsetIs("4.1", null, new IResource[]{file2, folder2, file3}, false);
            this.assertCharsetIs("4.2", "BAR", new IResource[]{project, file1}, true);
            folder2.setDefaultCharset("ZOO", this.getMonitor());
            this.assertCharsetIs("5.0", "ZOO", new IResource[]{folder2, file3}, true);
            this.assertCharsetIs("5.1", null, new IResource[]{file3}, false);
            this.assertCharsetIs("5.2", "FRED", new IResource[]{folder1, file2}, true);
            file3.setCharset("ZIT", this.getMonitor());
            this.assertCharsetIs("6.0", "ZIT", new IResource[]{file3}, false);
            folder2.setDefaultCharset(null, this.getMonitor());
            this.assertCharsetIs("7.0", folder2.getParent().getDefaultCharset(), new IResource[]{folder2}, true);
            this.assertCharsetIs("7.1", null, new IResource[]{folder2}, false);
            this.assertCharsetIs("7.2", "ZIT", new IResource[]{file3}, false);
            folder1.setDefaultCharset(null, this.getMonitor());
            this.assertCharsetIs("8.0", folder1.getParent().getDefaultCharset(), new IResource[]{folder1, file2, folder2}, true);
            this.assertCharsetIs("8.1", null, new IResource[]{folder1, file2, folder2}, false);
            this.assertCharsetIs("8.2", "ZIT", new IResource[]{file3}, false);
            project.setDefaultCharset(null, this.getMonitor());
            this.assertCharsetIs("9.0", project.getParent().getDefaultCharset(), new IResource[]{project, file1, folder1, file2, folder2}, true);
            this.assertCharsetIs("9.1", null, new IResource[]{project, file1, folder1, file2, folder2}, false);
            this.assertCharsetIs("9.2", "ZIT", new IResource[]{file3}, false);
            workspace.getRoot().setDefaultCharset(null, this.getMonitor());
            this.assertCharsetIs("10.0", project.getParent().getDefaultCharset(), new IResource[]{project, file1, folder1, file2, folder2}, true);
            this.assertCharsetIs("10.1", "ZIT", new IResource[]{file3}, false);
            file3.setCharset(null, this.getMonitor());
            this.assertCharsetIs("11.0", ResourcesPlugin.getEncoding(), new IResource[]{workspace.getRoot(), project, file1, folder1, file2, folder2, file3}, true);
        }
        finally {
            ResourcesPlugin.getPlugin().getPluginPreferences().setValue("encoding", originalCharset);
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testDeltaOnContentTypeChanges() {
        CharsetVerifier backgroundVerifier = new CharsetVerifier(1);
        CharsetTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType myType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.myContent2");
        CharsetTest.assertNotNull((String)"0.1", (Object)myType);
        CharsetTest.assertEquals((String)"0.2", (String)"PROVIDER_CHARSET", (String)myType.getDefaultCharset());
        IProject project = CharsetTest.getWorkspace().getRoot().getProject("project1");
        try {
            IFolder folder1 = project.getFolder("folder1");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = folder1.getFile("file2.resources-mc");
            IFile file3 = project.getFile("file3.resources-mc");
            IFile file4 = project.getFile("file4.resources-mc");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2, file3, file4}, true);
            try {
                project.setDefaultCharset("FOO", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.0", (Throwable)e);
            }
            try {
                file4.setCharset("BAR", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.1", (Throwable)e);
            }
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{file2, file3, file4}, 4, 0x100000);
            try {
                myType.setDefaultCharset("USER_CHARSET");
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"2.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"2.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            try {
                CharsetTest.assertEquals((String)"3.0", (String)"USER_CHARSET", (String)file2.getCharset());
                CharsetTest.assertEquals((String)"3.1", (String)"USER_CHARSET", (String)file3.getCharset());
                CharsetTest.assertEquals((String)"3.2", (String)"BAR", (String)file4.getCharset());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.9", (Throwable)e);
            }
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{file2, file3, file4}, 4, 0x100000);
            try {
                myType.setDefaultCharset(null);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"4.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"4.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("4.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            try {
                CharsetTest.assertEquals((String)"5.0", (String)"PROVIDER_CHARSET", (String)file2.getCharset());
                CharsetTest.assertEquals((String)"5.1", (String)"PROVIDER_CHARSET", (String)file3.getCharset());
                CharsetTest.assertEquals((String)"5.2", (String)"BAR", (String)file4.getCharset());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"5.9", (Throwable)e);
            }
        }
        finally {
            CharsetTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)backgroundVerifier);
            try {
                myType.setDefaultCharset(null);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.0", (Throwable)e);
            }
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testDeltaOnPreferenceChanges() {
        CharsetVerifier backgroundVerifier = new CharsetVerifier(1);
        CharsetTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)backgroundVerifier, 1);
        IProject project = CharsetTest.getWorkspace().getRoot().getProject("project1");
        try {
            IFolder folder1 = project.getFolder("folder1");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = project.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            IFile resourcesPrefs = this.getResourcesPreferenceFile(project, false);
            CharsetTest.assertTrue((String)"0.9", (!resourcesPrefs.exists() ? 1 : 0) != 0);
            try {
                file1.setCharset("CHARSET1", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"1.1", (boolean)resourcesPrefs.exists());
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{project, folder1, file1, file2, resourcesPrefs, resourcesPrefs.getParent()}, 4, 0x100000);
            try {
                resourcesPrefs.setContents(resourcesPrefs.getContents(), 0, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"2.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"2.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("2.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
            backgroundVerifier.reset();
            backgroundVerifier.addExpectedChange(new IResource[]{project, folder1, file1, file2, resourcesPrefs.getParent()}, 4, 0x100000);
            try {
                resourcesPrefs.delete(true, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)"3.1", (boolean)backgroundVerifier.waitForEvent(10000L));
            CharsetTest.assertTrue((String)("3.2 " + backgroundVerifier.getMessage()), (boolean)backgroundVerifier.isDeltaValid());
        }
        finally {
            CharsetTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)backgroundVerifier);
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testDeltasContainer() {
        CharsetVerifier verifier = new CharsetVerifier(2);
        IProject project = CharsetTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        CharsetTest.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier, 1);
        try {
            IFile prefs = this.getResourcesPreferenceFile(project, false);
            IFolder folder1 = project.getFolder("folder1");
            this.ensureExistsInWorkspace(new IResource[]{project, folder1}, true);
            verifier.reset();
            verifier.addExpectedChange((IResource)folder1, 4, 0x100000);
            verifier.addExpectedChange(new IResource[]{prefs, prefs.getParent()}, 1, 0);
            try {
                folder1.setDefaultCharset("new_charset", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.1." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            IFolder folder2 = folder1.getFolder("folder2");
            IFile file1 = folder1.getFile("file1.txt");
            IFile file2 = folder2.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{folder2, file1, file2}, true);
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, folder2, file1, file2}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                folder1.setDefaultCharset("a_charset", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"2.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("2.1." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            try {
                folder2.setDefaultCharset("non-Default", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.0", (Throwable)e);
            }
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                folder1.setDefaultCharset("newOne", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"3.1", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("3.2." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                folder1.setDefaultCharset("newTwo", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"4.1", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("4.2." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                folder1.setDefaultCharset(null, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"5.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("5.1." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{folder1, file1}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                folder1.setDefaultCharset(project.getDefaultCharset(), this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"6.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("6.1." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"7.0", (Throwable)e);
            }
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{project, folder1, folder2, file1, file2, prefs.getParent()}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs, 1, 0);
            try {
                project.setDefaultCharset("foo", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"7.1", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("7.2." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"8.0", (Throwable)e);
            }
            verifier.reset();
            verifier.addExpectedChange(new IResource[]{project, folder1, folder2, file1, file2, prefs.getParent()}, 4, 0x100000);
            try {
                CharsetTest.getWorkspace().getRoot().setDefaultCharset("foo", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"8.1", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("8.2." + verifier.getMessage()), (boolean)verifier.isDeltaValid());
        }
        finally {
            CharsetTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)verifier);
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testDeltasFile() {
        IWorkspace workspace = CharsetTest.getWorkspace();
        CharsetVerifier verifier = new CharsetVerifier(2);
        workspace.addResourceChangeListener((IResourceChangeListener)verifier, 1);
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFile prefs = this.getResourcesPreferenceFile(project, false);
            IFile file1 = project.getFile("file1.txt");
            this.ensureExistsInWorkspace(file1, this.getRandomContents());
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange(new IResource[]{prefs, prefs.getParent()}, 1, 0);
            try {
                file1.setCharset("FOO", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.0.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.0.1" + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 2, 0);
            try {
                file1.setCharset(null, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.1.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.1.1" + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 1, 0);
            try {
                file1.setCharset(file1.getCharset(), this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.2.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.2.1" + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            try {
                file1.setCharset("FOO", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.3.0", (Throwable)e);
            }
            verifier.reset();
            verifier.addExpectedChange((IResource)file1, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                file1.setCharset("BAR", this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.3.1", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.3.2" + verifier.getMessage()), (boolean)verifier.isDeltaValid());
            verifier.reset();
            IFile file2 = project.getFile("file2.txt");
            this.ensureExistsInWorkspace(file2, this.getRandomContents());
            verifier.addExpectedChange(new IResource[]{file1, file2}, 4, 0x100000);
            verifier.addExpectedChange((IResource)prefs.getParent(), 4, 0);
            verifier.addExpectedChange((IResource)prefs, 4, 256);
            try {
                workspace.run(monitor -> {
                    file1.setCharset("FOO", this.getMonitor());
                    file2.setCharset("FOO", this.getMonitor());
                }, this.getMonitor());
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"1.4.0", (Throwable)e);
            }
            CharsetTest.assertTrue((String)("1.4.1" + verifier.getMessage()), (boolean)verifier.isDeltaValid());
        }
        finally {
            CharsetTest.getWorkspace().removeResourceChangeListener((IResourceChangeListener)verifier);
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testFileCreation() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            IFolder folder = project.getFolder("folder");
            IFile file1 = project.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            this.assertDoesNotExistInWorkspace("1.0", (IResource)this.getResourcesPreferenceFile(project, false));
            project.setDefaultCharset("FOO", this.getMonitor());
            this.assertExistsInWorkspace("2.0", (IResource)this.getResourcesPreferenceFile(project, false));
            project.setDefaultCharset(null, this.getMonitor());
            this.assertDoesNotExistInWorkspace("3.0", (IResource)this.getResourcesPreferenceFile(project, false));
            file1.setCharset("FRED", this.getMonitor());
            this.assertExistsInWorkspace("4.0", (IResource)this.getResourcesPreferenceFile(project, false));
            folder.setDefaultCharset("BAR", this.getMonitor());
            this.assertExistsInWorkspace("5.0", (IResource)this.getResourcesPreferenceFile(project, false));
            file1.setCharset(null, this.getMonitor());
            this.assertExistsInWorkspace("6.0", (IResource)this.getResourcesPreferenceFile(project, false));
            folder.setDefaultCharset(null, this.getMonitor());
            this.assertDoesNotExistInWorkspace("7.0", (IResource)this.getResourcesPreferenceFile(project, false));
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testGetCharsetFor() throws CoreException {
        IProject project = null;
        try {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            IContentType xml = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
            IWorkspace workspace = CharsetTest.getWorkspace();
            project = workspace.getRoot().getProject("MyProject");
            IFile oldFile = project.getFile("oldfile.xml");
            IFile newXMLFile = project.getFile("newfile.xml");
            IFile newTXTFile = project.getFile("newfile.txt");
            IFile newRandomFile = project.getFile("newFile." + (long)(Math.random() * 9.223372036854776E18));
            this.ensureExistsInWorkspace(oldFile, SAMPLE_XML_DEFAULT_ENCODING);
            project.setDefaultCharset("BAR", this.getMonitor());
            oldFile.setCharset("FOO", this.getMonitor());
            this.assertCharsetIs("0.1", "BAR", new IResource[]{project, newXMLFile, newTXTFile, newRandomFile}, true);
            this.assertCharsetIs("0.2", "FOO", new IResource[]{oldFile}, true);
            CharsetTest.assertEquals((String)"1.0", (String)"FOO", (String)oldFile.getCharsetFor(this.getTextContents("")));
            CharsetTest.assertEquals((String)"1.1", (String)"FOO", (String)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            CharsetTest.assertEquals((String)"2.0", (String)xml.getDefaultCharset(), (String)newXMLFile.getCharsetFor(this.getTextContents("")));
            CharsetTest.assertEquals((String)"2.1", (String)xml.getDefaultCharset(), (String)newXMLFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            CharsetTest.assertEquals((String)"2.2", (String)"US-ASCII", (String)newXMLFile.getCharsetFor(this.getTextContents(SAMPLE_XML_US_ASCII_ENCODING)));
            oldFile.setCharset(null, this.getMonitor());
            CharsetTest.assertEquals((String)"2.3", (String)xml.getDefaultCharset(), (String)oldFile.getCharsetFor(this.getTextContents("")));
            CharsetTest.assertEquals((String)"2.4", (String)xml.getDefaultCharset(), (String)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_DEFAULT_ENCODING)));
            CharsetTest.assertEquals((String)"2.5", (String)"US-ASCII", (String)oldFile.getCharsetFor(this.getTextContents(SAMPLE_XML_US_ASCII_ENCODING)));
            CharsetTest.assertEquals((String)"3.0", (String)project.getDefaultCharset(), (String)newTXTFile.getCharsetFor(this.getTextContents("")));
            CharsetTest.assertEquals((String)"3.1", (String)project.getDefaultCharset(), (String)newRandomFile.getCharsetFor(this.getTextContents("")));
        }
        catch (Throwable throwable) {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.clearAllEncodings((IResource)project);
        }
        catch (CoreException e) {
            CharsetTest.fail((String)"99.9", (Throwable)e);
        }
    }

    public void testMovingProject() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project1 = workspace.getRoot().getProject("Project1");
        IProject project2 = null;
        try {
            IFolder folder = project1.getFolder("folder1");
            IFile file1 = project1.getFile("file1.txt");
            IFile file2 = folder.getFile("file2.txt");
            this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
            project1.setDefaultCharset("FOO", this.getMonitor());
            folder.setDefaultCharset("BAR", this.getMonitor());
            CharsetTest.assertEquals((String)"1.0", (String)"BAR", (String)folder.getDefaultCharset());
            CharsetTest.assertEquals((String)"1.1", (String)"BAR", (String)file2.getCharset());
            CharsetTest.assertEquals((String)"1.2", (String)"FOO", (String)file1.getCharset());
            CharsetTest.assertEquals((String)"1.3", (String)"FOO", (String)project1.getDefaultCharset());
            project1.move((IPath)new Path("Project2"), false, null);
            project2 = workspace.getRoot().getProject("Project2");
            folder = project2.getFolder("folder1");
            file1 = project2.getFile("file1.txt");
            file2 = folder.getFile("file2.txt");
            CharsetTest.assertEquals((String)"2.0", (String)"BAR", (String)folder.getDefaultCharset());
            CharsetTest.assertEquals((String)"2.1", (String)"BAR", (String)file2.getCharset());
            CharsetTest.assertEquals((String)"2.2", (String)"FOO", (String)project2.getDefaultCharset());
            CharsetTest.assertEquals((String)"2.3", (String)"FOO", (String)file1.getCharset());
        }
        catch (Throwable throwable) {
            try {
                this.clearAllEncodings((IResource)project1);
                this.clearAllEncodings((IResource)project2);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.clearAllEncodings((IResource)project1);
            this.clearAllEncodings((IResource)project2);
        }
        catch (CoreException e) {
            CharsetTest.fail((String)"99.9", (Throwable)e);
        }
    }

    public void testNonExistingResource() throws CoreException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("MyProject");
        try {
            try {
                project.setDefaultCharset("FOO", this.getMonitor());
                CharsetTest.fail((String)"1.0");
            }
            catch (CoreException e) {
                CharsetTest.assertEquals((String)"1.1", (int)368, (int)e.getStatus().getCode());
            }
            this.ensureExistsInWorkspace((IResource)project, true);
            project.setDefaultCharset("FOO", this.getMonitor());
            IFile file = project.getFile("file.xml");
            this.assertDoesNotExistInWorkspace("2.0", (IResource)file);
            CharsetTest.assertEquals((String)"2.2", (String)"FOO", (String)file.getCharset());
            try {
                file.setCharset("BAR", this.getMonitor());
                CharsetTest.fail((String)"2.4");
            }
            catch (CoreException e) {
                CharsetTest.assertEquals((String)"2.6", (int)368, (int)e.getStatus().getCode());
            }
            this.ensureExistsInWorkspace((IResource)file, true);
            file.setCharset("BAR", this.getMonitor());
            CharsetTest.assertEquals((String)"2.8", (String)"BAR", (String)file.getCharset());
            file.delete(0, null);
            this.assertDoesNotExistInWorkspace("2.10", (IResource)file);
            CharsetTest.assertEquals((String)"2.11", (String)"FOO", (String)file.getCharset());
        }
        finally {
            try {
                this.clearAllEncodings((IResource)project);
            }
            catch (CoreException e) {
                CharsetTest.fail((String)"99.9", (Throwable)e);
            }
        }
    }

    public void testBug464072() throws CoreException {
        CharsetTest.getResourcesPreferences().putBoolean("refresh.lightweight.enabled", true);
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getUniqueString());
        IFile file = project.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)file, true);
        file.getLocation().toFile().delete();
        try {
            file.getContentDescription();
            CharsetTest.fail((String)"1.2 - should have failed");
        }
        catch (CoreException e) {
            CharsetTest.assertEquals((String)"1.3", (int)368, (int)e.getStatus().getCode());
        }
    }

    public void testBug528827() throws CoreException, OperationCanceledException, InterruptedException {
        IWorkspace workspace = CharsetTest.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        JobChangeAdapterExtension listener = new JobChangeAdapterExtension();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        try {
            String otherCharset = this.getOtherCharset(workspace.getRoot().getDefaultCharset());
            project.setDefaultCharset(otherCharset, this.getMonitor());
            CharsetTest.assertEquals((String)otherCharset, (String)project.getDefaultCharset());
            project.delete(false, this.getMonitor());
            Thread.sleep(100L);
            Job.getJobManager().join((Object)"org.eclipse.core.resourcescharsetJobFamily", this.getMonitor());
            CharsetTest.assertTrue((boolean)listener.getResult().isOK());
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
    }

    private String getOtherCharset(String referenceCharset) {
        return "MIK".equals(referenceCharset) ? "UTF-8" : "MIK";
    }

    public class CharsetVerifier
    extends ResourceDeltaVerifier {
        static final int IGNORE_BACKGROUND_THREAD = 2;
        static final int IGNORE_CREATION_THREAD = 1;
        private final Thread creationThread = Thread.currentThread();
        private final int flags;

        CharsetVerifier(int flags) {
            this.flags = flags;
        }

        @Override
        void internalVerifyDelta(IResourceDelta delta) {
            IPath path = delta.getFullPath();
            if (path.segmentCount() == 2 && path.segment(1).equals(".project")) {
                return;
            }
            super.internalVerifyDelta(delta);
        }

        private boolean isSet(int mask) {
            return (mask & this.flags) == mask;
        }

        @Override
        public synchronized void resourceChanged(IResourceChangeEvent e) {
            if (this.isSet(2) && Thread.currentThread() != this.creationThread) {
                return;
            }
            if (this.isSet(1) && Thread.currentThread() == this.creationThread) {
                return;
            }
            super.resourceChanged(e);
            ((Object)((Object)this)).notify();
        }

        public synchronized boolean waitForEvent(long limit) {
            if (this.hasBeenNotified()) {
                return true;
            }
            try {
                ((Object)((Object)this)).wait(limit);
            }
            catch (InterruptedException interruptedException) {}
            return this.hasBeenNotified();
        }
    }

    private final class JobChangeAdapterExtension
    extends JobChangeAdapter {
        private IStatus result;

        public void done(IJobChangeEvent event) {
            if (event.getJob().belongsTo((Object)"org.eclipse.core.resourcescharsetJobFamily")) {
                this.result = event.getResult();
            }
        }

        IStatus getResult() {
            return this.result;
        }
    }
}

