/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class IProjectDescriptionTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(IProjectDescriptionTest.class);
    }

    public IProjectDescriptionTest() {
    }

    public IProjectDescriptionTest(String name) {
        super(name);
    }

    public void testDescriptionConstant() {
        IProjectDescriptionTest.assertEquals((String)"1.0", (String)".project", (String)".project");
    }

    public void testBuildSpecBuilder() throws Exception {
        Project project = (Project)IProjectDescriptionTest.getWorkspace().getRoot().getProject("ProjectTBSB");
        this.ensureExistsInWorkspace((IResource)project, true);
        project.refreshLocal(2, null);
        IFile descriptionFile = project.getFile(".project");
        IProjectDescriptionTest.assertTrue((String)"1.0", (boolean)descriptionFile.exists());
        IProjectDescription desc = project.getDescription();
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.core.tests.resources.flexbuilder");
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, null);
        project.build(6, null);
        IProjectDescriptionTest.assertTrue((String)"2.0", (((BuildCommand)project.internalGetDescription().getBuildSpec(false)[0]).getBuilders() != null ? 1 : 0) != 0);
        desc = project.getDescription();
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, null);
        IProjectDescriptionTest.assertTrue((String)"3.0", (((BuildCommand)project.internalGetDescription().getBuildSpec(false)[0]).getBuilders() != null ? 1 : 0) != 0);
    }

    public void testDirtyDescription() {
        IProjectDescription description;
        IProject project = IProjectDescriptionTest.getWorkspace().getRoot().getProject("Project");
        IProject target1 = IProjectDescriptionTest.getWorkspace().getRoot().getProject("target1");
        IProject target2 = IProjectDescriptionTest.getWorkspace().getRoot().getProject("target2");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFile descriptionFile = project.getFile(".project");
        IProjectDescriptionTest.assertTrue((String)"1.0", (boolean)descriptionFile.exists());
        long timestamp = descriptionFile.getLocalTimeStamp();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e1) {
            IProjectDescriptionTest.fail((String)"1.99", (Throwable)e1);
        }
        try {
            description = project.getDescription();
            description.setBuildSpec(description.getBuildSpec());
            description.setComment(description.getComment());
            description.setDynamicReferences(description.getDynamicReferences());
            description.setLocation(description.getLocation());
            description.setName(description.getName());
            description.setNatureIds(description.getNatureIds());
            description.setReferencedProjects(description.getReferencedProjects());
            project.setDescription(description, 0, null);
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"2.99", (Throwable)e);
        }
        IProjectDescriptionTest.assertEquals((String)"2.0", (long)timestamp, (long)descriptionFile.getLocalTimeStamp());
        try {
            description = project.getDescription();
            description.setDynamicReferences(new IProject[]{target1, target2});
            project.setDescription(description, 0, null);
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"3.99", (Throwable)e);
        }
        IProjectDescriptionTest.assertEquals((String)"2.1", (long)timestamp, (long)descriptionFile.getLocalTimeStamp());
    }

    public void testDirtyBuildSpec() {
        IProject project = IProjectDescriptionTest.getWorkspace().getRoot().getProject("Project");
        IFile projectDescription = project.getFile(".project");
        this.ensureExistsInWorkspace((IResource)project, true);
        String key = "key";
        String value1 = "value1";
        String value2 = "value2";
        try {
            IProjectDescription description = project.getDescription();
            ICommand newCommand = description.newCommand();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(key, value1);
            newCommand.setArguments(args);
            description.setBuildSpec(new ICommand[]{newCommand});
            project.setDescription(description, 0, null);
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"1.99", (Throwable)e);
        }
        long modificationStamp = projectDescription.getModificationStamp();
        try {
            IProjectDescription description = project.getDescription();
            ICommand command = description.getBuildSpec()[0];
            Map args = command.getArguments();
            args.put(key, value2);
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            project.setDescription(description, 0, null);
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"2.99", (Throwable)e);
        }
        IProjectDescriptionTest.assertTrue((String)"3.0", (modificationStamp != projectDescription.getModificationStamp() ? 1 : 0) != 0);
    }

    public void testDynamicProjectReferences() {
        IProject target1 = IProjectDescriptionTest.getWorkspace().getRoot().getProject("target1");
        IProject target2 = IProjectDescriptionTest.getWorkspace().getRoot().getProject("target2");
        this.ensureExistsInWorkspace((IResource)target1, true);
        this.ensureExistsInWorkspace((IResource)target2, true);
        IProject project = IProjectDescriptionTest.getWorkspace().getRoot().getProject("project");
        this.ensureExistsInWorkspace((IResource)project, true);
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"1.0", (Throwable)e);
        }
        description.setReferencedProjects(new IProject[]{target1});
        description.setDynamicReferences(new IProject[]{target2});
        try {
            project.setDescription(description, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"2.0", (Throwable)e);
        }
        IProject[] refs = null;
        try {
            refs = project.getReferencedProjects();
        }
        catch (CoreException e2) {
            IProjectDescriptionTest.fail((String)"2.99", (Throwable)e2);
        }
        IProjectDescriptionTest.assertEquals((String)"2.1", (int)2, (int)refs.length);
        IProjectDescriptionTest.assertEquals((String)"2.2", (Object)target1, (Object)refs[0]);
        IProjectDescriptionTest.assertEquals((String)"2.3", (Object)target2, (Object)refs[1]);
        IProjectDescriptionTest.assertEquals((String)"2.4", (int)1, (int)target1.getReferencingProjects().length);
        IProjectDescriptionTest.assertEquals((String)"2.5", (int)1, (int)target2.getReferencingProjects().length);
        try {
            IProjectDescriptionTest.getWorkspace().getRoot().getProject("DoesNotExist").getReferencedProjects();
            IProjectDescriptionTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
    }

    public void testProjectReferences() {
        IProject target = IProjectDescriptionTest.getWorkspace().getRoot().getProject("Project1");
        this.ensureExistsInWorkspace((IResource)target, true);
        IProject project = IProjectDescriptionTest.getWorkspace().getRoot().getProject("Project2");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"0.0", (Throwable)e);
        }
        IProjectDescription description = null;
        try {
            description = project.getDescription();
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"1.0", (Throwable)e);
        }
        description.setReferencedProjects(new IProject[]{target});
        try {
            project.setDescription(description, this.getMonitor());
        }
        catch (CoreException e) {
            IProjectDescriptionTest.fail((String)"2.0", (Throwable)e);
        }
        IProjectDescriptionTest.assertEquals((String)"2.1", (int)1, (int)target.getReferencingProjects().length);
        try {
            IProjectDescriptionTest.getWorkspace().getRoot().getProject("DoesNotExist").getReferencedProjects();
            IProjectDescriptionTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        IProject[] refs = IProjectDescriptionTest.getWorkspace().getRoot().getProject("DoesNotExist2").getReferencingProjects();
        IProjectDescriptionTest.assertEquals((String)"4.0", (int)0, (int)refs.length);
    }
}

