/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class IResourceDeltaTest
extends ResourceTest {
    protected IProject project1;
    protected IProject project2;
    protected IFolder folder1;
    protected IFolder folder2;
    protected IFolder folder3;
    protected IFile file1;
    protected IFile file2;
    protected IFile file3;
    protected IFile file4;
    protected IResource[] allResources;

    public IResourceDeltaTest() {
    }

    public IResourceDeltaTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project1 = IResourceDeltaTest.getWorkspace().getRoot().getProject("Project1");
        this.project2 = IResourceDeltaTest.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("Folder3");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File3");
        this.file4 = this.folder1.getFile("File4");
        this.allResources = new IResource[]{this.project1, this.project2, this.folder1, this.folder2, this.folder3, this.file1, this.file2, this.file3};
        IWorkspaceRunnable body = monitor -> this.ensureExistsInWorkspace(this.allResources, true);
        try {
            IResourceDeltaTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceDeltaTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public static Test suite() {
        return new TestSuite(IResourceDeltaTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.ensureDoesNotExistInWorkspace((IResource)IResourceDeltaTest.getWorkspace().getRoot());
    }

    public void testFindMember() {
        IResourceChangeListener listener = event -> {
            IResourceDelta delta = event.getDelta();
            IResourceDeltaTest.assertNotNull((String)"1.0", (Object)delta.findMember(this.project1.getFullPath()));
            IResourceDeltaTest.assertNotNull((String)"1.1", (Object)delta.findMember(this.file1.getFullPath()));
            IResourceDeltaTest.assertNotNull((String)"1.2", (Object)delta.findMember(this.folder2.getFullPath()));
            IResourceDeltaTest.assertNotNull((String)"1.3", (Object)delta.findMember(this.file3.getFullPath()));
            IResourceDeltaTest.assertNotNull((String)"1.4", (Object)delta.findMember(this.file4.getFullPath()));
            IResourceDeltaTest.assertNull((String)"1.5", (Object)delta.findMember(this.project2.getFullPath()));
            IResourceDeltaTest.assertNull((String)"1.6", (Object)delta.findMember(this.file2.getFullPath()));
            IResourceDeltaTest.assertNull((String)"1.7", (Object)delta.findMember(this.folder3.getFullPath()));
            delta = delta.findMember(this.project1.getFullPath());
            IResourceDeltaTest.assertNotNull((String)"2.1", (Object)delta.findMember(this.file1.getProjectRelativePath()));
            IResourceDeltaTest.assertNotNull((String)"2.2", (Object)delta.findMember(this.folder2.getProjectRelativePath()));
            IResourceDeltaTest.assertNotNull((String)"2.3", (Object)delta.findMember(this.file3.getProjectRelativePath()));
            IResourceDeltaTest.assertNotNull((String)"2.4", (Object)delta.findMember(this.file4.getProjectRelativePath()));
            IResourceDeltaTest.assertNull((String)"2.5", (Object)delta.findMember(this.project2.getFullPath()));
            IResourceDeltaTest.assertNull((String)"2.6", (Object)delta.findMember(this.file2.getProjectRelativePath()));
            IResourceDeltaTest.assertNull((String)"2.7", (Object)delta.findMember(this.folder3.getProjectRelativePath()));
            IResourceDeltaTest.assertNull((String)"2.8", (Object)delta.findMember(this.project1.getFullPath()));
            IResourceDeltaTest.assertNull((String)"2.9", (Object)delta.findMember(this.file1.getFullPath()));
            delta = delta.findMember(this.file1.getProjectRelativePath());
            IResourceDeltaTest.assertEquals((String)"3.1", (Object)delta, (Object)delta.findMember((IPath)Path.ROOT));
            IResourceDeltaTest.assertNull((String)"3.2", (Object)delta.findMember((IPath)new Path("foo")));
        };
        IResourceDeltaTest.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            this.file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.folder2.delete(true, this.getMonitor());
            this.file4.create(this.getRandomContents(), true, this.getMonitor());
        };
        try {
            try {
                IResourceDeltaTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                IResourceDeltaTest.fail((String)"Exception1", (Throwable)e);
                IResourceDeltaTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceDeltaTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }
}

